pro wxf_sunrim1,img,xc,yc,radius,im,dev
;+
; NAME:
;    wxf_sunrim1 is third version of wxf_sunrim.pro which uses arithmetical average
;    to look for solar disk center and radius. The second version uses Least Squares
;    fitting to look for solar disk center and radius even if there is only one quarter of
;    solar disk on your CCD.
; PURPOSE:
;    Calculate diameter and center coordinates of accurate full disk
;    solar images.If the solar image is not complete,mistakes will not happen.
;    It still can acquire diameter and center of the sun.
;    ;
; CATEGORY:
;    Hairou scientific group.
;    Image Processing.
;
; CALLING SEQUENCE:
;    wxf_sunrim1,image,xc,yc,radius,range
;
; INPUTS:
;    image: Image frame.
;    range: a parameter where my program begins to search the lowest
;                rim of fast changing intensity( to be continuing)
;
; OUTPUTS:
;     xc,yc,radius
;
; KEYWORDS:
;    range(optional), default value=0.15,usually range<0.5
;
; MODIFICATION HISTORY:
;    2007-01-20: Xiaofan Wang, Huairou Solar Observing Station
;    National  Astronomical Observatories Chinese Academy of Science
;    It's my great honour if you use my routine instead of center_sobel.pro+fit_circle.pro.
;    Please let me know any bugs in this routine(wxf@bao.ac.cn)
;    2008-02: Xiaofan Wang
;   
a=img
print,mean(a)
ss=size(a)
xsize=ss(1)
ysize=ss(2)
device,retain=2
;b=widget_base()
;draw=widget_draw(b,xsize=1016,ysize=1020,x_scroll_size=992,y_scroll_size=1004/3)
;widget_control,b,/realize
window,10,xs=xsize/3,ys=ysize/3
;wshow,10,/iconic
;wset,10win
tvscl,congrid(a,xsize/3.,ysize/3.,/interp)

xl=mean(a(0:600,*)) & xr=mean(a(xsize-600:xsize-1,*));300,500
yd=mean(a(*,0:600)) & yu=mean(a(*,ysize-600:ysize-1));600
x=total(a,2)/ysize/mean(a) & y=total(a,1)/xsize/mean(a)

;1 ��Բ
if xl lt mean(a) and xr lt mean(a) and yd lt mean(a) and yu lt mean(a)$
then begin
print,'1����'
x1=min(where(x gt 0.7 and x lt 0.8))
x2=max(where(x gt 0.7 and x lt 0.8))
y1=min(where(y gt 0.7 and y lt 0.8))
y2=max(where(y gt 0.7 and y lt 0.8))
point=fltarr(2*(x2-x1+1)+2*(y2-y1+1),2)

for i=x1,x2 do begin
dao=a(i,*)
lim=max(dao)-min(dao)
s2=where(dao ge min(dao)+0.4*lim and dao lt max(dao),count2)
l1=0 & l4=ysize-1
l2=mean(s2)-0.5*count2 & l3=mean(s2)+0.5*count2
ss1=double(lindgen(l2))
ss2=double(lindgen(l4-l3)+long(l3))
guai1=deriv(ss1,dao(ss1)) & guai2=deriv(ss2,dao(ss2))
guai1(0:3)=0 &guai2(n_elements(guai2)-3:n_elements(guai2)-1)=0
point1=where(guai1 eq max(guai1)) & point2=where(guai2 eq min(guai2))
point1=point1(0) & point2=point2(0)
point2=round(l3)+point2
;print,'point1=',i,point1 & print,'point2=',i,point2
point(i-x1,0)=i & point(i-x1,1)=point1
point(i-x1+x2-x1+1,0)=i & point(i-x1+x2-x1+1,1)=point2
xyouts,ALIGNMENT=0.5,i/3.,point1/3.,'.',color=150,/dev
xyouts,ALIGNMENT=0.5,i/3.,point2/3.,'.',color=150,/dev
endfor
for i=y1,y2 do begin
dao=a(*,i)
lim=max(dao)-min(dao)
s2=where(dao ge min(dao)+0.4*lim and dao lt max(dao),count2)
l1=0 & l4=xsize-1
l2=mean(s2)-0.5*count2 & l3=mean(s2)+0.5*count2
ss1=double(lindgen(l2))
ss2=double(lindgen(l4-l3)+long(l3))
guai1=deriv(ss1,dao(ss1)) & guai2=deriv(ss2,dao(ss2))
guai1(0:3)=0 &guai2(n_elements(guai2)-3:n_elements(guai2)-1)=0
point1=where(guai1 eq max(guai1)) & point2=where(guai2 eq min(guai2))
point1=point1(0) & point2=point2(0)
point2=round(l3)+point2
;print,'point1=',point1,i & print,'point2=',point2,i
point(x2-x1+1+x2-x1+1+i-y1,0)=point1 & point(x2-x1+1+x2-x1+1+i-y1,1)=i
point(x2-x1+1+x2-x1+1+y2-y1+1+i-y1,0)=point2 & point(x2-x1+1+x2-x1+1+y2-y1+1+i-y1,1)=i
xyouts,ALIGNMENT=0.5,point1/3.,i/3.,'.',color=150,/dev
xyouts,ALIGNMENT=0.5,point2/3.,i/3.,'.',color=150,/dev
endfor
endif


;2
if xl lt mean(a) and xr gt mean(a) and yd lt mean(a) and yu lt mean(a)$
then begin
print,'2����'
x1=min(where(x gt 0.7 and x lt 0.8))
x2=xsize-20
y1=min(where(y gt 0.7 and y lt 0.8))
y2=max(where(y gt 0.7 and y lt 0.8))
point=fltarr(2*(x2-x1+1)+1*(y2-y1+1),2)

for i=x1,x2 do begin
dao=a(i,*)
lim=max(dao)-min(dao)
s2=where(dao ge min(dao)+0.4*lim and dao lt max(dao),count2)
l1=0 & l4=ysize-1
l2=mean(s2)-0.5*count2 & l3=mean(s2)+0.5*count2
ss1=double(lindgen(l2))
ss2=double(lindgen(l4-l3)+long(l3))
guai1=deriv(ss1,dao(ss1)) & guai2=deriv(ss2,dao(ss2))
guai1(0:3)=0 &guai2(n_elements(guai2)-3:n_elements(guai2)-1)=0
point1=where(guai1 eq max(guai1)) & point2=where(guai2 eq min(guai2))
point1=point1(0) & point2=point2(0)
point2=round(l3)+point2
point(i-x1,0)=i & point(i-x1,1)=point1
point(i-x1+x2-x1+1,0)=i & point(i-x1+x2-x1+1,1)=point2
xyouts,ALIGNMENT=0.5,i/3,point1/3,'.',color=150,/dev
xyouts,ALIGNMENT=0.5,i/3,point2/3,'.',color=150,/dev
endfor
for i=y1,y2 do begin
dao=a(*,i)
lim=max(dao)-min(dao)
s2=where(dao ge min(dao)+0.4*lim and dao lt max(dao),count2)
l1=0 & l4=xsize-1
l2=mean(s2)-0.5*count2
ss1=double(lindgen(l2))
guai1=deriv(ss1,dao(ss1))
guai1(0:3)=0
point1=where(guai1 eq max(guai1))
point1=point1(0)
point(x2-x1+1+x2-x1+1+i-y1,0)=point1 & point(x2-x1+1+x2-x1+1+i-y1,1)=i
xyouts,ALIGNMENT=0.5,point1/3,i/3,'.',color=150,/dev
endfor
endif

;3
if xl lt mean(a) and xr gt mean(a) and yd lt mean(a) and yu gt mean(a)$
then begin
print,'3����'
x1=min(where(x gt 0.7 and x lt 0.8))
x2=xsize-20
y1=min(where(y gt 0.7 and y lt 0.8))
y2=ysize-20
point=fltarr(1*(x2-x1+1)+1*(y2-y1+1),2)

for i=x1,x2 do begin
dao=a(i,*)
lim=max(dao)-min(dao)
s2=where(dao ge min(dao)+0.4*lim and dao lt max(dao),count2)
l1=0 & l4=ysize-1
l2=mean(s2)-0.5*count2
ss1=double(lindgen(l2))
guai1=deriv(ss1,dao(ss1))
guai1(0:3)=0
point1=where(guai1 eq max(guai1))
point1=point1(0)
point(i-x1,0)=i & point(i-x1,1)=point1
xyouts,ALIGNMENT=0.5,i/3,point1/3,'.',color=150,/dev
endfor
for i=y1,y2 do begin
dao=a(*,i)
lim=max(dao)-min(dao)
s2=where(dao ge min(dao)+0.4*lim and dao lt max(dao),count2)
l1=0 & l4=xsize-1
l2=mean(s2)-0.5*count2
ss1=double(lindgen(l2))
guai1=deriv(ss1,dao(ss1))
guai1(0:3)=0
point1=where(guai1 eq max(guai1))
point1=point1(0)
point(x2-x1+1+i-y1,0)=point1 & point(x2-x1+1+i-y1,1)=i
xyouts,ALIGNMENT=0.5,point1/3,i/3,'.',color=150,/dev
endfor
endif

;4
if xl lt mean(a) and xr lt mean(a) and yd lt mean(a) and yu gt mean(a)$
then begin
print,'4����'
x1=min(where(x gt 0.7 and x lt 0.8))
x2=max(where(x gt 0.7 and x lt 0.8))
y1=min(where(y gt 0.7 and y lt 0.8))
y2=ysize-20
point=fltarr(1*(x2-x1+1)+2*(y2-y1+1),2)

for i=x1,x2 do begin
dao=a(i,*)
lim=max(dao)-min(dao)
s2=where(dao ge min(dao)+0.4*lim and dao lt max(dao),count2)
l1=0
l2=mean(s2)-0.5*count2
ss1=double(lindgen(l2))
guai1=deriv(ss1,dao(ss1))
guai1(0:3)=0
point1=where(guai1 eq max(guai1))
point1=point1(0)
point(i-x1,0)=i & point(i-x1,1)=point1
xyouts,ALIGNMENT=0.5,i/3,point1/3,'.',color=150,/dev
endfor
for i=y1,y2 do begin
dao=a(*,i)
lim=max(dao)-min(dao)
s2=where(dao ge min(dao)+0.4*lim and dao lt max(dao),count2)
l1=0 & l4=xsize-1
l2=mean(s2)-0.5*count2 & l3=mean(s2)+0.5*count2
ss1=double(lindgen(l2))
ss2=double(lindgen(l4-l3)+long(l3))
guai1=deriv(ss1,dao(ss1)) & guai2=deriv(ss2,dao(ss2))
guai1(0:3)=0 &guai2(n_elements(guai2)-3:n_elements(guai2)-1)=0
point1=where(guai1 eq max(guai1)) & point2=where(guai2 eq min(guai2))
point1=point1(0) & point2=point2(0)
point2=round(l3)+point2
point(x2-x1+1+i-y1,0)=point1 & point(x2-x1+1+i-y1,1)=i
point(x2-x1+1+y2-y1+1+i-y1,0)=point2 & point(x2-x1+1+y2-y1+1+i-y1,1)=i
xyouts,ALIGNMENT=0.5,point1/3,i/3,'.',color=150,/dev
xyouts,ALIGNMENT=0.5,point2/3,i/3,'.',color=150,/dev
endfor
endif

;5
if xl gt mean(a) and xr lt mean(a) and yd lt mean(a) and yu gt mean(a)$
then begin
print,'5����'
x1=20
x2=max(where(x gt 0.7 and x lt 0.8))
y1=min(where(y gt 0.7 and y lt 0.8))
y2=ysize-20
point=fltarr(1*(x2-x1+1)+1*(y2-y1+1),2)

for i=x1,x2 do begin
dao=a(i,*)
lim=max(dao)-min(dao)
s2=where(dao ge min(dao)+0.4*lim and dao lt max(dao),count2)
l1=0 & l4=ysize-1
l2=mean(s2)-0.5*count2
ss1=double(lindgen(l2))
guai1=deriv(ss1,dao(ss1))
guai1(0:3)=0
point1=where(guai1 eq max(guai1))
point1=point1(0)
point(i-x1,0)=i & point(i-x1,1)=point1
xyouts,ALIGNMENT=0.5,i/3,point1/3,'.',color=150,/dev
endfor
for i=y1,y2 do begin
dao=a(*,i)
lim=max(dao)-min(dao)
s2=where(dao ge min(dao)+0.4*lim and dao lt max(dao),count2)
l4=xsize-1
l3=mean(s2)+0.5*count2
ss2=double(lindgen(l4-l3)+long(l3))
guai2=deriv(ss2,dao(ss2))
guai2(n_elements(guai2)-3:n_elements(guai2)-1)=0
point2=where(guai2 eq min(guai2))
point2=point2(0)
point2=round(l3)+point2
point(x2-x1+1+i-y1,0)=point2 & point(x2-x1+1+i-y1,1)=i
xyouts,ALIGNMENT=0.5,point2/3,i/3,'.',color=150,/dev
endfor
endif



;6
if xl gt mean(a) and xr lt mean(a) and yd lt mean(a) and yu lt mean(a)$
then begin
print,'6����'
x1=20
x2=max(where(x gt 0.7 and x lt 0.8))
y1=min(where(y gt 0.7 and y lt 0.8))
y2=max(where(y gt 0.7 and y lt 0.8))
point=fltarr(2*(x2-x1+1)+1*(y2-y1+1),2)

for i=x1,x2 do begin
dao=a(i,*)
lim=max(dao)-min(dao)
s2=where(dao ge min(dao)+0.4*lim and dao lt max(dao),count2)
l1=0 & l4=ysize-1
l2=mean(s2)-0.5*count2 & l3=mean(s2)+0.5*count2
ss1=double(lindgen(l2))
ss2=double(lindgen(l4-l3)+long(l3))
guai1=deriv(ss1,dao(ss1)) & guai2=deriv(ss2,dao(ss2))
guai1(0:3)=0 &guai2(n_elements(guai2)-3:n_elements(guai2)-1)=0
point1=where(guai1 eq max(guai1)) & point2=where(guai2 eq min(guai2))
point1=point1(0) & point2=point2(0)
point2=round(l3)+point2
point(i-x1,0)=i & point(i-x1,1)=point1
point(i-x1+x2-x1+1,0)=i & point(i-x1+x2-x1+1,1)=point2
xyouts,ALIGNMENT=0.5,i/3,point1/3,'.',color=150,/dev
xyouts,ALIGNMENT=0.5,i/3,point2/3,'.',color=150,/dev
endfor
for i=y1,y2 do begin
dao=a(*,i)
lim=max(dao)-min(dao)
s2=where(dao ge min(dao)+0.4*lim and dao lt max(dao),count2)
l4=xsize-1
l3=mean(s2)+0.5*count2
ss2=double(lindgen(l4-l3)+long(l3))
guai2=deriv(ss2,dao(ss2))
guai2(n_elements(guai2)-3:n_elements(guai2)-1)=0
point2=where(guai2 eq min(guai2))
point2=point2(0)
point2=round(l3)+point2
point(x2-x1+1+x2-x1+1+i-y1,0)=point2 & point(x2-x1+1+x2-x1+1+i-y1,1)=i
xyouts,ALIGNMENT=0.5,point2/3,i/3,'.',color=150,/dev
endfor
endif

;7
if xl gt mean(a) and xr lt mean(a) and yd gt mean(a) and yu lt mean(a)$
then begin
print,'7����'
x1=20
x2=max(where(x gt 0.7 and x lt 0.8))
y1=20
y2=max(where(y gt 0.7 and y lt 0.8))
point=fltarr(1*(x2-x1+1)+1*(y2-y1+1),2)

for i=x1,x2 do begin
dao=a(i,*)
lim=max(dao)-min(dao)
s2=where(dao ge min(dao)+0.4*lim and dao lt max(dao),count2)
l4=ysize-1
l3=mean(s2)+0.5*count2
ss2=double(lindgen(l4-l3)+long(l3))
guai2=deriv(ss2,dao(ss2))
guai2(n_elements(guai2)-3:n_elements(guai2)-1)=0
point2=where(guai2 eq min(guai2))
point2=point2(0)
point2=round(l3)+point2
point(i-x1,0)=i & point(i-x1,1)=point2
xyouts,ALIGNMENT=0.5,i/3,point2/3,'.',color=150,/dev
endfor
for i=y1,y2 do begin
dao=a(*,i)
lim=max(dao)-min(dao)
s2=where(dao ge min(dao)+0.4*lim and dao lt max(dao),count2)
l4=xsize-1
l3=mean(s2)+0.5*count2
ss2=double(lindgen(l4-l3)+long(l3))
guai2=deriv(ss2,dao(ss2))
guai2(n_elements(guai2)-3:n_elements(guai2)-1)=0
point2=where(guai2 eq min(guai2))
point2=point2(0)
point2=round(l3)+point2
point(x2-x1+1+i-y1,0)=point2 & point(x2-x1+1+i-y1,1)=i
xyouts,ALIGNMENT=0.5,point2/3,i/3,'.',color=150,/dev
endfor
endif

;8
if xl lt mean(a) and xr lt mean(a) and yd gt mean(a) and yu lt mean(a)$
then begin
print,'8����'
x1=min(where(x gt 0.7 and x lt 0.8))
x2=max(where(x gt 0.7 and x lt 0.8))
y1=20
y2=max(where(y gt 0.7 and y lt 0.8))
point=fltarr(1*(x2-x1+1)+2*(y2-y1+1),2)

for i=x1,x2 do begin
dao=a(i,*)
lim=max(dao)-min(dao)
s2=where(dao ge min(dao)+0.4*lim and dao lt max(dao),count2)
l4=ysize-1
l3=mean(s2)+0.5*count2
ss2=double(lindgen(l4-l3)+long(l3))
guai2=deriv(ss2,dao(ss2))
guai2(n_elements(guai2)-3:n_elements(guai2)-1)=0
point2=where(guai2 eq min(guai2))
point2=point2(0)
point2=round(l3)+point2
point(i-x1,0)=i & point(i-x1,1)=point2
xyouts,ALIGNMENT=0.5,i/3,point2/3,'.',color=150,/dev
endfor
for i=y1,y2 do begin
dao=a(*,i)
lim=max(dao)-min(dao)
s2=where(dao ge min(dao)+0.4*lim and dao lt max(dao),count2)
l1=0 & l4=xsize-1
l2=mean(s2)-0.5*count2 & l3=mean(s2)+0.5*count2
ss1=double(lindgen(l2))
ss2=double(lindgen(l4-l3)+long(l3))
guai1=deriv(ss1,dao(ss1)) & guai2=deriv(ss2,dao(ss2))
guai1(0:3)=0 &guai2(n_elements(guai2)-3:n_elements(guai2)-1)=0
point1=where(guai1 eq max(guai1)) & point2=where(guai2 eq min(guai2))
point1=point1(0) & point2=point2(0)
point2=round(l3)+point2
point(x2-x1+1+i-y1,0)=point1 & point(x2-x1+1+i-y1,1)=i
point(x2-x1+1+y2-y1+1+i-y1,0)=point2 & point(x2-x1+1+y2-y1+1+i-y1,1)=i
xyouts,ALIGNMENT=0.5,point1/3,i/3,'.',color=150,/dev
xyouts,ALIGNMENT=0.5,point2/3,i/3,'.',color=150,/dev
endfor
endif


;9
if xl lt mean(a) and xr gt mean(a) and yd gt mean(a) and yu lt mean(a)$
then begin
print,'9����'
x1=min(where(x gt 0.7 and x lt 0.8))
x2=xsize-20
y1=20
y2=max(where(y gt 0.7 and y lt 0.8))
point=fltarr(1*(x2-x1+1)+1*(y2-y1+1),2)

for i=x1,x2 do begin
dao=a(i,*)
lim=max(dao)-min(dao)
s2=where(dao ge min(dao)+0.4*lim and dao lt max(dao),count2)
l4=ysize-1
l3=mean(s2)+0.5*count2
ss2=double(lindgen(l4-l3)+long(l3))
guai2=deriv(ss2,dao(ss2))
guai2(n_elements(guai2)-3:n_elements(guai2)-1)=0
point2=where(guai2 eq min(guai2))
point2=point2(0)
point2=round(l3)+point2
point(i-x1,0)=i & point(i-x1,1)=point2
xyouts,ALIGNMENT=0.5,i/3,point2/3,'.',color=150,/dev
endfor
for i=y1,y2 do begin
dao=a(*,i)
lim=max(dao)-min(dao)
s2=where(dao ge min(dao)+0.4*lim and dao lt max(dao),count2)
l1=0
l2=mean(s2)-0.5*count2
ss1=double(lindgen(l2))
guai1=deriv(ss1,dao(ss1))
guai1(0:3)=0
point1=where(guai1 eq max(guai1))
point1=point1(0)
point(x2-x1+1+i-y1,0)=point1 & point(x2-x1+1+i-y1,1)=i
xyouts,ALIGNMENT=0.5,point1/3,i/3,'.',color=150,/dev
endfor
endif
;�����ifģ���൱�������ᣬ�ظ�����̫�࣬Ӧ����ɹ���ģ�飬��Ҫ��һ���ı���ͷ
;ͬʱ�ֲ������һ���ӳ��򣬲�֪����ô��2007��9.3
;wait,1
;wxf_circlefit, point, xc,yc,radius
;stop
wxf_circlefit1, point, xc, yc, radius, dev, dot,accuracy=0.1;accuracy=0.05;0.02,0.2,0.1
help,dev
;device,retain=2
;window,11,xs=xsize/3.,ys=ysize/3.
;wshow,11,/iconic
;wset,11
tvscl,congrid(a,xsize/3.,ysize/3.,/interp)
xyouts,ALIGNMENT=0.5,dot(*,0)/3.,dot(*,1)/3.,'.',color=150,/dev
print,'xc,yc=',xc,yc;===============output
print,'radius=',radius;=================output
DIST_CIRCLE,IM,[xsize,ysize],xc,yc,/DOUBLE
a(where(abs(im/radius-1d0) lt 0.001))=max(a)
;device,retain=2
;window,12,xs=xsize/3.,ys=ysize/3.
;wshow,12,/iconic
;wset,12
tvscl,congrid(a,xsize/3.,ysize/3.,/interp)
;wait,1
end
