
FUNCTION RESIDUAL_DC_INT, prof, d, deg
;----- TO FIT N:TH ORDER POLYNOMIAL TO DC
;----- AJO OCT 96

    ;----- make D an even integer
d = FIX( ROUND( d ) )
IF ( d MOD 2) NE 0 THEN d = d - 1

    ;----- prepare input
prof = REFORM( prof)
prof = [ REVERSE( prof ), prof ]
y = prof
n = N_ELEMENTS( y )
x = INDGEN( n )

    ;----- fit polynomial
x = x( n / 2 - d - 1 : n / 2 + d )
y = y( n / 2 - d - 1 : n / 2 + d )
c = POLY_FIT( x, y, deg, yfit, yband )

    ;----- exclude outliers and refit
index = WHERE( ABS( y - yfit ) GT 2 * yband, ct )
IF ct GT 0 THEN BEGIN
    c = POLY_FIT( x( index ), y( index), deg )
    yfit = POLY( x, c )
ENDIF

    ;----- prepare output
prof( n / 2 - d - 1 : n / 2 + d ) = yfit
prof = prof( n / 2 : * )



RETURN, prof

END













