pro hr_ha_auto_flat1, dh=dh
;+
; NAME:
; HR_HA_AUTO_FLAT Version1.0
; PURPOSE:
;  Calculate Huairou flatfield automatically everyday.
;
; EXPLANATION:
;   Returns three two files and a IDL save file which stores the CCD flat field.
;
; CALLING SEQUENCE:
;
; INPUTS:
;   Ten fits files
;
; OPTIONAL INPUTS:
;   dh the directory contains flatfield files
;
; OUTPUTS:
;  Original jpg, Corrected jpg(red and gray), Flat save file
;
; OPTIONAL INPUT KEYWORD:
;   No optional input keyword for Version 1.
;
; EXAMPLE:
; Authors:
; Wang xiao fan and Huairou staff HSOS Version1.0
;
; HISTORY:
;	February---March, 2001, by DENG Y Y in HSOS modifying from the BBSO original programs
;    February---May by Wang X F in HSOS
; This version is on the basis of DYY's version, BBSO's routine and  Kuhn-Lin flat field theory.
; This version largely improved the calculating results of solar center and radius by 
; adding my two subroutines.;  The wxf_sunrim1.pro and wxf_circlefit1.pro are very useful for
; any full-disk or partial-disk solar filtergram process.
; The flatfield routine is still not perfect and should be substituted by other better version.
;=================================================

pth=dh
if n_elements(dh) eq 0 then begin
rt=fix(strmid(systime(),11,2))
month_str=strarr(12)
month_str(0)='Jan'&month_str(1)='Feb'&month_str(2)='Mar'&month_str(3)='Apr'&month_str(4)='May'&month_str(5)='Jun'
month_str(6)='Jul'&month_str(7)='Aug'&month_str(8)='Sep'&month_str(9)='Oct'&month_str(10)='Nov'&month_str(11)='Dec'
month=['01','02','03','04','05','06','07','08','09','10','11','12']
dh='G:\ha\'+month(where(month_str eq strmid(systime(),4,3)))+strmid(systime(),8,2)
dh=dh(0);IDL-version_problem
pth=dh+'\o\'
endif

filename=pth+'????????????????full.fit'
filename = FINDFILE(filename) &filename=filename(0)
date=strlen(filename)
device,retain=2
window,0,xs=256*3,ys=256*2
if date eq 0 then begin
xyouts,0.01,0.5,'No flat field data!',/norm,charsize=6,color=250
wait,3
exit, /no_confirm
endif
date=strmid(filename,0,date-14)

p   = { NX: 0, NXX: 0, NY: 0, NYY: 0, N: 0, XC: 0, YC: 0, XD: 0, YD: 0, $
        INT: 0l, INT_I: 0l, INT_L: 0l }

;----- read image frame
img=readfits(filename,ihdr)
img=img(0:2015,*)
wh=where(img lt 0)
if mean(img(0:200,0:200)) gt 2000 or mean(img(1815:2015,1839:2039)) gt 2000 or wh(0) ne -1 then img=swap_endian(img)

;=================
time=sxpar(ihdr,'TIME_OBS')
p_angle = get_rb0p( time, /pangle, /deg )
;=====================================================

strn=strlen(filename)
name=strmid(filename,0,strn-4)


p.nx  = 2016;SXPAR( ihdr, 'NAXIS1' )
fred=8.
;fred=4.     ;---------------better but consume more time
;fred=1.     ;---------------best
p.nxx = LONG( ROUND( p.nx / fred ) )
p.ny  = 2040;SXPAR( ihdr, 'NAXIS2' )
p.nyy = LONG( ROUND( p.ny / fred ) )

;----- read dark frame
;sometimes,including the dark frame could make the flatfield become worse. (wxf 20080609)

window,1,xs=618,ys=618
filenam=findfile(pth+'*dark.fit')&filenam=filenam(0)

if strlen(filenam) ne 0 then begin
dark=readfits(filenam)
dark=dark(0:2015,*) & filenam=0b
wh=where(dark lt 0)
if mean(dark) gt 50 or wh(0) ne -1 then dark=swap_endian(dark)
endif else begin
xyouts,0.01,0.5,'No dark field, Lazy or forgot!',/norm,charsize=6,color=250
dark=img*0
endelse

shade_surf,dark
wset,0
TVSCL, CONGRID( dark, 256, 256 ), 0
TVSCL, congrid(img,256,256), 3
;===================================
tmp=dblarr(4)
wxf_sunrim1,img,xc,yc,radius,im,dev
wset,0
tmp(0)=xc & tmp(1)=yc & tmp(2)=2*radius & tmp(3)=2*radius
;==================================

img   = FIX( (img - dark) > 0 )
p.xc = tmp( 0 )
p.yc = tmp( 1 )
p.xd = tmp( 2 )
p.yd = tmp( 3 )

;----- center coordinates (absolute difference)
;      ----- removed this part after inplementing the new center/radius
;      ----- determination in CENTER_SOBEL.PRO (M. Steinegger, 2000/07/20)
;===========================================================================
;	center_sobel pro was substituted by my routine wxf_sunrim1.pro
;	fit_circle.pro was substituted by my wxf_circlefit1.pro(Xiaofan  Wang, 2008/06/09)
;=============================================================================

img_c = img ( p.xc - 50 : p.xc + 50, p.yc - 50 : p.yc + 50 )
;----- disk center brightness
p.int = MEDIAN( img( p.xc - 30 : p.xc + 30, p.yc - 30 : p.yc + 30 ) )
;----- create flat field file list

;file = FINDFILE( date+'??????P00A.fit', COUNT = tmp );@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
file = FINDFILE( date+'??????flat.fit', COUNT = tmp );@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
tmp=tmp+1
p.n = tmp

;----- read flat field frames

flat = fltarr( p.nxx, p.nyy, p.n )
flat( *, *, 0 ) = CONGRID( img, p.nxx, p.nyy, /INTERP )
disp = INTARR ( 2, p.n )
disp( *, 0 ) = [ p.xc, p.yc ]
print, 'p.n',p.n

;%%%%%%%%%%%%%%%%%%%%%%
FOR i = 0, p.n - 2 DO BEGIN
;===================the following subroutine is added by wxf
tmp=readfits(file(i),fhdr)
tmp=tmp(0:2015,*)

wh=where(tmp lt 0)
if mean(tmp(0:200,0:200)) gt 2000 or mean(tmp(1815:2015,1839:2039)) gt 2000 or wh(0) ne -1 then tmp=swap_endian(tmp)

flat ( *, *, i + 1 ) = CONGRID ( tmp, p.nxx, p.nyy, /INTERP )
;====================
wxf_sunrim1,tmp,xc,yc,radius,in,dev
wset,0
;==================================
    tmp = FIX( tmp - dark > 0 )

    ;----- center coordinates (absolute difference)
    ;      ----- included the following line instead (M. Steinegger, 2000/07/20)
    disp(*,i+1)=[ xc, yc ]
    ;----- cross correlation of center
flat_c=tmp(disp(0,i+1)-50:disp(0,i+1)+50,disp(1,i+1)-50:disp(1,i+1)+50)
tmp = ALIGN( img_c, flat_c )

;----- further improvement and conversion to displacement array
disp( *, i + 1 ) = - FIX( ROUND((disp(*, i + 1)-tmp-disp(*, 0))/ fred))
ENDFOR
;%%%%%%%%%%%%%%%%%%%%%%

disp( *, 0 ) = disp( *, 0 ) * 0

;----- Kuhn-Lin flat field
flat=flat_kuhn_lin(flat,disp,p)

;----- extrapolate missing flat field values and resize
flat = FLAT_CLEAN( flat, [ p.xc, p.yc ] /fred , p )
;----- flat field and normalize image
;      ------ changed the normalization to be compatible with BBSO and
;      ------ KSO images (M. Steinegger, 2000/07/20
mean_flat = MEDIAN( flat )
flat = TEMPORARY( flat ) / mean_flat

;------------------------------------
line=total(flat,2)
line=line/max(line)
line=line # REPLICATE(1,2040)
line=smooth(line,[10,0],/edge_truncate);-------------

;==================================================
;these lines are added by wxf for Huairou Ha CCD. 
;Because it seems to have three nonuniform CCD blocks.
;You can cancel the following two lines if you have not find the difference
;for some specific Huairou Halpha data. (wxf 20080609)
flat=flat/(line^1.0)
flat=median(flat,10)
;===================================================

wset,1
shade_surf,flat
save,flat,filename=pth+'flat.sav'

wset,0
TVSCL, CONGRID( flat, 256, 256 ), 1
img = img / flat
p.int_i = MEDIAN( img( p.xc - 30 : p.xc + 30, p.yc - 30 : p.yc + 30 ) )
img = img / FLOAT( p.int_i ) * 10000.
tmp = CONGRID( img, 256, 256 )
TVSCL, tmp , 2

;----- limb darkening profile
;----- changed limb normalization to be compatible with BBSO and
;----- KSO images

limb = RESIDUAL_LIMB( img, p, 50, 200, prof )
p.int_l = MEDIAN( limb( p.xc - 30 : p.xc + 30, p.yc - 30 : p.yc + 30 ) )
limb = limb / FLOAT( p.int_l ) * 10000.
TVSCL, CONGRID( limb, 256, 256 ), 4

res  = img - limb
res(where(im gt 0.5*p.xd))=min(res(where(im lt 0.5*p.xd)))
lim=1500
TVSCL, CONGRID( res, 256, 256 )>(-LIM)<LIM, 5
;--------------------------------------------------------------
for aa=1, 6 do begin
if aa lt 4 then xyouts,0.01+0.33*(aa-1),0.53,'('+strmid(string(aa),7,1)+')',/norm,charsize=1.2
if aa ge 4 then xyouts,0.01+0.33*(aa-4),0.01,'('+strmid(string(aa),7,1)+')',/norm,charsize=1.2
endfor
xyouts,0.46,0.53,'Flatfield',/norm,charsize=1.2
xyouts,0.13,0.03,'Original image',/norm,charsize=1.2
xyouts,0.4,0.03,'Limb-darkening image',/norm,charsize=1.2


;=========================================================
;xyouts,0.75,0.03,'Image6=Image3/Image2',/norm,charsize=1.2
;xyouts,0.75,0.53,'Image3=Image4-Image5',/norm,charsize=1.2

;---------------the above two lines are corrected by wxf 200806,according to the programe.
xyouts,0.75,0.03,'Image6=Image3-Image5',/norm,charsize=1.2
xyouts,0.75,0.53,'Image3=Image4/Image2',/norm,charsize=1.2
;=========================================================

p_ang = get_rb0p( sxpar(ihdr,'TIME_OBS'), /pangle, /deg )
res=shift(res,1007.50-p.xc,1019.50-p.yc)
res= rotate(rot (res, -p_ang,1.0,1007.50,1019.50),5)
write_jpeg,pth+'fullg.jpg',bytscl(res>(-1800)<1800),quality=100

;--------------------------------------------------------------
device,decompose=0
loadct,3
b=widget_base()
draw=widget_draw(b,xsize=2016,ysize=2040,x_scroll_size=1000,y_scroll_size=700)
widget_control,b,/realize
widget_control,draw,get_value=b
tvscl,res>(-1500)<1500
im=tvrd(true=1)
write_jpeg,pth+'fullr.jpg',im,true=1,quality=100
;wdelete,b
loadct,0
wset,10
tvscl,congrid(bytscl(res>(-1800)<1800),618,618)

wset,1
tvscl,congrid(flat,618,618,/interp)
wait,30
exit, /no_confirm
end
