; $Id: //depot/idl/IDL_71/idlde/idldt/com.rsi.idldt/icons/convert_32bit.pro#1 $
;
; Convert an RGB or color-indexed image file into a
; 32-bit (RGBA) png file, so we can embed it into a Windows .ico file.
;
; The new file is given the suffix "-32.png"
;
; CT, June 2006
;
pro convert_32bit

    f = dialog_pickfile(TITLE='Select image file to convert')
    if (f eq '') then return
    cd, file_dirname(f)
    im = read_image(f, r, g, b)
    dim = size(im, /dim)
    ; Create the output array.
    image = bytarr(4,dim[0],dim[1]) + 255b

    if (N_Elements(dim) eq 3) then begin
        ; Convert from RGB to RGBA
        image[0:2,*,*] = im
    endif else begin
        ; Convert from color indexed to RGBA.
        image[0,*,*] = r[im]
        image[1,*,*] = g[im]
        image[2,*,*] = b[im]
    endelse

    dot = strpos(f, '.', /reverse_search)
    if (dot gt 0) then f=strmid(f,0,dot)
    f += '-32.png'

    write_png, f, image

end
