; $Id: //depot/idl/IDL_71/idldir/lib/surfr.pro#1 $
;
; Copyright (c) 1988-2009, ITT Visual Information Solutions. All
;       rights reserved. Unauthorized reproduction is prohibited.

pro surfr,ax=ax, az=az	;Set up transformation for surface
;+
; NAME:
;	SURFR
;
; PURPOSE:
;	Set up 3D transformations.
;
;	This procedure duplicates the rotation, translation, and scaling 
;	features of the SURFACE routine.
;
; CATEGORY:
;	Graphics, 3D.
;
; CALLING SEQUENCE:
;	SURFR [, AX = ax]  [, AZ = az]
;
; INPUTS:
;	No plain parameters.
;
; KEYWORD PARAMETERS:
;	AX:	Angle of rotation about the X axis.  The default is 30 degrees.
;
;	AZ:	Angle of rotation about the Z axis.  The default is 30 degrees.
;
; OUTPUTS:
;	No explicit outputs.  Results are stored in !P.T.
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	The 4 by 4 matrix, !P.T, the 3D transformation system variable, 
;	receives the homogeneous transformation matrix generated by this 
;	procedure.
;
; RESTRICTIONS:
;	Axonometric projections only.
;
; PROCEDURE:
;	1. Translate the unit cube so that the center (.5,.5,.5) is moved
;	   to the origin.
;
;	2. Rotate -90 degrees about the X axis to make the +Z
;	   axis of the data the +Y axis of the display.  The +Y data axis
;	   extends from the front of the display to the rear.
;
;	3. Rotate about the Y axis AZ degrees.  This rotation is 
;	   counterclockwise as seen from above the page.
;
;	4. Rotate about the X axis AX degrees, tilting the data
;	   toward the viewer.
;
;	5. Translate back to the origin and scale the data so
;	   that the data are still contained within the unit cube after
;	   transformation.  This step uses the user procedure SCALE3D.
;
; MODIFICATION HISTORY:
;	DMS, may, 1988.
;-
on_error,2                      ;Return to caller if an error occurs
if n_elements(ax) eq 0 then ax=30
if n_elements(az) eq 0 then az=30

t3d,/reset,tr=[-.5,-.5,-.5]	;Translate to center about origin
t3d,ro=[-90,az,0]		;rotate so +Z axis is now +Y
t3d,ro=[ax,0,0]
scale3d				;Scale it
end
