; $Id: //depot/idl/IDL_71/idldir/lib/map_proj_init_common.pro#1 $
;
; Copyright (c) 2002-2009, ITT Visual Information Solutions. All
;       rights reserved. Unauthorized reproduction is prohibited.
;
;---------------------------------------------------------------------------
pro map_proj_init_common_stateplane

    compile_opt idl2, hidden

; Include our common block.
@map_proj_init_commonblock

; Automatically generated by gctp/convert_nad.pro
; Name, Zone, Projection, CenterLon (DDMMSS), CenterLat, Angle1, Angle2
;     ScaleFactor, FalseEasting, FalseNorthing
nad27 = [ $
'Alabama East', '101', '1', '-855000', '303000', '0', '0', $
    '0.9999600000000000', '152400.3048006096', '0', $
'Alabama West', '102', '1', '-873000', '300000', '0', '0', $
    '0.9999333333333333', '152400.3048006096', '0', $
'Alaska 1', '5001', '4', '-1334000', '570000', '-365211', '0', $
    '0.9999', '818585.5672270928', '575219.2451072643', $
'Alaska 2', '5002', '1', '-1420000', '540000', '0', '0', $
    '0.9999', '152400.3048006096', '0', $
'Alaska 3', '5003', '1', '-1460000', '540000', '0', '0', $
    '0.9999', '152400.3048006096', '0', $
'Alaska 4', '5004', '1', '-1500000', '540000', '0', '0', $
    '0.9999', '152400.3048006096', '0', $
'Alaska 5', '5005', '1', '-1540000', '540000', '0', '0', $
    '0.9999', '152400.3048006096', '0', $
'Alaska 6', '5006', '1', '-1580000', '540000', '0', '0', $
    '0.9999', '152400.3048006096', '0', $
'Alaska 7', '5007', '1', '-1620000', '540000', '0', '0', $
    '0.9999', '213360.4267208534', '0', $
'Alaska 8', '5008', '1', '-1660000', '540000', '0', '0', $
    '0.9999', '152400.3048006096', '0', $
'Alaska 9', '5009', '1', '-1700000', '540000', '0', '0', $
    '0.9999', '182880.3657607315', '0', $
'Alaska 10', '5010', '2', '-1760000', '510000', '515000', '535000', $
    '1', '914401.8288036576', '0', $
'American Samoa', '5300', '2', '-1700000', '-141600', '-141600', '-141600', $
    '1', '152400.3048006096', '95169.31165862332', $
'Arizona East', '201', '1', '-1101000', '310000', '0', '0', $
    '0.9999', '152400.3048006096', '0', $
'Arizona Central', '202', '1', '-1115500', '310000', '0', '0', $
    '0.9999', '152400.3048006096', '0', $
'Arizona West', '203', '1', '-1134500', '310000', '0', '0', $
    '0.9999333333333333', '152400.3048006096', '0', $
'Arkansas North', '301', '2', '-920000', '342000', '345600', '361400', $
    '1', '609601.2192024384', '0', $
'Arkansas South', '302', '2', '-920000', '324000', '331800', '344600', $
    '1', '609601.2192024384', '0', $
'California I', '401', '2', '-1220000', '392000', '400000', '414000', $
    '1', '609601.2192024384', '0', $
'California II', '402', '2', '-1220000', '374000', '382000', '395000', $
    '1', '609601.2192024384', '0', $
'California III', '403', '2', '-1203000', '363000', '370400', '382600', $
    '1', '609601.2192024384', '0', $
'California IV', '404', '2', '-1190000', '352000', '360000', '371500', $
    '1', '609601.2192024384', '0', $
'California V', '405', '2', '-1180000', '333000', '340200', '352800', $
    '1', '609601.2192024384', '0', $
'California VI', '406', '2', '-1161500', '321000', '324700', '335300', $
    '1', '609601.2192024384', '0', $
'California VII', '407', '2', '-1182000', '340800', '335200', '342500', $
    '1', '1276106.450596901', '1268253.006858014', $
'Colorado North', '501', '2', '-1053000', '392000', '394300', '404700', $
    '1', '609601.2192024384', '0', $
'Colorado Central', '502', '2', '-1053000', '375000', '382700', '394500', $
    '1', '609601.2192024384', '0', $
'Colorado South', '503', '2', '-1053000', '364000', '371400', '382600', $
    '1', '609601.2192024384', '0', $
'Connecticut', '600', '2', '-724500', '405000', '411200', '415200', $
    '1', '182880.3657607315', '0', $
'Delaware', '700', '1', '-752500', '380000', '0', '0', $
    '0.9999950000000000', '152400.3048006096', '0', $
'Florida East', '901', '1', '-810000', '242000', '0', '0', $
    '0.9999411764705882', '152400.3048006096', '0', $
'Florida West', '902', '1', '-820000', '242000', '0', '0', $
    '0.9999411764705882', '152400.3048006096', '0', $
'Florida North', '903', '2', '-843000', '290000', '293500', '304500', $
    '1', '609601.2192024384', '0', $
'Georgia East', '1001', '1', '-821000', '300000', '0', '0', $
    '0.9999', '152400.3048006096', '0', $
'Georgia West', '1002', '1', '-841000', '300000', '0', '0', $
    '0.9999', '152400.3048006096', '0', $
'Hawaii 1', '5101', '1', '-1553000', '185000', '0', '0', $
    '0.9999666666666667', '152400.3048006096', '0', $
'Hawaii 2', '5102', '1', '-1564000', '202000', '0', '0', $
    '0.9999666666666667', '152400.3048006096', '0', $
'Hawaii 3', '5103', '1', '-1580000', '211000', '0', '0', $
    '0.9999900000000001', '152400.3048006096', '0', $
'Hawaii 4', '5104', '1', '-1593000', '215000', '0', '0', $
    '0.9999900000000001', '152400.3048006096', '0', $
'Hawaii 5', '5105', '1', '-1601000', '214000', '0', '0', $
    '1', '152400.3048006096', '0', $
'Idaho East', '1101', '1', '-1121000', '414000', '0', '0', $
    '0.9999473684210526', '152400.3048006096', '0', $
'Idaho Central', '1102', '1', '-1140000', '414000', '0', '0', $
    '0.9999473684210526', '152400.3048006096', '0', $
'Idaho West', '1103', '1', '-1154500', '414000', '0', '0', $
    '0.9999333333333333', '152400.3048006096', '0', $
'Illinois East', '1201', '1', '-882000', '364000', '0', '0', $
    '0.9999750000000000', '152400.3048006096', '0', $
'Illinois West', '1202', '1', '-901000', '364000', '0', '0', $
    '0.9999411764705882', '152400.3048006096', '0', $
'Indiana East', '1301', '1', '-854000', '373000', '0', '0', $
    '0.9999666666666667', '152400.3048006096', '0', $
'Indiana West', '1302', '1', '-870500', '373000', '0', '0', $
    '0.9999666666666667', '152400.3048006096', '0', $
'Iowa North', '1401', '2', '-933000', '413000', '420400', '431600', $
    '1', '609601.2192024384', '0', $
'Iowa South', '1402', '2', '-933000', '400000', '403700', '414700', $
    '1', '609601.2192024384', '0', $
'Kansas North', '1501', '2', '-980000', '382000', '384300', '394700', $
    '1', '609601.2192024384', '0', $
'Kansas South', '1502', '2', '-983000', '364000', '371600', '383400', $
    '1', '609601.2192024384', '0', $
'Kentucky North', '1601', '2', '-841500', '373000', '375800', '385800', $
    '1', '609601.2192024384', '0', $
'Kentucky South', '1602', '2', '-854500', '362000', '364400', '375600', $
    '1', '609601.2192024384', '0', $
'Louisiana North', '1701', '2', '-923000', '304000', '311000', '324000', $
    '1', '609601.2192024384', '0', $
'Louisiana South', '1702', '2', '-912000', '284000', '291800', '304200', $
    '1', '609601.2192024384', '0', $
'Louisiana Offshore', '1703', '2', '-912000', '254000', '261000', '275000', $
    '1', '609601.2192024384', '0', $
'Maine East', '1801', '1', '-683000', '435000', '0', '0', $
    '0.9999', '152400.3048006096', '0', $
'Maine West', '1802', '1', '-701000', '425000', '0', '0', $
    '0.9999666666666667', '152400.3048006096', '0', $
'Maryland', '1900', '2', '-770000', '375000', '381800', '392700', $
    '1', '243840.4876809754', '0', $
'Massachusetts Mainland', '2001', '2', '-713000', '410000', '414300', '424100', $
    '1', '182880.3657607315', '0', $
'Massachusetts Island', '2002', '2', '-703000', '410000', '411700', '412900', $
    '1', '60960.12192024384', '0', $
'Michigan TM East', '2101', '1', '-834000', '413000', '0', '0', $
    '0.9999428571428571', '152400.3048006096', '0', $
'Michigan TM Central', '2102', '1', '-854500', '413000', '0', '0', $
    '0.9999090909090909', '152400.3048006096', '0', $
'Michigan TM West', '2103', '1', '-884500', '413000', '0', '0', $
    '0.9999090909090909', '152400.3048006096', '0', $
'Michigan LC North', '2111', '2', '-870000', '444700', '452900', '470500', $
    '1', '609601.2192024384', '0', $
'Michigan LC Central', '2112', '2', '-842000', '431900', '441100', '454200', $
    '1', '609601.2192024384', '0', $
'Michigan LC South', '2113', '2', '-842000', '413000', '420600', '434000', $
    '1', '609601.2192024384', '0', $
'Minnesota North', '2201', '2', '-930600', '463000', '470200', '483800', $
    '1', '609601.2192024384', '0', $
'Minnesota Central', '2202', '2', '-941500', '450000', '453700', '470300', $
    '1', '609601.2192024384', '0', $
'Minnesota South', '2203', '2', '-940000', '430000', '434700', '451300', $
    '1', '609601.2192024384', '0', $
'Mississippi East', '2301', '1', '-885000', '294000', '0', '0', $
    '0.9999600000000000', '152400.3048006096', '0', $
'Mississippi West', '2302', '1', '-902000', '303000', '0', '0', $
    '0.9999411764705882', '152400.3048006096', '0', $
'Missouri East', '2401', '1', '-903000', '355000', '0', '0', $
    '0.9999333333333333', '152400.3048006096', '0', $
'Missouri Central', '2402', '1', '-923000', '355000', '0', '0', $
    '0.9999333333333333', '152400.3048006096', '0', $
'Missouri West', '2403', '1', '-943000', '361000', '0', '0', $
    '0.9999411764705882', '152400.3048006096', '0', $
'Montana North', '2501', '2', '-1093000', '470000', '475100', '484300', $
    '1', '609601.2192024384', '0', $
'Montana Central', '2502', '2', '-1093000', '455000', '462700', '475300', $
    '1', '609601.2192024384', '0', $
'Montana South', '2503', '2', '-1093000', '440000', '445200', '462400', $
    '1', '609601.2192024384', '0', $
'Nebraska North', '2601', '2', '-1000000', '412000', '415100', '424900', $
    '1', '609601.2192024384', '0', $
'Nebraska South', '2602', '2', '-993000', '394000', '401700', '414300', $
    '1', '609601.2192024384', '0', $
'Nevada East', '2701', '1', '-1153500', '344500', '0', '0', $
    '0.9999', '152400.3048006096', '0', $
'Nevada Central', '2702', '1', '-1164000', '344500', '0', '0', $
    '0.9999', '152400.3048006096', '0', $
'Nevada West', '2703', '1', '-1183500', '344500', '0', '0', $
    '0.9999', '152400.3048006096', '0', $
'New Hampshire', '2800', '1', '-714000', '423000', '0', '0', $
    '0.9999666666666667', '152400.3048006096', '0', $
'New Jersey', '2900', '1', '-744000', '385000', '0', '0', $
    '0.9999750000000000', '609601.2192024384', '0', $
'New Mexico East', '3001', '1', '-1042000', '310000', '0', '0', $
    '0.9999090909090909', '152400.3048006096', '0', $
'New Mexico Central', '3002', '1', '-1061500', '310000', '0', '0', $
    '0.9999', '152400.3048006096', '0', $
'New Mexico West', '3003', '1', '-1075000', '310000', '0', '0', $
    '0.9999166666666667', '152400.3048006096', '0', $
'New York East', '3101', '1', '-742000', '400000', '0', '0', $
    '0.9999666666666667', '152400.3048006096', '0', $
'New York Central', '3102', '1', '-763500', '400000', '0', '0', $
    '0.9999375000000000', '152400.3048006096', '0', $
'New York West', '3103', '1', '-783500', '400000', '0', '0', $
    '0.9999375000000000', '152400.3048006096', '0', $
'New York Long Island', '3104', '2', '-740000', '403000', '404000', '410200', $
    '1', '609601.2192024384', '30480.06096012192', $
'North Carolina', '3200', '2', '-790000', '334500', '342000', '361000', $
    '1', '609601.2192024384', '0', $
'North Dakota North', '3301', '2', '-1003000', '470000', '472600', '484400', $
    '1', '609601.2192024384', '0', $
'North Dakota South', '3302', '2', '-1003000', '454000', '461100', '472900', $
    '1', '609601.2192024384', '0', $
'Ohio North', '3401', '2', '-823000', '394000', '402600', '414200', $
    '1', '609601.2192024384', '0', $
'Ohio South', '3402', '2', '-823000', '380000', '384400', '400200', $
    '1', '609601.2192024384', '0', $
'Oklahoma North', '3501', '2', '-980000', '350000', '353400', '364600', $
    '1', '609601.2192024384', '0', $
'Oklahoma South', '3502', '2', '-980000', '332000', '335600', '351400', $
    '1', '609601.2192024384', '0', $
'Oregon North', '3601', '2', '-1203000', '434000', '442000', '460000', $
    '1', '609601.2192024384', '0', $
'Oregon South', '3602', '2', '-1203000', '414000', '422000', '440000', $
    '1', '609601.2192024384', '0', $
'Pennsylvania North', '3701', '2', '-774500', '401000', '405300', '415700', $
    '1', '609601.2192024384', '0', $
'Pennsylvania South', '3702', '2', '-774500', '392000', '395600', '405800', $
    '1', '609601.2192024384', '0', $
'Rhode Island', '3800', '1', '-713000', '410500', '0', '0', $
    '0.9999937500000000', '152400.3048006096', '0', $
'South Carolina North', '3901', '2', '-810000', '330000', '334600', '345800', $
    '1', '609601.2192024384', '0', $
'South Carolina South', '3902', '2', '-810000', '315000', '322000', '334000', $
    '1', '609601.2192024384', '0', $
'South Dakota North', '4001', '2', '-1000000', '435000', '442500', '454100', $
    '1', '609601.2192024384', '0', $
'South Dakota South', '4002', '2', '-1002000', '422000', '425000', '442400', $
    '1', '609601.2192024384', '0', $
'Tennessee', '4100', '2', '-860000', '344000', '351500', '362500', $
    '1', '609601.2192024384', '30480.06096012192', $
'Texas North', '4201', '2', '-1013000', '340000', '343900', '361100', $
    '1', '609601.2192024384', '0', $
'Texas North Central', '4202', '2', '-973000', '314000', '320800', '335800', $
    '1', '609601.2192024384', '0', $
'Texas Central', '4203', '2', '-1002000', '294000', '300700', '315300', $
    '1', '609601.2192024384', '0', $
'Texas South Central', '4204', '2', '-990000', '275000', '282300', '301700', $
    '1', '609601.2192024384', '0', $
'Texas South', '4205', '2', '-983000', '254000', '261000', '275000', $
    '1', '609601.2192024384', '0', $
'Utah North', '4301', '2', '-1113000', '402000', '404300', '414700', $
    '1', '609601.2192024384', '0', $
'Utah Central', '4302', '2', '-1113000', '382000', '390100', '403900', $
    '1', '609601.2192024384', '0', $
'Utah South', '4303', '2', '-1113000', '364000', '371300', '382100', $
    '1', '609601.2192024384', '0', $
'Vermont', '4400', '1', '-723000', '423000', '0', '0', $
    '0.9999642857142858', '152400.3048006096', '0', $
'Virginia North', '4501', '2', '-783000', '374000', '380200', '391200', $
    '1', '609601.2192024384', '0', $
'Virginia South', '4502', '2', '-783000', '362000', '364600', '375800', $
    '1', '609601.2192024384', '0', $
'Washington North', '4601', '2', '-1205000', '470000', '473000', '484400', $
    '1', '609601.2192024384', '0', $
'Washington South', '4602', '2', '-1203000', '452000', '455000', '472000', $
    '1', '609601.2192024384', '0', $
'West Virginia North', '4701', '2', '-793000', '383000', '390000', '401500', $
    '1', '609601.2192024384', '0', $
'West Virginia South', '4702', '2', '-810000', '370000', '372900', '385300', $
    '1', '609601.2192024384', '0', $
'Wisconsin North', '4801', '2', '-900000', '451000', '453400', '464600', $
    '1', '609601.2192024384', '0', $
'Wisconsin Central', '4802', '2', '-900000', '435000', '441500', '453000', $
    '1', '609601.2192024384', '0', $
'Wisconsin South', '4803', '2', '-900000', '420000', '424400', '440400', $
    '1', '609601.2192024384', '0', $
'Wyoming East', '4901', '1', '-1051000', '404000', '0', '0', $
    '0.9999411764705882', '152400.3048006096', '0', $
'Wyoming East Central', '4902', '1', '-1072000', '404000', '0', '0', $
    '0.9999411764705882', '152400.3048006096', '0', $
'Wyoming West Central', '4903', '1', '-1084500', '404000', '0', '0', $
    '0.9999411764705882', '152400.3048006096', '0', $
'Wyoming West', '4904', '1', '-1100500', '404000', '0', '0', $
    '0.9999411764705882', '152400.3048006096', '0', $
'Puerto Rico Virgin Islands', '5201', '2', '-662600', '175000', '180200', '182600', $
    '1', '152400.3048006096', '0', $
'Virgin Islands St. Croix', '5202', '2', '-662600', '175000', '180200', '182600', $
    '1', '152400.3048006096', '30480.06096012192', $
'Guam Island', '5400', '3', '1444455', '132820', '0', '0', $
    '1', '50000.00000000000', '50000.00000000000']


; Automatically generated by gctp/convert_nad.pro
; Name, Zone, Projection, CenterLon (DDMMSS), CenterLat, Angle1, Angle2
;     ScaleFactor, FalseEasting, FalseNorthing
nad83 = [ $
; Automatically generated by gctp/convert_nad.pro
; Name, Zone, Projection, CenterLon (DDMMSS), CenterLat, Angle1, Angle2
;     ScaleFactor, FalseEasting, FalseNorthing
'Alabama East', '101', '1', '-855000', '303000', '0', '0', $
    '0.9999600000000000', '200000.0000000000', '0', $
'Alabama West', '102', '1', '-873000', '300000', '0', '0', $
    '0.9999333333333333', '600000.0000000000', '0', $
'Alaska 1', '5001', '4', '-1334000', '570000', '-365211', '0', $
    '0.9999', '818676.7344011233', '575097.6888751927', $
'Alaska 2', '5002', '1', '-1420000', '540000', '0', '0', $
    '0.9999', '500000.0000000000', '0', $
'Alaska 3', '5003', '1', '-1460000', '540000', '0', '0', $
    '0.9999', '500000.0000000000', '0', $
'Alaska 4', '5004', '1', '-1500000', '540000', '0', '0', $
    '0.9999', '500000.0000000000', '0', $
'Alaska 5', '5005', '1', '-1540000', '540000', '0', '0', $
    '0.9999', '500000.0000000000', '0', $
'Alaska 6', '5006', '1', '-1580000', '540000', '0', '0', $
    '0.9999', '500000.0000000000', '0', $
'Alaska 7', '5007', '1', '-1620000', '540000', '0', '0', $
    '0.9999', '500000.0000000000', '0', $
'Alaska 8', '5008', '1', '-1660000', '540000', '0', '0', $
    '0.9999', '500000.0000000000', '0', $
'Alaska 9', '5009', '1', '-1700000', '540000', '0', '0', $
    '0.9999', '500000.0000000000', '0', $
'Alaska 10', '5010', '2', '-1760000', '510000', '515000', '535000', $
    '1', '1000000.000000000', '0', $
'Arizona East', '201', '1', '-1101000', '310000', '0', '0', $
    '0.9999', '213360.0000000000', '0', $
'Arizona Central', '202', '1', '-1115500', '310000', '0', '0', $
    '0.9999', '213360.0000000000', '0', $
'Arizona West', '203', '1', '-1134500', '310000', '0', '0', $
    '0.9999333333333333', '213360.0000000000', '0', $
'Arkansas North', '301', '2', '-920000', '342000', '345600', '361400', $
    '1', '400000.0000000000', '0', $
'Arkansas South', '302', '2', '-920000', '324000', '331800', '344600', $
    '1', '400000.0000000000', '400000.0000000000', $
'California I', '401', '2', '-1220000', '392000', '400000', '414000', $
    '1', '2000000.000000000', '500000.0000000000', $
'California II', '402', '2', '-1220000', '374000', '382000', '395000', $
    '1', '2000000.000000000', '500000.0000000000', $
'California III', '403', '2', '-1203000', '363000', '370400', '382600', $
    '1', '2000000.000000000', '500000.0000000000', $
'California IV', '404', '2', '-1190000', '352000', '360000', '371500', $
    '1', '2000000.000000000', '500000.0000000000', $
'California V', '405', '2', '-1180000', '333000', '340200', '352800', $
    '1', '2000000.000000000', '500000.0000000000', $
'California VI', '406', '2', '-1161500', '321000', '324700', '335300', $
    '1', '2000000.000000000', '500000.0000000000', $
'Colorado North', '501', '2', '-1053000', '392000', '394300', '404700', $
    '1', '914401.8289000000', '304800.6096000000', $
'Colorado Central', '502', '2', '-1053000', '375000', '382700', '394500', $
    '1', '914401.8289000000', '304800.6096000000', $
'Colorado South', '503', '2', '-1053000', '364000', '371400', '382600', $
    '1', '914401.8289000000', '304800.6096000000', $
'Connecticut', '600', '2', '-724500', '405000', '411200', '415200', $
    '1', '304800.6096000000', '152400.3048000000', $
'Delaware', '700', '1', '-752500', '380000', '0', '0', $
    '0.9999950000000000', '200000.0000000000', '0', $
'Florida East', '901', '1', '-810000', '242000', '0', '0', $
    '0.9999411764705882', '200000.0000000000', '0', $
'Florida West', '902', '1', '-820000', '242000', '0', '0', $
    '0.9999411764705882', '200000.0000000000', '0', $
'Florida North', '903', '2', '-843000', '290000', '293500', '304500', $
    '1', '600000.0000000000', '0', $
'Georgia East', '1001', '1', '-821000', '300000', '0', '0', $
    '0.9999', '200000.0000000000', '0', $
'Georgia West', '1002', '1', '-841000', '300000', '0', '0', $
    '0.9999', '700000.0000000000', '0', $
'Hawaii 1', '5101', '1', '-1553000', '185000', '0', '0', $
    '0.9999666666666667', '500000.0000000000', '0', $
'Hawaii 2', '5102', '1', '-1564000', '202000', '0', '0', $
    '0.9999666666666667', '500000.0000000000', '0', $
'Hawaii 3', '5103', '1', '-1580000', '211000', '0', '0', $
    '0.9999900000000001', '500000.0000000000', '0', $
'Hawaii 4', '5104', '1', '-1593000', '215000', '0', '0', $
    '0.9999900000000001', '500000.0000000000', '0', $
'Hawaii 5', '5105', '1', '-1601000', '214000', '0', '0', $
    '1', '500000.0000000000', '0', $
'Idaho East', '1101', '1', '-1121000', '414000', '0', '0', $
    '0.9999473684210526', '200000.0000000000', '0', $
'Idaho Central', '1102', '1', '-1140000', '414000', '0', '0', $
    '0.9999473684210526', '500000.0000000000', '0', $
'Idaho West', '1103', '1', '-1154500', '414000', '0', '0', $
    '0.9999333333333333', '800000.0000000000', '0', $
'Illinois East', '1201', '1', '-882000', '364000', '0', '0', $
    '0.9999750000000000', '300000.0000000000', '0', $
'Illinois West', '1202', '1', '-901000', '364000', '0', '0', $
    '0.9999411764705882', '700000.0000000000', '0', $
'Indiana East', '1301', '1', '-854000', '373000', '0', '0', $
    '0.9999666666666667', '100000.0000000000', '250000.0000000000', $
'Indiana West', '1302', '1', '-870500', '373000', '0', '0', $
    '0.9999666666666667', '900000.0000000000', '250000.0000000000', $
'Iowa North', '1401', '2', '-933000', '413000', '420400', '431600', $
    '1', '1500000.000000000', '1000000.000000000', $
'Iowa South', '1402', '2', '-933000', '400000', '403700', '414700', $
    '1', '500000.0000000000', '0', $
'Kansas North', '1501', '2', '-980000', '382000', '384300', '394700', $
    '1', '400000.0000000000', '0', $
'Kansas South', '1502', '2', '-983000', '364000', '371600', '383400', $
    '1', '400000.0000000000', '400000.0000000000', $
'Kentucky North', '1601', '2', '-841500', '373000', '375800', '385800', $
    '1', '500000.0000000000', '0', $
'Kentucky South', '1602', '2', '-854500', '362000', '364400', '375600', $
    '1', '500000.0000000000', '500000.0000000000', $
'Louisiana North', '1701', '2', '-923000', '303000', '311000', '324000', $
    '1', '1000000.000000000', '0', $
'Louisiana South', '1702', '2', '-912000', '283000', '291800', '304200', $
    '1', '1000000.000000000', '0', $
'Louisiana Offshore', '1703', '2', '-912000', '253000', '261000', '275000', $
    '1', '1000000.000000000', '0', $
'Maine East', '1801', '1', '-683000', '434000', '0', '0', $
    '0.9999', '300000.0000000000', '0', $
'Maine West', '1802', '1', '-701000', '425000', '0', '0', $
    '0.9999666666666667', '900000.0000000000', '0', $
'Maryland', '1900', '2', '-770000', '374000', '381800', '392700', $
    '1', '400000.0000000000', '0', $
'Massachusetts Mainland', '2001', '2', '-713000', '410000', '414300', '424100', $
    '1', '200000.0000000000', '750000.0000000000', $
'Massachusetts Island', '2002', '2', '-703000', '410000', '411700', '412900', $
    '1', '500000.0000000000', '0', $
'Michigan North', '2111', '2', '-870000', '444700', '452900', '470500', $
    '1', '8000000.000000000', '0', $
'Michigan Central', '2112', '2', '-842200', '431900', '441100', '454200', $
    '1', '6000000.000000000', '0', $
'Michigan South', '2113', '2', '-842200', '413000', '420600', '434000', $
    '1', '4000000.000000000', '0', $
'Minnesota North', '2201', '2', '-930600', '463000', '470200', '483800', $
    '1', '800000.0000000000', '100000.0000000000', $
'Minnesota Central', '2202', '2', '-941500', '450000', '453700', '470300', $
    '1', '800000.0000000000', '100000.0000000000', $
'Minnesota South', '2203', '2', '-940000', '430000', '434700', '451300', $
    '1', '800000.0000000000', '100000.0000000000', $
'Mississippi East', '2301', '1', '-885000', '293000', '0', '0', $
    '0.9999500000000000', '300000.0000000000', '0', $
'Mississippi West', '2302', '1', '-902000', '293000', '0', '0', $
    '0.9999500000000000', '700000.0000000000', '0', $
'Missouri East', '2401', '1', '-903000', '355000', '0', '0', $
    '0.9999333333333333', '250000.0000000000', '0', $
'Missouri Central', '2402', '1', '-923000', '355000', '0', '0', $
    '0.9999333333333333', '500000.0000000000', '0', $
'Missouri West', '2403', '1', '-943000', '361000', '0', '0', $
    '0.9999411764705882', '850000.0000000000', '0', $
'Montana', '2500', '2', '-1093000', '441500', '450000', '490000', $
    '1', '600000.0000000000', '0', $
'Nebraska', '2600', '2', '-1000000', '395000', '400000', '430000', $
    '1', '500000.0000000000', '0', $
'Nevada East', '2701', '1', '-1153500', '344500', '0', '0', $
    '0.9999', '200000.0000000000', '8000000.000000000', $
'Nevada Central', '2702', '1', '-1164000', '344500', '0', '0', $
    '0.9999', '500000.0000000000', '6000000.000000000', $
'Nevada West', '2703', '1', '-1183500', '344500', '0', '0', $
    '0.9999', '800000.0000000000', '4000000.000000000', $
'New Hampshire', '2800', '1', '-714000', '423000', '0', '0', $
    '0.9999666666666667', '300000.0000000000', '0', $
'New Jersey', '2900', '1', '-743000', '385000', '0', '0', $
    '0.9999', '150000.0000000000', '0', $
'New Mexico East', '3001', '1', '-1042000', '310000', '0', '0', $
    '0.9999090909090909', '165000.0000000000', '0', $
'New Mexico Central', '3002', '1', '-1061500', '310000', '0', '0', $
    '0.9999', '500000.0000000000', '0', $
'New Mexico West', '3003', '1', '-1075000', '310000', '0', '0', $
    '0.9999166666666667', '830000.0000000000', '0', $
'New York East', '3101', '1', '-743000', '385000', '0', '0', $
    '0.9999', '150000.0000000000', '0', $
'New York Central', '3102', '1', '-763500', '400000', '0', '0', $
    '0.9999375000000000', '250000.0000000000', '0', $
'New York West', '3103', '1', '-783500', '400000', '0', '0', $
    '0.9999375000000000', '350000.0000000000', '0', $
'New York Long Island', '3104', '2', '-740000', '401000', '404000', '410200', $
    '1', '300000.0000000000', '0', $
'North Carolina', '3200', '2', '-790000', '334500', '342000', '361000', $
    '1', '609601.2200000000', '0', $
'North Dakota North', '3301', '2', '-1003000', '470000', '472600', '484400', $
    '1', '600000.0000000000', '0', $
'North Dakota South', '3302', '2', '-1003000', '454000', '461100', '472900', $
    '1', '600000.0000000000', '0', $
'Ohio North', '3401', '2', '-823000', '394000', '402600', '414200', $
    '1', '600000.0000000000', '0', $
'Ohio South', '3402', '2', '-823000', '380000', '384400', '400200', $
    '1', '600000.0000000000', '0', $
'Oklahoma North', '3501', '2', '-980000', '350000', '353400', '364600', $
    '1', '600000.0000000000', '0', $
'Oklahoma South', '3502', '2', '-980000', '332000', '335600', '351400', $
    '1', '600000.0000000000', '0', $
'Oregon North', '3601', '2', '-1203000', '434000', '442000', '460000', $
    '1', '2500000.000000000', '0', $
'Oregon South', '3602', '2', '-1203000', '414000', '422000', '440000', $
    '1', '1500000.000000000', '0', $
'Pennsylvania North', '3701', '2', '-774500', '401000', '405300', '415700', $
    '1', '600000.0000000000', '0', $
'Pennsylvania South', '3702', '2', '-774500', '392000', '395600', '405800', $
    '1', '600000.0000000000', '0', $
'Rhode Island', '3800', '1', '-713000', '410500', '0', '0', $
    '0.9999937500000000', '100000.0000000000', '0', $
'South Carolina', '3900', '2', '-810000', '315000', '323000', '345000', $
    '1', '609600.0000000000', '0', $
'South Dakota North', '4001', '2', '-1000000', '435000', '442500', '454100', $
    '1', '600000.0000000000', '0', $
'South Dakota South', '4002', '2', '-1002000', '422000', '425000', '442400', $
    '1', '600000.0000000000', '0', $
'Tennessee', '4100', '2', '-860000', '342000', '351500', '362500', $
    '1', '600000.0000000000', '0', $
'Texas North', '4201', '2', '-1013000', '340000', '343900', '361100', $
    '1', '200000.0000000000', '1000000.000000000', $
'Texas North Central', '4202', '2', '-983000', '314000', '320800', '335800', $
    '1', '600000.0000000000', '2000000.000000000', $
'Texas Central', '4203', '2', '-1002000', '294000', '300700', '315300', $
    '1', '700000.0000000000', '3000000.000000000', $
'Texas South Central', '4204', '2', '-990000', '275000', '282300', '301700', $
    '1', '600000.0000000000', '4000000.000000000', $
'Texas South', '4205', '2', '-983000', '254000', '261000', '275000', $
    '1', '300000.0000000000', '5000000.000000000', $
'Utah North', '4301', '2', '-1113000', '402000', '404300', '414700', $
    '1', '500000.0000000000', '1000000.000000000', $
'Utah Central', '4302', '2', '-1113000', '382000', '390100', '403900', $
    '1', '500000.0000000000', '2000000.000000000', $
'Utah South', '4303', '2', '-1113000', '364000', '371300', '382100', $
    '1', '500000.0000000000', '3000000.000000000', $
'Vermont', '4400', '1', '-723000', '423000', '0', '0', $
    '0.9999642857142858', '500000.0000000000', '0', $
'Virginia North', '4501', '2', '-783000', '374000', '380200', '391200', $
    '1', '3500000.000000000', '2000000.000000000', $
'Virginia South', '4502', '2', '-783000', '362000', '364600', '375800', $
    '1', '3500000.000000000', '1000000.000000000', $
'Washington North', '4601', '2', '-1205000', '470000', '473000', '484400', $
    '1', '500000.0000000000', '0', $
'Washington South', '4602', '2', '-1203000', '452000', '455000', '472000', $
    '1', '500000.0000000000', '0', $
'West Virginia North', '4701', '2', '-793000', '383000', '390000', '401500', $
    '1', '600000.0000000000', '0', $
'West Virginia South', '4702', '2', '-810000', '370000', '372900', '385300', $
    '1', '600000.0000000000', '0', $
'Wisconsin North', '4801', '2', '-900000', '451000', '453400', '464600', $
    '1', '600000.0000000000', '0', $
'Wisconsin Central', '4802', '2', '-900000', '435000', '441500', '453000', $
    '1', '600000.0000000000', '0', $
'Wisconsin South', '4803', '2', '-900000', '420000', '424400', '440400', $
    '1', '600000.0000000000', '0', $
'Wyoming East', '4901', '1', '-1051000', '403000', '0', '0', $
    '0.9999375000000000', '200000.0000000000', '0', $
'Wyoming East Central', '4902', '1', '-1072000', '403000', '0', '0', $
    '0.9999375000000000', '400000.0000000000', '100000.0000000000', $
'Wyoming West Central', '4903', '1', '-1084500', '403000', '0', '0', $
    '0.9999375000000000', '600000.0000000000', '0', $
'Wyoming West', '4904', '1', '-1100500', '403000', '0', '0', $
    '0.9999375000000000', '800000.0000000000', '100000.0000000000', $
'Puerto Rico Virgin Islands', '5200', '2', '-662600', '175000', '180200', '182600', $
    '1', '200000.0000000000', '200000.0000000000']


    n = N_ELEMENTS(nad27)/10
    nad27 = REFORM(nad27, 10, n)

    c_StatePlane_NAD27names = REFORM(nad27[0, *])
    c_StatePlane_NAD27numbers = REFORM(FIX(nad27[1, *]))
    c_StatePlane_NAD27proj = BYTE(nad27[2, *])
    c_StatePlane_NAD27params = DOUBLE(nad27[3:*, *])
    ddmmss = LONG(c_StatePlane_NAD27params[0:3, *])
    degrees = ddmmss/10000
    ddmmss -= degrees*10000
    minutes = ddmmss/100
    ddmmss -= minutes*100
    c_StatePlane_NAD27params[0:3, *] = degrees + minutes/60d + ddmmss/3600d

    n = N_ELEMENTS(nad83)/10
    nad83 = REFORM(nad83, 10, n)

    c_StatePlane_NAD83names = REFORM(nad83[0, *])
    c_StatePlane_NAD83numbers = REFORM(FIX(nad83[1, *]))
    c_StatePlane_NAD83proj = BYTE(nad83[2, *])
    c_StatePlane_NAD83params = DOUBLE(nad83[3:*, *])
    ddmmss = LONG(c_StatePlane_NAD83params[0:3, *])
    degrees = ddmmss/10000
    ddmmss -= degrees*10000
    minutes = ddmmss/100
    ddmmss -= minutes*100
    c_StatePlane_NAD83params[0:3, *] = degrees + minutes/60d + ddmmss/3600d

end


;---------------------------------------------------------------------------
pro map_proj_init_common_geodatum

    compile_opt idl2, hidden

; Include our common block.
@map_proj_init_commonblock

    geodatums = [ $
    ['Adindan', 'Clarke 1880', '-166', '-15', '204'], $
    ['Afgooye', 'Krassovsky', '-43', '-163', '45'], $
    ['Ain El Abd 1970', 'International 1909', '-150', '-251', '-2'], $
    ['Alaska (NAD-27)', 'Clarke 1866', '-5', '135', '172'], $
    ['Alaska/Canada NAD-27', 'Clarke 1866', '-9', '151', '185'], $
    ['Anna 1 Astro 1965', 'Australian National', '-491', '-22', '435'], $
    ['ARC-1950 mean', 'Clarke 1880', '-143', '-90', '-294'], $
    ['ARC-1960 mean', 'Clarke 1880', '-160', '-8', '-300'], $
    ['Ascension Island 58', 'International 1909', '-207', '107', '52'], $
    ['Astro B4 Sor.Atoll', 'International 1909', '114', '-116', '-333'], $
    ['Astro Beacon "E"', 'International 1909', '145', '75', '-272'], $
    ['Astro Pos 71/4', 'International 1909', '-320', '550', '-494'], $
    ['Astronomic Stn. 52', 'International 1909', '124', '-234', '-25'], $
    ['Australian Geodetic 1966', 'Australian National', '-133', '-48', '148'], $
    ['Australian Geodetic 1984', 'Australian National', '-134', '-48', '149'], $
    ['Geocentric Datum of Australia 1994', 'GRS1980/WGS84', '0', '0', '0'], $
    ['Bahamas (NAD-27)', 'Clarke 1866', '-4', '154', '178'], $
    ['Bellevue (IGN)', 'International 1909', '-127', '-769', '472'], $
    ['Bermuda 1957', 'Clarke 1866', '-73', '213', '296'], $
    ['Bogota Observatory', 'International 1909', '307', '304', '-318'], $
    ['Bukit Rimpah', 'Bessel 1841', '-384', '664', '-48'], $
    ['Camp Area Astro', 'International 1909', '-104', '-129', '239'], $
    ['Campo Inchauspe', 'International 1909', '-148', '136', '90'], $
    ['Canada Mean (NAD27)', 'Clarke 1866', '-10', '158', '187'], $
    ['Canal Zone (NAD27)', 'Clarke 1866', '0', '125', '201'], $
    ['Canton Island 1966', 'International 1909', '298', '-304', '-375'], $
    ['Cape', 'Clarke 1880', '-136', '-108', '-292'], $
    ['Cape Canaveral mean', 'Clarke 1866', '-2', '150', '181'], $
    ['Carribean (NAD27)', 'Clarke 1866', '-7', '152', '178'], $
    ['Carthage', 'Clarke 1880', '-263', '6', '431'], $
    ['Central America (NAD27)', 'Clarke 1866', '0', '125', '194'], $
    ['Chatham 1971', 'International 1909', '175', '-38', '113'], $
    ['Chua Astro', 'International 1909', '-134', '229', '-29'], $
    ['Corrego Alegre', 'International 1909', '-206', '172', '-6'], $
    ['Corrego Alegre (Provisional)', 'International 1909', '-206', '172', '-6'], $
    ['Cuba (NAD27)', 'Clarke 1866', '-9', '152', '178'], $
    ['Cyprus', 'International 1909', '-104', '-101', '-140'], $
    ['Djakarta(Batavia)', 'Bessel 1841', '-377', '681', '-50'], $
    ['DOS 1968', 'International 1909', '230', '-199', '-752'], $
    ['Easter Island 1967', 'International 1909', '211', '147', '111'], $
    ['Egypt', 'International 1909', '-130', '-117', '-151'], $
    ['European 1950', 'International 1909', '-87', '-96', '-120'], $
    ['European 1950 mean', 'International 1909', '-87', '-98', '-121'], $
    ['European 1979 mean', 'International 1909', '-86', '-98', '-119'], $
    ['Finnish Nautical Chart', 'International 1909', '-78', '-231', '-97'], $
    ['Gandajika Base', 'International 1909', '-133', '-321', '50'], $
    ['Geodetic Datum 49', 'International 1909', '84', '-22', '209'], $
    ['Ghana', 'WGS 84', '0', '0', '0'], $
    ['Greenland (NAD27)', 'Clarke 1866', '11', '114', '195'], $
    ['Guam 1963', 'Clarke 1866', '-100', '-248', '259'], $
    ['Gunung Segara', 'Bessel 1841', '-403', '684', '41'], $
    ['Gunung Serindung 1962', 'WGS 84', '0', '0', '0'], $
    ['GUX 1 Astro', 'International 1909', '252', '-209', '-751'], $
    ['Herat North', 'International 1909', '-333', '-222', '114'], $
    ['Hjorsey 1955', 'International 1909', '-73', '46', '-86'], $
    ['Hong Kong 1963', 'International 1909', '-156', '-271', '-189'], $
    ['Hu-Tzu-Shan', 'International 1909', '-634', '-549', '-201'], $
    ['Indian', 'Everest', '289', '734', '257'], $
    ['Iran', 'International 1909', '-117', '-132', '-164'], $
    ['Ireland 1965', 'Modified Airy', '506', '-122', '611'], $
    ['ISTS 073 Astro 69', 'International 1909', '208', '-435', '-229'], $
    ['Johnston Island 61', 'International 1909', '191', '-77', '-204'], $
    ['Kandawala', 'Everest', '-97', '787', '86'], $
    ['Kerguelen Island', 'International 1909', '145', '-187', '103'], $
    ['Kertau 48', 'Modified Everest', '-11', '851', '5'], $
    ['L.C. 5 Astro', 'Clarke 1866', '42', '124', '147'], $
    ['La Reunion', 'International 1909', '94', '-948', '-1262'], $
    ['Liberia 1964', 'Clarke 1880', '-90', '40', '88'], $
    ['Luzon', 'Clarke 1866', '-133', '-77', '-51'], $
    ['Mahe 1971', 'Clarke 1880', '41', '-220', '-134'], $
    ['Marco Astro', 'International 1909', '-289', '-124', '60'], $
    ['Masirah Is. (Nahrwan)', 'Clarke 1880', '-247', '-148', '369'], $
    ['Massawa', 'Bessel 1841', '639', '405', '60'], $
    ['Merchich', 'Clarke 1880', '31', '146', '47'], $
    ['Mexico (NAD27)', 'Clarke 1866', '-12', '130', '190'], $
    ['Midway Astro 61', 'International 1909', '912', '-58', '1227'], $
    ['Mindanao', 'Clarke 1866', '-133', '-79', '-72'], $
    ['Minna', 'Clarke 1880', '-92', '-93', '122'], $
    ['Montjong Lowe', 'WGS 84', '0', '0', '0'], $
    ['Nahrwan', 'Clarke 1880', '-231', '-196', '482'], $
    ['Naparima BWI', 'International 1909', '-2', '374', '172'], $
    ['North America 1983', 'GRS1980/WGS84', '0', '0', '0'], $
    ['North America 1927', 'Clarke 1866', '-8', '160', '176'], $
    ['Nouvelle Triangulation Francaise IGN', 'Clarke IGN', '-168', '-60', '320'], $
    ['Observatorio 1966', 'International 1909', '-425', '-169', '81'], $
    ['Old Egyptian', 'Helmert 1906', '-130', '110', '-13'], $
    ['Old Hawaiian mean', 'Clarke 1866', '89', '-279', '-183'], $
    ['Old Hawaiian Kauai', 'Clarke 1866', '45', '-290', '-172'], $
    ['Old Hawaiian Maui', 'Clarke 1866', '65', '-290', '-190'], $
    ['Old Hawaiian Oahu', 'Clarke 1866', '56', '-284', '-181'], $
    ['Oman', 'Clarke 1880', '-346', '-1', '224'], $
    ['Ordnance Survey of Great Britain 36', 'Airy', '375', '-111', '431'], $
    ['Pico De Las Nieves', 'International 1909', '-307', '-92', '127'], $
    ['Pitcairn Astro 67', 'International 1909', '185', '165', '42'], $
    ['Provisional South American 1956 mean', 'International 1909', '-288', '175', '-376'], $
    ['Provisional South Chilean 1963', 'International 1909', '16', '196', '93'], $
    ['Puerto Rico', 'Clarke 1866', '11', '72', '-101'], $
    ['Qornoq', 'International 1909', '164', '138', '-189'], $
    ['Qatar National', 'International 1909', '-128', '-283', '22'], $
    ['Reseau Geodesique Francaise', 'GRS1980/WGS84', '0', '0', '0'], $
    ['Rome 1940', 'International 1909', '-225', '-65', '9'], $
    ['SAD-69/Brazil', 'South American 1969', '-60', '-2', '-41'], $
    ['Santa Braz', 'International 1909', '-203', '141', '53'], $
    ['Santo (DOS)', 'International 1909', '170', '42', '84'], $
    ['Sapper Hill 43', 'International 1909', '-355', '16', '74'], $
    ['Sicily', 'International 1909', '-97', '-88', '-135'], $
    ['Sierra Leone 1960', 'WGS 84', '0', '0', '0'], $
    ['South American 1969 mean', 'South American 1969', '-57', '1', '-41'], $
    ['South Asia', 'Modified Fischer 1960', '7', '-10', '-26'], $
    ['Southeast Base', 'International 1909', '-499', '-249', '314'], $
    ['Southwest Base', 'International 1909', '-104', '167', '-38'], $
    ['Tananarive Observatory 25', 'International 1909', '-189', '-242', '-91'], $
    ['Thai/Viet (Indian)', 'Everest', '214', '836', '303'], $
    ['Timbalai 1948', 'Everest', '-689', '691', '-45'], $
    ['Tokyo mean', 'Bessel 1841', '-128', '481', '664'], $
    ['Tristan Astro 1968', 'International 1909', '-632', '438', '-609'], $
    ['Unites Arab Emirates (Nahrwan)', 'Clarke 1880', '-249', '-156', '381'], $
    ['Viti Levu 1916', 'Clarke 1880', '51', '391', '-36'], $
    ['Wake-Eniwetok 60', 'Hough', '101', '52', '-39'], $
    ['WGS-72', 'WGS 72', '0', '0', '5'], $
    ['WGS-84', 'WGS 84', '0', '0', '0'], $
    ['Yacare', 'International 1909', '-155', '171', '37'], $
    ['Zanderij', 'International 1909', '-265', '120', '-358']]

    c_GeoDatumNames = REFORM(geodatums[0, *])
    c_GeoDatumEllipsoid = REFORM(geodatums[1, *])
    c_GeoDatumParams = REFORM(LONG(geodatums[2:*, *]))

end


;---------------------------------------------------------------------------
; Undocumented routine to initialize the common block needed
; for MAP_PROJ_INIT.
;
; Use this code at your own risk. RSI reserves the right to modify or
; remove this routine.
;
; CT, RSI, April 2004.
;
pro map_proj_init_common

    compile_opt idl2, hidden

    ; Need to set a flag to avoid recursively calling ourself.
    inMapProjInitCommon = 1b ;  Do not remove!

; Include our common block.
@map_proj_init_commonblock

; How this table works:
;
; The GCTP projections expect a vector of 16 parameters to be passed in
; (only the first 13 are actually used). These parameters are given in
; the following table, using code words that correspond to
; MAP_PROJ_INIT keywords. When the user inputs a keyword, its position
; is looked up in the following table, and the parameter is filled in
; with the keyword value. Then the GCTP init routine is called with
; the 16-element array. The parameter position within the table is crucial.
;
; For convenience, the original IDL projections (the first 19 below)
; are also layed out using the same table format. In this case,
; the code words again correspond to MAP_PROJ_INIT keywords. However,
; these keywords are simply used directly within MAP_PROJ_IDL_INIT.
; The parameter position within the table is thus unimportant, but
; has been chosen to match the GCTP positions.
;
    projections = [ $
; --------------------------------------------------------------------------------------------
;   Code & Projection Id        | 0  | 1  | 2  | 3  | 4  | 5  | 6| 7| 8  | 9  | 10 | 11 | 12 |
; --------------------------------------------------------------------------------------------
; Built-in IDL Projections
'001 Stereographic              |sphe|    |    |    |clon|clat|rotm', $
'002 Orthographic               |sphe|    |    |    |clon|clat|rotm', $
'003 Lambert Conic              |sphe|    |spr1|spr2|clon|clat|rotm', $
'004 Lambert Azimuthal          |sphe|    |    |    |clon|clat|rotm', $
'005 Gnomonic                   |sphe|    |    |    |clon|clat|rotm', $
'006 Azimuthal Equidistant      |sphe|    |    |    |clon|clat|rotm', $
'007 Satellite                  |sphe|    |hght|tilt|clon|clat|rotm', $
'008 Cylindrical                |sphe|    |    |cazm|clon|clat|rotm', $
'009 Mercator                   |sphe|    |    |cazm|clon|clat|rotm', $
'010 Mollweide                  |sphe|    |    |cazm|clon|clat|rotm', $
'011 Sinusoidal                 |sphe|    |    |cazm|clon|clat|rotm', $
'012 Aitoff                     |sphe|    |    |    |clon|clat|rotm', $
'013 Hammer Aitoff              |sphe|    |    |    |clon|clat|rotm', $
'014 Albers Equal Area Conic    |sphe|    |spr1|spr2|clon|clat|rotm', $
'015 Transverse Mercator        |smaj|smin|sfac|    |clon|clat|rotm', $
'016 Miller Cylindrical         |sphe|    |    |cazm|clon|clat|rotm', $
'017 Robinson                   |sphe|    |    |cazm|clon|clat|rotm', $
'018 Lambert Ellipsoid Conic    |smaj|smin|spr1|spr2|clon|clat|rotm', $
'019 Goodes Homolosine          |sphe|    |    |    |clon|', $
; GCTP Projections
;'100 Geographic                 |    |    |    |    |    |    |  |  |',$
'101 UTM                        |clon|clat|zone|    |    |    |  |  |',$
'102 State Plane                |    |    |zone|    |    |    |  |  |',$
'103 Albers Equal Area          |smaj|smin|spr1|spr2|clon|clat|fe|fn|',$
'104 Lambert Conformal Conic    |smaj|smin|spr1|spr2|clon|clat|fe|fn|',$
'105 Mercator                   |smaj|smin|    |    |clon|slat|fe|fn|',$
'106 Polar Stereographic        |smaj|smin|    |    |clon|clat|fe|fn|',$
'107 Polyconic                  |smaj|smin|    |    |clon|clat|fe|fn|',$
'108 Equidistant Conic A        |smaj|smin|spar|    |clon|clat|fe|fn|0|',$
'208 Equidistant Conic B        |smaj|smin|spr1|spr2|clon|clat|fe|fn|1|',$
'109 Transverse Mercator        |smaj|smin|sfac|    |clon|clat|fe|fn|',$
'110 Stereographic              |sphe|    |    |    |clon|clat|fe|fn|',$
'111 Lambert Azimuthal          |sphe|    |    |    |clon|clat|fe|fn|',$
'112 Azimuthal Equidistant      |sphe|    |    |    |clon|clat|fe|fn|',$
'113 Gnomonic                   |sphe|    |    |    |clon|clat|fe|fn|',$
'114 Orthographic               |sphe|    |    |    |clon|clat|fe|fn|',$
'115 Near Side Perspective      |sphe|    |hght|    |clon|clat|fe|fn|',$;
'116 Sinusoidal                 |sphe|    |    |    |clon|    |fe|fn|',$
'117 Equirectangular            |sphe|    |    |    |clon|slat|fe|fn|',$
'118 Miller Cylindrical         |sphe|    |    |    |clon|    |fe|fn|',$
'119 Van der Grinten            |sphe|    |    |    |clon|clat|fe|fn|',$
'120 Hotine Oblique Mercator A  |smaj|smin|sfac|    |    |clat|fe|fn|lon1|lat1|lon2|lat2|0|',$
'220 Hotine Oblique Mercator B  |smaj|smin|sfac|azma|azml|clat|fe|fn|    |    |    |    |1|',$
'121 Robinson                   |sphe|    |    |    |clon|    |fe|fn|',$
'122 Space Oblique Mercator A   |smaj|smin|    |incl|ascl|    |fe|fn|psat|lrat|pflg|    |0|',$
'222 Space Oblique Mercator B   |smaj|smin|satn|path|    |    |fe|fn|    |    |    |    |1|',$
'123 Alaska Conformal           |smaj|smin|    |    |    |    |fe|fn|',$
'124 Interrupted Goode          |sphe|    |    |    |    |    |  |  |',$
'125 Mollweide                  |sphe|    |    |    |clon|    |fe|fn|',$
'126 Interrupted Mollweide      |sphe|    |    |    |    |    |  |  |',$
'127 Hammer                     |sphe|    |    |    |clon|    |fe|fn|',$
'128 Wagner IV                  |sphe|    |    |    |clon|    |fe|fn|',$
'129 Wagner VII                 |sphe|    |    |    |clon|    |fe|fn|',$
'130 Oblated Equal Area         |sphe|    |shpm|shpn|clon|clat|fe|fn|rota|',$
'131 Integerized Sinusoidal     |sphe|    |    |    |clon|    |fe|fn|izon|    |just|']
; --------------------------------------------------------------------------------------------

; Actual keyword names that correspond to the codes in the above table.
; This allows us to easily change keyword names if desired.
    keywords = [ $
    ; True keyword name     Code  isAngle
    ['CENTER_AZIMUTH',      'cazm','1'], $
    ['CENTER_LATITUDE',     'clat','1'], $
    ['CENTER_LONGITUDE',    'clon','1'], $
    ['FALSE_EASTING',       'fe',  '0'], $
    ['FALSE_NORTHING',      'fn',  '0'], $
    ['HEIGHT',              'hght','0'], $
    ['HOM_AZIM_LONGITUDE',  'azml','1'], $
    ['HOM_AZIM_ANGLE',      'azma','1'], $
    ['HOM_LATITUDE1',       'lat1','1'], $
    ['HOM_LATITUDE2',       'lat2','1'], $
    ['HOM_LONGITUDE1',      'lon1','1'], $
    ['HOM_LONGITUDE2',      'lon2','1'], $
    ['IS_ZONES',            'izon','0'], $
    ['IS_JUSTIFY',          'just','0'], $
    ['MERCATOR_SCALE',      'sfac','0'], $
    ['OEA_ANGLE',           'rota','1'], $
    ['OEA_SHAPEM',          'shpm','0'], $
    ['OEA_SHAPEN',          'shpn','0'], $
    ['ROTATION',            'rotm','1'], $
    ['SEMIMAJOR_AXIS',      'smaj','0'], $
    ['SEMIMINOR_AXIS',      'smin','0'], $
    ['SOM_INCLINATION',     'incl','1'], $
    ['SOM_LONGITUDE',       'ascl','1'], $
    ['SOM_PERIOD',          'psat','0'], $
    ['SOM_RATIO',           'lrat','0'], $
    ['SOM_FLAG',            'pflg','0'], $
    ['SOM_LANDSAT_NUMBER',  'satn','0'], $
    ['SOM_LANDSAT_PATH',    'path','0'], $
    ['SPHERE_RADIUS',       'sphe','0'], $
    ['STANDARD_PARALLEL',   'spar','1'], $
    ['STANDARD_PAR1',       'spr1','1'], $
    ['STANDARD_PAR2',       'spr2','1'], $
    ['SAT_TILT',            'tilt','1'], $
    ['TRUE_SCALE_LATITUDE', 'slat','1'], $
    ['ZONE',                'zone','0']]

    np = N_ELEMENTS(projections)
    c_ProjNames = STRARR(np)
    c_ProjNumber = INTARR(np)
    c_ProjParameters = STRARR(16,np)
    keywordCodes = keywords[1,*]
    c_keywordNames = keywords[0,*]

    ; Split up the projection table into names, number and parameters.
    for i=0,np-1 do begin
        projParams = STRSPLIT(projections[i], '|', $
            /EXTRACT, /PRESERVE_NULL)
        c_ProjNames[i] = STRTRIM(STRMID(projParams[0], 4), 2)
        c_ProjNumber[i] = FIX(STRMID(projParams[0], 0, 3))
        c_ProjParameters[0,i] = STRTRIM(projParams[1:*], 2)
    endfor
    c_ProjCompressNames = STRCOMPRESS(c_ProjNames, /REMOVE_ALL)

    ; Convert our projection numbers to GCTP package numbers.
    c_ProjNumToGCTP = (c_ProjNumber > 100) mod 100
    ; In GCTP package, Integerized Sinusoidal is #99
    c_ProjNumToGCTP[WHERE(c_ProjNumber eq 131)] = 99

    ; Replace shorthand keyword codes with actual keyword names.
    for i=0,N_ELEMENTS(keywordCodes)-1 do begin
        c_ProjParameters[WHERE(c_ProjParameters eq keywordCodes[i])] = $
            c_keywordNames[i]
    endfor

;   Dump projections and parameters out to a file.
;    for i=0,np-1 do printf,1,strcompress(c_projnumber[i],/rem)+'|'+ $
;       c_projnames[i]+'|'+ string(c_projparameters[ $
;       where(c_projparameters[*,i] ne ''),i],format='(16(A,:,", "))')

    ; Names of parameters which are angles.
    c_ParamIsAngle = keywords[2,*] eq '1'

    ; Taken from gctp/sphdz.c
    ;               SUPPORTED DATUMS
    ; Note: Spaces within these names are ignored.
    ellipsoids = [ $
        ; Name                    Semimajor      Semiminor
        ['Clarke 1866',          '6378206.4',    '6356583.8'], $
        ['Clarke 1880',          '6378249.145',  '6356514.86955'], $
        ['Bessel 1841',          '6377397.155',  '6356078.96284'], $
        ['International 1967',   '6378157.5',    '6356772.2'], $
        ['International 1909',   '6378388.0',    '6356911.94613'], $
        ['WGS 72',               '6378135.0',    '6356750.519915'], $
        ['Everest',              '6377276.3452', '6356075.4133'], $
        ['WGS 66',               '6378145.0',    '6356759.769356'], $
        ['GRS1980/WGS84',        '6378137.0',    '6356752.31414'], $
        ['Airy',                 '6377563.396',  '6356256.91'], $
        ['Modified Everest',     '6377304.063',  '6356103.039'], $
        ['Modified Airy',        '6377340.189',  '6356034.448'], $
        ['Walbeck',              '6378137.0',    '6356752.314245'], $
        ['Southeast Asia',       '6378155.0',    '6356773.3205'], $
        ['Australian National',  '6378160.0',    '6356774.719'], $
        ['Krassovsky',           '6378245.0',    '6356863.0188'], $
        ['Hough',                '6378270.0',    '6356794.343479'], $
        ['Mercury 1960',         '6378166.0',    '6356784.283666'], $
        ['Modified Mercury 1968','6378150.0',    '6356768.337303'], $
        ['Sphere',               '6370997.0',    '6370997.0'], $
        ['Clarke IGN',           '6378249.2',    '6356515.0'], $
        ['Helmert 1906',         '6378200.0',    '6356818.2'], $
        ['Modified Fischer 1960','6378155.0',    '6356773.3'], $
        ['South American 1969',  '6378160.0',    '6356774.7'], $
        ['WGS 84',               '6378137.0',    '6356752.314245']]

    c_EllipsoidNames = REFORM(ellipsoids[0,*])
    c_EllipsoidMajor = REFORM(DOUBLE(ellipsoids[1,*]))
    c_EllipsoidMinor = REFORM(DOUBLE(ellipsoids[2,*]))

    map_proj_init_common_stateplane

    map_proj_init_common_geodatum


end


