; $Id: //depot/idl/IDL_71/idldir/examples/widgets/wexmast/wmotion.pro#1 $
;
; Copyright (c) 1993-2009, ITT Visual Information Solutions. All
;       rights reserved.

; This is the code for a draw widget that returns
; "motion events" when the cursor is moved over the 
; plotting window.  Don't be surprised if you select the
; 'Done' button and the X and Y coordinate labels 
; continue to change... a LOT of events will be 
; generated by moving the cursor over the window and
; it can take quite some time for the machine to catch
; up!



PRO wmotion_event, event

; This is the event handler for a draw widget which tracks
; cursor motion events.

; The COMMON block is used because the event handler needs
; widget ID's of the labels:

COMMON wmotionblock, x_label, y_label

; When a widget is selected, put its User Value into 'eventval':

WIDGET_CONTROL, event.id, GET_UVALUE = eventval

; Perform actions based on the User Value of the event:

CASE eventval OF
   'DRAW_WIN_EVENT': BEGIN
			; The help statement is useful for
			; debugging the event handler.  Try uncommenting
			; it to see the full structure returned by a 
			; draw window event.  Note the 'PRESS' and
			; 'RELEASE' fields.
			; HELP, /STRUCT, event

			; Only deal with the 'motion' event,
			; disregard the 'press' and 'release' events:

			IF (event.press EQ 0) AND (event.release EQ 0) THEN BEGIN
				; Print the device coordinates of the cursor
				WIDGET_CONTROL, x_label, $
				   SET_VALUE='X Coordinate: ' + STRING(event.x)

				WIDGET_CONTROL, y_label, $
				   SET_VALUE='Y Coordinate: ' + STRING(event.y)
			ENDIF
		     END

   'DONE': WIDGET_CONTROL, event.top, /DESTROY
ENDCASE

END



PRO wmotion, XSIZE=x_size, YSIZE=y_size, GROUP=GROUP

; This is the procedure that creates a draw widget that returns
; motion events.

; The COMMON block is used because the event handler needs
; widget ID's of the labels:

COMMON wmotionblock, x_label, y_label

swin = !D.WINDOW	; Remember the current window so it can be restored


; This example uses keywords to define the size of the draw area:

if (NOT keyword_set(x_size)) THEN x_size = 300
if (NOT keyword_set(y_size)) THEN y_size = 400

; A top-level base widget with the title "Motion Event Widget Example"
; will be created.  The size is left unspecified until the draw widget
; is created:

base = WIDGET_BASE(TITLE = 'Motion Event Widget Example', $
	/COLUMN)

; Setting the managed attribute indicates our intention to put this application
; under the control of XMANAGER, and prevents our draw widgets from
; becoming candidates for becoming the default window on WSET, -1. XMANAGER
; sets this, but doing it here prevents our own WSETs at startup from
; having that problem.
WIDGET_CONTROL, /MANAGED, base

; The 'DONE' button:

button1 = WIDGET_BUTTON(base, $
		UVALUE = 'DONE', $
		VALUE = 'DONE')

; A widget called 'draw' is created:

draw = WIDGET_DRAW(base, $
	/FRAME, $
	/MOTION_EVENTS, $		;generate LOTS of events
	UVALUE = 'DRAW_WIN_EVENT', $
	RETAIN = 2, $			;make sure window redraws when covered
	XSIZE = x_size, $
	YSIZE = y_size)

hint_label = WIDGET_LABEL(base, /FRAME, $
	VALUE='Move Cursor in Draw Window')

; Create the labels that will display the current x and y
; coordinates, leaving the value blank for now:

x_label = WIDGET_LABEL(base, /FRAME, /DYNAMIC_RESIZE, $
		VALUE='X Coordinate: ')

y_label = WIDGET_LABEL(base, /FRAME, /DYNAMIC_RESIZE, $
		VALUE='Y Coordinate: ')

; Realize the widgets:
WIDGET_CONTROL, base, /REALIZE

; Get the window number from the draw widget.  This can only be done
; after the widget has been realized:

WIDGET_CONTROL, draw, GET_VALUE=win_num

; Use TVSCL to display an image in the draw widget.  Set the window for
; the TVSCL command since there may be other draw windows.

WSET, win_num
orig_image = DIST(50)
TVSCL, REBIN(orig_image, x_size, y_size)

WSET, swin			; Restore the original window

; Hand off control of the widget to the XMANAGER:
XMANAGER, "wmotion", base, GROUP_LEADER=GROUP, /NO_BLOCK


END


