;  $Id: //depot/idl/IDL_71/idldir/examples/doc/utilities/read_ncdf_doc.pro#1 $

;  Copyright (c) 2005-2009, ITT Visual Information Solutions. All
;       rights reserved.
; 
;-------------------------------------------------------------
; Example NetCDF File Reader
;
; This program provides an example of a file reader routine
; designed to be used by the IDL Workbench. See the topic
; "Adding Custom File Readers" in the IDL help system for
; additional details.
;-------------------------------------------------------------

FUNCTION read_ncdf_doc, infile

  COMPILE_OPT idl2
  ON_ERROR, 2
  
  ; Ensure that a file is specified.
  IF N_PARAMS() LT 1 THEN $
    MESSAGE, 'Incorrect number of arguments.'
  
  ; Open the NetCDF file for reading.
  ncid = NCDF_OPEN(infile)
  IF (ncid EQ -1) THEN $
    MESSAGE, 'Error opening file: ' + infile
  
  ; Retrieve general information about this netcdf file.
  ncidinfo = NCDF_INQUIRE(ncid)
  
  ; Place the variables in local arrays.
  FOR i=0, ncidinfo.nvars-1 DO BEGIN
    vardata = NCDF_VARINQ(ncid, i)
    valid_varname = IDL_VALIDNAME(vardata.name, /CONVERT_ALL)
    varname = valid_varname
    NCDF_VARGET, ncid, i, varname      ; read in variable vardata.name
    data = (i EQ 0) ? CREATE_STRUCT(valid_varname, varname) : $
      CREATE_STRUCT(data, valid_varname, varname)
    ; Read in attribute data
    FOR j=0, vardata.natts-1 DO BEGIN
      att = NCDF_ATTNAME(ncid, i, j)
      attname = IDL_VALIDNAME(valid_varname + '_' + att)
      NCDF_ATTGET, ncid, i, att, value
      attinfo = NCDF_ATTINQ(ncid, i, att)
      IF (attinfo.datatype EQ 'CHAR') THEN value = STRING(value)
      data = CREATE_STRUCT(data, attname, value)
    ENDFOR
  ENDFOR
  
  ; Read in global attribute data
  FOR i=0, ncidinfo.ngatts-1 DO BEGIN
    att = NCDF_ATTNAME(ncid, /global, i)
    attname = IDL_VALIDNAME(att, /CONVERT_ALL)
    NCDF_ATTGET, ncid, /global, att, value
    attinfo = NCDF_ATTINQ(ncid, att, /global)
    IF (attinfo.datatype EQ 'CHAR') THEN value = STRING(value)
    data = CREATE_STRUCT(data, attname, value)
  ENDFOR
  
  ; Close the NetCDF file
  NCDF_CLOSE, ncid
  
  ; Return the data structure
  RETURN, data
  
END