;  $Id: //depot/idl/IDL_71/idldir/examples/doc/utilities/query_ncdf_doc.pro#1 $

;  Copyright (c) 2005-2009, ITT Visual Information Solutions. All
;       rights reserved.
; 
;-------------------------------------------------------------
; Example NetCDF File Query Routine
;
; This program provides an example of a file query routine
; designed to be used by the IDL Workbench. See the topic
; "Adding Custom File Readers" in the IDL help system for
; additional details.
;-------------------------------------------------------------

FUNCTION query_ncdf_doc, infile

  ; Ensure that a file is specified.
  IF N_PARAMS() LT 1 THEN $
    MESSAGE, 'Incorrect number of arguments.'
    
  ; Open the NetCDF file for reading.
  ncid = NCDF_OPEN(infile)
  success = (ncid EQ -1) ? 0 : 1
  IF success THEN NCDF_CLOSE, ncid
  
  RETURN, success
  
END