;-----------------------------------------------------------------
FUNCTION URL_CALLBACK, status, progress, data

   ; print the info msgs from the url object
   PRINT, status

   ; return 1 to continue, return 0 to cancel
   RETURN, 1
END

;-----------------------------------------------------------------
PRO url_docs_ftp_cmd

   ; Catch any errors generated by the IDLnetURL object
   CATCH, errorStatus
   IF (errorStatus NE 0) THEN BEGIN
      CATCH, /CANCEL

      ; Display the error msg in a dialog and at the IDL
      ; command line.
      r = DIALOG_MESSAGE(!ERROR_STATE.msg, TITLE='URL Error', $
         /ERROR)
      PRINT, !ERROR_STATE.msg

      ; Get the properties that tell us more about
      ; the error and display at the IDL command line.
      ourl->GetProperty, RESPONSE_CODE=rspCode, $
         RESPONSE_HEADER=rspHdr, RESPONSE_FILENAME=rspFn
      PRINT, 'rspCode = ', rspCode
      PRINT, 'rspHdr= ', rspHdr
      PRINT, 'rspFn= ', rspFn

      ; Destroy the url object and return.
      OBJ_DESTROY, ourl
      RETURN
   ENDIF


   ; Create a new url object
   ourl = OBJ_NEW('IDLnetUrl')

   ; Specify the callback function
   ourl->SetProperty, CALLBACK_FUNCTION ='URL_CALLBACK'

   ; Set verbose to 1 to see more details
   ourl->SetProperty, VERBOSE = 1

   ; Specify that we will do an ftp transaction
   ourl->SetProperty, URL_SCHEME = 'ftp'

   ; The ITT Visual Information Solutions FTP server
   ourl->SetProperty, URL_HOST = 'data.ittvis.com'

   ; Build an array of commands. The following sample command
   ; array changes to the /doc/examples dir (which is all
   ; that can be done with this method on a read-only server.
   ; The following command will always work:
   ; cmds = 'cwd /'

   cmds = ['cwd doc/examples']

   ; Specify the appropriate username and password. If the
   ; username is 'Anonymous', use a null string for the password.
   ourl->SetProperty, URL_USERNAME = 'Anonymous'
   ourl->SetProperty, URL_PASSWORD = ''

   ; Send the command array to the FTP server, saving the
   ; responses in an IDL variable.
   respHdr = ourl->FtpCommand(cmds)

   ; Display the responses.
   PRINT, 'response header for the ftp commands'
   PRINT, respHdr

   ; Destroy the url object
   OBJ_DESTROY, ourl

END