PRO LA_TRIDC_DOC
    ; Create a random tridiagonal array.
    n = 9
    seed = 12321
    AL = RANDOMN(seed, n-1)
    A  = RANDOMN(seed, n)
    AU = RANDOMN(seed, n-1)

    ; Construct tridiagonal array.
    Array = DIAG_MATRIX(AL, -1) + DIAG_MATRIX(A) + $
        DIAG_MATRIX(AU, 1)

    ; Compute the LU decomposition.
    LA_TRIDC, AL, A, AU, U2, Index

    ; Adjust from LAPACK back to IDL indexing.
    Index = Index - 1

    ; Create upper and lower arrays.
    Upper = DIAG_MATRIX(A) + $
        DIAG_MATRIX(AU, 1) + DIAG_MATRIX(U2, 2)
    Lower = DIAG_MATRIX(AL, -1) + IDENTITY(n)

    ; To conserve storage, LA_TRIDC keeps all lower diagonal
    ; elements in AL, regardless of row. The Index array
    ; tells which subdiagonals need to be shifted down.
    ; Loop starts at 1 since there aren't any subdiagonals
    ; to the left of the first diagonal element.
    FOR i = 1,n-2 DO BEGIN
        IF (Index[i] NE i) THEN $
            Lower[0:i-1,[i,i+1]] = Lower[0:i-1,[i+1,i]]
    ENDFOR

    ; Permute the row order.
    FOR i = n-2, 0, -1 DO BEGIN
        IF (Index[i] NE i) THEN $
            Lower[*,[i,i+1]] = Lower[*,[i+1,i]]
    ENDFOR

    ; Reconstruct the array and check the difference:
    Arecon = Lower ## Upper
    PRINT, 'LA_TRIDC error:', MAX(ABS(Arecon - Array))
END
