PRO ibeta_ex2_doc

; Define an array of parametric exponents.
parameterA = (DINDGEN(101)/100. + 1.D) # REPLICATE(1.D, 101)
parameterB = REPLICATE(1.D, 101) # (DINDGEN(101)/10. + 1.D)

; Define the upper limits of integration.
upperLimits = REPLICATE(0.1D, 101, 101)

; Compute the incomplete beta functions.
betaFunctions = IBETA(parameterA, parameterB, upperLimits)

; Compute the incomplete beta functions with a less
; accurate tolerance set.
laBetaFunctions = IBETA(parameterA, parameterB, $
   upperLimits, EPS = 3.0e-4)

; Compute relative error.
relativeError = 100.* $
   ABS((betaFunctions - laBetaFunctions)/betaFunctions)

; Display resulting relative error.
ISURFACE, relativeError, parameterA, parameterB, $
   TITLE = 'Relative Error', STYLE=1,$
   XTITLE = 'Parameter A', YTITLE = 'Parameter B', $
   ZTITLE = 'Percent Error (%)',$
   VIEW_TITLE='Compare IBETA with less accurate EPS', $
   VIEW_GRID=[2,1], DIMENSIONS=[1000,500]
   
; Compute the incomplete beta functions with a more
; accurate tolerance set.
maBetaFunctions = IBETA(parameterA, parameterB, $
   upperLimits, EPS = 3.0e-10)

; Compute relative error.
relativeError = 100.* $
   ABS((maBetaFunctions - betaFunctions)/maBetaFunctions)

; Display resulting relative error.
ISURFACE, relativeError, parameterA, parameterB, $
   TITLE = 'Relative Error', STYLE=1, $
   XTITLE = 'Parameter A', YTITLE = 'Parameter B', $
   ZTITLE = 'Percent Error (%)', $
   VIEW_TITLE='Compare IBETA with more accurate EPS', /VIEW_NEXT
   
ISETPROPERTY, 'text*', FONT_SIZE=36
ISETPROPERTY, 'axis*', FONT_SIZE=24

END
