;  $Id: //depot/idl/IDL_71/idldir/examples/doc/image/mriwarping_direct.pro#1 $

;  Copyright (c) 2005-2009, ITT Visual Information Solutions. All
;       rights reserved.
; 
PRO MRIWarping_Direct

; Select the MRI proton density scan file.
mriFile = FILEPATH('pdthorax124.jpg', $
   SUBDIRECTORY = ['examples', 'data'])

; Read in the MRI file, prepare the display,
; load the gray scale color table and display the image.
READ_JPEG, mriFile, mriImg
DEVICE, DECOMPOSED = 0, RETAIN = 2
LOADCT, 0
WINDOW, 0, XSIZE = 256, YSIZE = 256, $
   TITLE = 'MRI Proton Density Input Image'
TV, mriImg

; Select the CT bone scan file.
ctboneFile = FILEPATH('ctbone157.jpg', $
   SUBDIRECTORY = ['examples', 'data'])

; Read in the file and create another window.
READ_JPEG, ctboneFile, ctboneImg
WINDOW, 2, XSIZE = 483, YSIZE = 410, $
   TITLE = 'CT Bone Scan Reference Image'

; Display the image with a color table to highlight
; features.
LOADCT, 20
TV, ctboneImg

; Return to the gray scale palette
LOADCT, 0

; Designate the control points in the input image
; (mriImg) in window 0). In the example steps, these
; points were selected with the CURSOR function.
Xi = [21, 65, 104, 129, 161, 198, 235, 170, 107]
Yi = [25, 131, 207, 229, 211, 121, 16, 134, 140]

; Designate the corresponding control points in the
; reference image (ctboneImg in window 2). In the
; example steps, these points were selected with the
; CURSOR function.
Xo = [34, 121, 183, 243, 303, 377, 454, 319, 198]
Yo = [10, 207, 357, 400, 363, 206, 12, 222, 233]

; Using the control points, warp the input image
; (mriImg) onto the reference image (ctboneImg).
warpTriImg = WARP_TRI(Xo, Yo, Xi, Yi, mriImg, $
   OUTPUT_SIZE = [483, 410], /EXTRAPOLATE)
;Display new image.
WINDOW, 3, XSIZE = 483, YSIZE = 410, $
   TITLE = 'WARP_TRI image'
TV, warpTriImg

; Use POLYWARP to create the variables (p,q) needed by
; POLY_2D.
POLYWARP, Xi, Yi, Xo, Yo, 1, p, q

; Using the values generated by POLYWARP, warp the
; original image. Specify 1 for  bilinear interpolation
; and set the output size equal to the ctboneImg image
; dimensions.
warpPolyImg = POLY_2D(mriImg, p, q, 1, 483, 410)

; Create a window and display the image.
WINDOW, 4, XSIZE = 483, YSIZE = 410, $
   TITLE = 'Poly_2D image'
TV, warpPolyImg

; Mask out the lower pixel values in the ctboneImg
; image.
ctboneMask = BYTSCL((ctboneImg GT 55) * ctboneImg)

; Display an image using the full intensity of the bone
; scan image and a 75% intensity of the warped image.
blendImg = BYTSCL(ctboneMask + 0.75 * warpPolyImg)

; Display the blended image.
WINDOW, 5, XSIZE = 483, YSIZE = 410, $
   TITLE = 'Blended Image'
TV, blendImg

END