// These scripts are used by the "Topic Not Found" page
//
// Find the frames we need
var nframe = top.frames["HelpFrame"].frames["NavFrame"];
var sframe = top.frames["SearchFrame"];
var vframe = nframe.frames["ViewsFrame"];
var tframe = nframe.frames["TabsFrame"];
var ivframe = vframe.frames["index"].frames["indexViewFrame"];
var svframe = vframe.frames["search"].frames["searchViewFrame"];

// Use the "Not Found" term to populate the Index tab.
// This function is called when the "Topic Not Found" page loads.
function findInIndex() {

   // Get the search term (The queryString function comes from doIDL.js)
   var term = queryString("notfound");

   // Switch to the index tab
   tframe.showTab('index');

   // Show the index frame
   vframe.showView('index');

   // Populate the search box and display
   ivframe.typein.value = term;
}


// Use the "Not Found" term to populate the Search tab.
// This one is optional, since the Search results are
// not as well targeted as the Index results.
function findInFTS() {

   // Get the search term (The queryString function comes from doIDL.js)
   var term = queryString("notfound");

   // Build a query URL
   var hsURL = location.protocol+"//"+location.host;
   var queryURL = hsURL+"/help/advanced/searchView.jsp?searchWord=";
   var workingSet = sframe.document.getElementById("scope").firstChild.nodeValue;
   var maxHits = sframe.document.forms["searchForm"].maxHits.value;
   var query = encodeURIComponent(term)+"&maxHits="+maxHits;
   if (workingSet != 'All\u0020topics')
      query = query +"&scope="+encodeURIComponent(workingSet);

   // Switch to the search tab
   tframe.showTab('search');

   // Show the search frame
   vframe.showView('search');

   // Populate the search field 
   sframe.document.forms["searchForm"].searchWord.value = term;

   // Send the query URL
   svframe.location.replace(queryURL+query);
}

// Even on relatively fast Linux and Solaris machines,
// it seems to take a while for the index view to be
// ready to accept input. To improve the chances of
// the index view loading correctly the first time, we
// set a timeout in the <body onload=> tag and use this
// function to guess at how long to wait.
function awhile() {
   var wait=10;
   if (navigator.userAgent.indexOf('Linux') != -1) { wait=1000; }
   if (navigator.userAgent.indexOf('Solaris') != -1) { wait=1000; }
   return wait;
}


