// Javascript has no wait() function, so we construct one by
// comparing dates.
//
function wait(pause) {
   var d = new Date();
   var t = orig_t = d.getTime();
   // Check to see if 'pause' milliseconds have passed.
   while ( t < orig_t+pause ) {
      d = new Date()
      t = d.getTime()
   }
}

// Function to execute IDL code wrapped in a call to this function.
// If the findHelpTop method is not available (it comes from 
// org.eclipse.help/livehelp.js), then the code will not execute,
// so display an explanatory dialog.
//
function doIDL(arg) {
   //alert(arg);
   if (self.findHelpTop) {
      s = new String(arg);
      // Percent must be escaped for BOTH Eclipse and IDL macros
      s = s.replace(/%/g,"%%%%");
      // Commas must be escaped for Eclipse
      s = s.replace(/\,/g,"%,");
      // Open parens must be escaped for Eclipse
      s = s.replace(/\(/g,"%\(");
      // Reconvert HTML entity to single quote
      s = s.replace(/&#39\;/g,"\'");
      // Convert hard spaces to regular spaces
      s = s.replace(/[\xa0]/g," ");
      // Convert two or more whitespace chars to a single space
      s = s.replace(/\ \ +/g, " ");
      // Merge continued lines into a single statement.
      s = s.replace(/\$\s*/g,"");
      // Handle things that need to be compiled. Note that the
      // PRO or FUNCT must either be the first statement in the
      // block or follow a newline.
      //
      s = s.replace(/\n(end)\s*\b/ig, "\n$1\n");
      s = s.replace(/\n(func)/ig, "\n.RUN\n$1");
      s = s.replace(/\n(pro)/ig, "\n.RUN\n$1");
      s = s.replace(/^(func)/i, ".RUN\n$1");
      s = s.replace(/^(pro)/i, ".RUN\n$1");
      s = s.replace(/(.run)\n.RUN/ig, "$1");
      //alert(s);

      var commstring =
         "com.rsi.idldt.ui.commands.ExecuteIDLCommand(com.rsi.idldt.ui.commands.ExecuteIDLCommand.command="+s+")";
      
      //alert(commstring);
      // Execute the string we built up above.
      executeCommand(commstring);
         
   } else {
      var msg='This link will only execute code when help\r\n'+
              'is launched from within the IDL Workbench.';
      alert(msg);
   }
}

// Function to execute Eclispe code wrapped in a call to this function.
// If the findHelpTop method is not available (it comes from 
// org.eclipse.help/livehelp.js), then the code will not execute,
// so display an explanatory dialog.
//
function doEclipse(arg) {
   //alert(arg);
   if (self.findHelpTop) {
      executeCommand(arg);
   } else {
      var msg='This link will function correctly when help\r\n'+
              'is launched from within the IDL Workbench.';
      alert(msg);
   }
}

function commentMail(page, plugin, version) {
   document.write('<a href="mailto:idldocs@ittvis.com?subject='
      + 'Comment on documentation page ' + page
      + '&body=Hello,%0D%0D'
      + 'I have a comment on this documentation topic:%0D%0D'
      + '  Topic: ' + page + '%0D'
      + '  Help plugin: ' + plugin + '%0D'
      + '  Product version: ' + version +'%0D%0D'
      + '">Send us a comment on this topic</a>');
}

function prevNext(prev, page, next) {
   document.write('<a href="'+prev+'" alt="Previous page" title="Previous page"><img src="images/pageprev.png" border="0" /></a>&#160;<a href="'+page+'" alt="Top of this page" title="Top of this page"><img src="images/pagetop.png" border="0" /></a>&#160;<a href="'+next+'" alt="Next page" title="Next page"><img src="images/pagenext.png" border="0" /></a>');
}

function PageQuery(q) {
  if(q.length > 1) this.q = q.substring(1, q.length);
  else this.q = null;
  this.keyValuePairs = new Array();
  if(q) {
    for(var i=0; i < this.q.split("&").length; i++) {
      this.keyValuePairs[i] = this.q.split("&")[i];
    }
  }
  this.getKeyValuePairs = function() { return this.keyValuePairs; }
  this.getValue = function(s) {
    for(var j=0; j < this.keyValuePairs.length; j++) {
      if(this.keyValuePairs[j].split("=")[0] == s)
        return this.keyValuePairs[j].split("=")[1];
    }
    return false;
  }
  this.getParameters = function() {
    var a = new Array(this.getLength());
    for(var j=0; j < this.keyValuePairs.length; j++) {
      a[j] = this.keyValuePairs[j].split("=")[0];
    }
    return a;
  }
  this.getLength = function() { return this.keyValuePairs.length; }
}
function queryString(key){
  var page = new PageQuery(window.location.search);
  return unescape(page.getValue(key));
}
function displayItem(key){
  if(queryString(key)=='false')
  {
    document.write("you didn't enter a ?name=value querystring item.");
  }else{
    document.write(queryString(key));
  }
}

/* Function to expand and collapse a block of text */
function display (what) {
	var whatisit = document.getElementById(what);
	if (whatisit.className=="blockshow") {
		whatisit.className="blockhide";
      document.getElementById(what+'_link').className="closed";
      document.getElementById(what+'_text').className="hide";
	} else {
		whatisit.className="blockshow";
      document.getElementById(what+'_link').className="open";
      document.getElementById(what+'_text').className="show";
   }
}

