/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import org.eclipse.help.IHelpResource;
import org.eclipse.help.ui.internal.HelpUIResources;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.views.IHelpPart;
import org.eclipse.help.ui.internal.views.ReusableHelpPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class HyperlinkTreePart
extends AbstractFormPart
implements IHelpPart {
    protected ReusableHelpPart parent;
    private String id;
    protected TreeViewer treeViewer;
    private TreeItem lastItem;
    private Cursor handCursor;

    public HyperlinkTreePart(Composite parent, final FormToolkit toolkit, IToolBarManager tbm) {
        this.handCursor = new Cursor((Device)parent.getDisplay(), 21);
        this.treeViewer = new TreeViewer(parent, 768);
        this.treeViewer.getTree().setMenu(parent.getMenu());
        this.treeViewer.getTree().setForeground(toolkit.getHyperlinkGroup().getForeground());
        this.configureTreeViewer();
        this.treeViewer.setInput((Object)this);
        this.treeViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.treeViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                HyperlinkTreePart.this.doOpenSelection((IStructuredSelection)event.getSelection());
            }
        });
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                HyperlinkTreePart.this.handleSelectionChanged((IStructuredSelection)event.getSelection());
            }
        });
        this.treeViewer.getTree().addMouseListener((MouseListener)new MouseAdapter(){
            long lastTime;

            public void mouseUp(MouseEvent e) {
                Object obj;
                long eventTime = (long)e.time & 0xFFFFFFFFL;
                if (eventTime - this.lastTime <= (long)e.display.getDoubleClickTime()) {
                    return;
                }
                if (e.button != 1) {
                    return;
                }
                this.lastTime = eventTime;
                Point p = new Point(e.x, e.y);
                TreeItem item = HyperlinkTreePart.this.treeViewer.getTree().getItem(p);
                if (item != null && (obj = item.getData()) != null) {
                    HyperlinkTreePart.this.doOpen(obj);
                }
            }
        });
        this.treeViewer.getTree().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                HyperlinkTreePart.this.validateLastItem();
                if (HyperlinkTreePart.this.lastItem == null) {
                    return;
                }
                Rectangle bounds = HyperlinkTreePart.this.lastItem.getBounds();
                boolean selected = false;
                TreeItem[] items = HyperlinkTreePart.this.lastItem.getParent().getSelection();
                int i = 0;
                while (i < items.length) {
                    if (items[i].equals(HyperlinkTreePart.this.lastItem)) {
                        selected = true;
                        break;
                    }
                    ++i;
                }
                if (selected) {
                    e.gc.setForeground(e.display.getSystemColor(27));
                } else {
                    e.gc.setForeground(toolkit.getHyperlinkGroup().getActiveForeground());
                }
                FontMetrics fm = e.gc.getFontMetrics();
                int height = fm.getHeight();
                int lineY = bounds.y + height;
                e.gc.drawLine(bounds.x, lineY, bounds.x + bounds.width - 1, lineY);
            }
        });
        this.treeViewer.getTree().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                HyperlinkTreePart.this.validateLastItem();
                if (HyperlinkTreePart.this.lastItem != null) {
                    TreeItem item = HyperlinkTreePart.this.lastItem;
                    HyperlinkTreePart.this.lastItem = null;
                    item.setForeground(null);
                }
            }
        });
        this.treeViewer.getTree().addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                Point p = new Point(e.x, e.y);
                TreeItem item = HyperlinkTreePart.this.treeViewer.getTree().getItem(p);
                HyperlinkTreePart.this.validateLastItem();
                if (item != null) {
                    if (HyperlinkTreePart.this.lastItem != null) {
                        if (!HyperlinkTreePart.this.lastItem.equals(item)) {
                            HyperlinkTreePart.this.lastItem.setForeground(null);
                            HyperlinkTreePart.this.repaintItem(HyperlinkTreePart.this.lastItem);
                            HyperlinkTreePart.this.updateStatus(null);
                            HyperlinkTreePart.this.lastItem = null;
                        } else {
                            return;
                        }
                    }
                    Object obj = item.getData();
                    HyperlinkTreePart.this.treeViewer.getTree().setCursor(HyperlinkTreePart.this.handCursor);
                    IStructuredSelection ssel = (IStructuredSelection)HyperlinkTreePart.this.treeViewer.getSelection();
                    if (ssel.getFirstElement() == obj) {
                        item.setForeground(e.display.getSystemColor(27));
                    } else {
                        item.setForeground(toolkit.getHyperlinkGroup().getActiveForeground());
                    }
                    HyperlinkTreePart.this.lastItem = item;
                    HyperlinkTreePart.this.repaintItem(HyperlinkTreePart.this.lastItem);
                    if (obj instanceof IHelpResource) {
                        HyperlinkTreePart.this.updateStatus((IHelpResource)obj);
                    } else {
                        HyperlinkTreePart.this.updateStatus(null);
                    }
                    return;
                }
                if (HyperlinkTreePart.this.lastItem != null) {
                    HyperlinkTreePart.this.lastItem.setForeground(null);
                    HyperlinkTreePart.this.repaintItem(HyperlinkTreePart.this.lastItem);
                    HyperlinkTreePart.this.lastItem = null;
                    HyperlinkTreePart.this.updateStatus(null);
                }
                HyperlinkTreePart.this.treeViewer.getTree().setCursor(null);
            }
        });
        this.contributeToToolBar(tbm);
    }

    public void dispose() {
        this.handCursor.dispose();
        super.dispose();
    }

    private void repaintItem(TreeItem item) {
        Rectangle bounds = item.getBounds();
        item.getParent().redraw(bounds.x, bounds.y, bounds.width, bounds.height, false);
    }

    protected void contributeToToolBar(IToolBarManager tbm) {
        Action collapseAllAction = new Action(){

            public void run() {
                BusyIndicator.showWhile((Display)HyperlinkTreePart.this.getControl().getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        HyperlinkTreePart.this.doCollapseAll();
                    }
                });
            }
        };
        collapseAllAction.setImageDescriptor(HelpUIResources.getImageDescriptor("elcl16/collapseall.gif"));
        collapseAllAction.setToolTipText(Messages.AllTopicsPart_collapseAll_tooltip);
        tbm.insertBefore("back", (IAction)collapseAllAction);
        tbm.insertBefore("back", (IContributionItem)new Separator());
    }

    private void doCollapseAll() {
        Object[] expanded = this.treeViewer.getExpandedElements();
        this.treeViewer.collapseAll();
        this.treeViewer.update(expanded, null);
    }

    public Control getControl() {
        return this.treeViewer.getControl();
    }

    public void init(ReusableHelpPart parent, String id, IMemento memento) {
        this.parent = parent;
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setVisible(boolean visible) {
        this.getControl().setVisible(visible);
        if (visible) {
            this.treeViewer.refresh();
        }
    }

    private void doOpenSelection(IStructuredSelection sel) {
        Object obj = sel.getFirstElement();
        if (obj != null) {
            this.doOpen(obj);
        }
    }

    protected void handleSelectionChanged(IStructuredSelection sel) {
        Object obj = sel.getFirstElement();
        if (this.lastItem != null && !this.lastItem.isDisposed()) {
            Object lastObj = this.lastItem.getData();
            if (lastObj == obj) {
                this.lastItem.setForeground(this.getControl().getDisplay().getSystemColor(27));
            } else {
                this.lastItem.setForeground(this.parent.getForm().getToolkit().getHyperlinkGroup().getActiveForeground());
            }
            this.repaintItem(this.lastItem);
        }
        if (obj instanceof IHelpResource) {
            IHelpResource res = (IHelpResource)obj;
            this.updateStatus(res, false);
        } else {
            this.updateStatus(null, false);
        }
    }

    private void updateStatus(IHelpResource res) {
        this.updateStatus(res, true);
    }

    private void updateStatus(IHelpResource res, boolean defaultToSelection) {
        IStructuredSelection ssel;
        Object obj;
        if (defaultToSelection && res == null && (obj = (ssel = (IStructuredSelection)this.treeViewer.getSelection()).getFirstElement()) instanceof IHelpResource) {
            res = (IHelpResource)obj;
        }
        if (res != null) {
            String label = res.getLabel();
            String href = this.getHref(res);
            this.parent.handleLinkEntered(new HyperlinkEvent((Widget)this.treeViewer.getTree(), (Object)href, label, 0));
        } else {
            this.parent.handleLinkExited(null);
        }
    }

    protected String getHref(IHelpResource res) {
        return res.getHref();
    }

    protected abstract void configureTreeViewer();

    protected abstract void doOpen(Object var1);

    protected void postUpdate(final Object obj) {
        this.treeViewer.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                HyperlinkTreePart.this.treeViewer.update(obj, null);
            }
        });
    }

    public boolean fillContextMenu(IMenuManager manager) {
        return this.parent.fillSelectionProviderMenu((ISelectionProvider)this.treeViewer, manager, this.canAddBookmarks());
    }

    protected abstract boolean canAddBookmarks();

    public boolean hasFocusControl(Control focusControl) {
        return this.treeViewer.getControl().equals(focusControl);
    }

    public void setFocus() {
        if (this.treeViewer != null) {
            this.treeViewer.getTree().setFocus();
        }
    }

    public IAction getGlobalAction(String id) {
        if (id.equals(ActionFactory.COPY.getId())) {
            return this.parent.getCopyAction();
        }
        return null;
    }

    public void stop() {
    }

    private void validateLastItem() {
        if (this.lastItem != null && this.lastItem.isDisposed()) {
            this.lastItem = null;
        }
    }
}

