/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.views.ReusableHelpPart;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;

public class HelpView
extends ViewPart
implements IPartListener2,
ISelectionChangedListener,
IPageChangedListener {
    private FormToolkit toolkit;
    private String firstPageId;
    private ReusableHelpPart reusableHelpPart;
    private IWorkbenchPart monitoredPart;
    private boolean visible;

    public void createPartControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.toolkit.getHyperlinkGroup().setHyperlinkUnderlineMode(2);
        this.toolkit.getColors().initializeSectionToolBarColors();
        this.reusableHelpPart.createControl(parent, this.toolkit);
        this.reusableHelpPart.setDefaultContextHelpText(Messages.HelpView_defaultText);
        this.reusableHelpPart.showPage(this.getFirstPage());
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        IWorkbenchPartReference aref = page.getActivePartReference();
        if (aref != null) {
            this.handlePartActivation(aref);
        }
    }

    public void dispose() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IPartService service = window.getPartService();
        if (this.monitoredPart != null) {
            this.uninstallSelectionListener(this.monitoredPart);
            this.uninstallPageListener(this.monitoredPart);
        }
        service.removePartListener((IPartListener2)this);
        if (this.reusableHelpPart != null) {
            this.reusableHelpPart.dispose();
            this.reusableHelpPart = null;
        }
        if (this.toolkit != null) {
            this.toolkit.dispose();
            this.toolkit = null;
        }
        super.dispose();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        if (memento != null) {
            this.firstPageId = memento.getString("pageId");
        }
        this.init(site);
        this.reusableHelpPart = new ReusableHelpPart((IRunnableContext)site.getWorkbenchWindow(), this.getHelpPartStyle());
        IActionBars actionBars = site.getActionBars();
        this.reusableHelpPart.init(actionBars, actionBars.getToolBarManager(), actionBars.getStatusLineManager(), memento);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IPartService service = window.getPartService();
        service.addPartListener((IPartListener2)this);
    }

    public void saveState(IMemento memento) {
        if (this.reusableHelpPart != null && memento != null) {
            String pageId = this.reusableHelpPart.getCurrentPageId();
            if (pageId != null) {
                memento.putString("pageId", pageId);
            }
            this.reusableHelpPart.saveState(memento);
        }
    }

    private void handlePartActivation(IWorkbenchPartReference ref) {
        if (this.reusableHelpPart == null) {
            return;
        }
        if (!this.visible || !this.reusableHelpPart.isMonitoringContextHelp()) {
            return;
        }
        if (this.isThisPart(ref)) {
            return;
        }
        IWorkbenchPart part = ref.getPart(false);
        Display display = part.getSite().getShell().getDisplay();
        Control c = display.getFocusControl();
        if (c != null && c.isVisible() && !c.isDisposed()) {
            IContextProvider provider = (IContextProvider)part.getAdapter(IContextProvider.class);
            if (provider != null) {
                this.reusableHelpPart.update(provider, null, part, c, false);
                if ((provider.getContextChangeMask() & 1) != 0) {
                    this.installSelectionListener(part);
                }
            } else {
                this.reusableHelpPart.update(part, c);
            }
            if (part instanceof IPageChangeProvider) {
                this.installPageListener(part);
            }
        }
    }

    private void installPageListener(IWorkbenchPart part) {
        if (part instanceof IPageChangeProvider) {
            ((IPageChangeProvider)part).addPageChangedListener((IPageChangedListener)this);
        }
        this.monitoredPart = part;
    }

    private void uninstallPageListener(IWorkbenchPart part) {
        if (part instanceof IPageChangeProvider) {
            ((IPageChangeProvider)part).removePageChangedListener((IPageChangedListener)this);
        }
        this.monitoredPart = null;
    }

    private void installSelectionListener(IWorkbenchPart part) {
        ISelectionProvider provider = part.getSite().getSelectionProvider();
        if (provider instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)provider).addPostSelectionChangedListener((ISelectionChangedListener)this);
        } else {
            provider.addSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.monitoredPart = part;
    }

    private void uninstallSelectionListener(IWorkbenchPart part) {
        ISelectionProvider provider = part.getSite().getSelectionProvider();
        if (provider instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)provider).removePostSelectionChangedListener((ISelectionChangedListener)this);
        } else if (provider != null) {
            provider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.monitoredPart = null;
    }

    private boolean isThisPart(IWorkbenchPartReference ref) {
        IWorkbenchPart part = ref.getPart(false);
        return part != null && part.equals((Object)this);
    }

    private void updateActivePart() {
        if (this.reusableHelpPart == null) {
            return;
        }
        if (!this.reusableHelpPart.isMonitoringContextHelp()) {
            return;
        }
        if (this.monitoredPart == null) {
            return;
        }
        Control c = this.monitoredPart.getSite().getShell().getDisplay().getFocusControl();
        if (c != null && !c.isDisposed() && this.visible) {
            IContextProvider provider = (IContextProvider)this.monitoredPart.getAdapter(IContextProvider.class);
            if (provider != null) {
                this.reusableHelpPart.update(provider, null, this.monitoredPart, c, false);
            } else {
                this.reusableHelpPart.update(this.monitoredPart, c);
            }
        }
    }

    private void handlePartDeactivation(IWorkbenchPartReference ref) {
        IWorkbenchPart part = ref.getPart(false);
        if (this.monitoredPart != null && part != null && part.equals(this.monitoredPart)) {
            this.uninstallSelectionListener(part);
            this.uninstallPageListener(part);
        }
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        if (this.isThisPart(partRef)) {
            this.visible = true;
            this.hook(true);
            this.selectionChanged(null);
        } else {
            this.handlePartActivation(partRef);
        }
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
        if (this.isThisPart(partRef)) {
            this.visible = true;
            this.hook(true);
            this.selectionChanged(null);
        }
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        this.handlePartDeactivation(partRef);
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
        this.handlePartDeactivation(partRef);
    }

    public void partHidden(IWorkbenchPartReference partRef) {
        if (this.isThisPart(partRef)) {
            this.visible = false;
            this.hook(false);
        }
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
        if (this.isThisPart(partRef)) {
            this.visible = true;
            this.hook(true);
            this.selectionChanged(null);
        }
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        if (this.isThisPart(partRef)) {
            this.visible = true;
            this.hook(true);
            this.selectionChanged(null);
        }
    }

    private void hook(boolean doHook) {
        if (doHook) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IPartService service = window.getPartService();
            IWorkbenchPartReference aref = service.getActivePartReference();
            if (aref != null) {
                this.handlePartActivation(aref);
            }
        } else if (this.monitoredPart != null) {
            this.uninstallSelectionListener(this.monitoredPart);
            this.uninstallPageListener(this.monitoredPart);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!this.visible) {
            return;
        }
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                HelpView.this.updateActivePart();
            }
        });
    }

    protected String getFirstPage() {
        if (this.firstPageId != null) {
            return this.firstPageId;
        }
        return "context-help-page";
    }

    public void displayContext(IContext context, IWorkbenchPart part, Control control) {
        if (this.reusableHelpPart != null) {
            IHelpResource[] topics = context.getRelatedTopics();
            if (context.getText() != null || topics.length != 1) {
                this.reusableHelpPart.showPage("context-help-page");
                IContextProvider provider = null;
                if (part != null) {
                    provider = (IContextProvider)part.getAdapter(IContextProvider.class);
                }
                this.reusableHelpPart.update(provider, context, part, control, true);
            } else {
                this.reusableHelpPart.showURL(topics[0].getHref());
            }
        }
    }

    protected int getHelpPartStyle() {
        return ReusableHelpPart.getDefaultStyle();
    }

    public void setFocus() {
        if (this.reusableHelpPart != null) {
            this.reusableHelpPart.setFocus();
        }
    }

    public void startSearch(String phrase) {
        if (this.reusableHelpPart != null) {
            this.reusableHelpPart.startSearch(phrase);
        }
    }

    public void showIndex() {
        if (this.reusableHelpPart != null) {
            this.reusableHelpPart.showPage("index-page", true);
        }
    }

    public void showHelp(String href) {
        if (this.reusableHelpPart != null) {
            this.reusableHelpPart.showURL(href);
        }
    }

    public void showDynamicHelp(IWorkbenchPart part, Control c) {
        if (this.reusableHelpPart != null) {
            this.reusableHelpPart.showDynamicHelp(part, c);
        }
    }

    public void pageChanged(PageChangedEvent event) {
        if (!this.visible) {
            return;
        }
        this.updateActivePart();
    }
}

