/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.util;

public class EscapeUtils {
    public static String escapeSpecialChars(String value) {
        return EscapeUtils.escapeSpecialChars(value, false);
    }

    public static String escapeSpecialCharsLeavinggBold(String value) {
        return EscapeUtils.escapeSpecialChars(value, true);
    }

    public static String escapeAmpersand(String value) {
        return value.replaceAll("&", "&amp;");
    }

    public static String stripSingleAmpersand(String value) {
        StringBuffer buf = new StringBuffer();
        boolean unmatchedAmpersand = false;
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (c == '&') {
                if (unmatchedAmpersand) {
                    buf.append("&&");
                    unmatchedAmpersand = false;
                } else {
                    unmatchedAmpersand = true;
                }
            } else {
                unmatchedAmpersand = false;
                buf.append(c);
            }
            ++i;
        }
        return buf.toString();
    }

    private static String escapeSpecialChars(String value, boolean leaveBold) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            switch (c) {
                case '&': {
                    buf.append("&amp;");
                    break;
                }
                case '<': {
                    if (leaveBold) {
                        String tag;
                        int length = value.length();
                        if (i + 6 < length && (tag = value.substring(i, i + 7)).equalsIgnoreCase("</code>")) {
                            buf.append("</span>");
                            i += 6;
                            break;
                        }
                        if (i + 5 < length && (tag = value.substring(i, i + 6)).equalsIgnoreCase("<code>")) {
                            buf.append("<span font=\"code\">");
                            i += 5;
                            break;
                        }
                        if (i + 3 < length) {
                            tag = value.substring(i, i + 4);
                            if (tag.equalsIgnoreCase("</b>")) {
                                buf.append(tag);
                                i += 3;
                                break;
                            }
                            if (tag.equalsIgnoreCase("<br>")) {
                                buf.append("<br/>");
                                i += 3;
                                break;
                            }
                        }
                        if (i + 2 < length && (tag = value.substring(i, i + 3)).equalsIgnoreCase("<b>")) {
                            buf.append(tag);
                            i += 2;
                            break;
                        }
                    }
                    buf.append("&lt;");
                    break;
                }
                case '>': {
                    buf.append("&gt;");
                    break;
                }
                case '\'': {
                    buf.append("&apos;");
                    break;
                }
                case '\"': {
                    buf.append("&quot;");
                    break;
                }
                case '\u00a0': {
                    buf.append(" ");
                    break;
                }
                case '\t': {
                    buf.append(' ');
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }
}

