/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.workingset.AdaptableHelpResource;
import org.eclipse.help.internal.workingset.WorkingSet;
import org.eclipse.help.ui.IEngineDescriptor;
import org.eclipse.help.ui.RootScopePage;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.search.HelpWorkingSetElementLabelProvider;
import org.eclipse.help.ui.internal.search.HelpWorkingSetTreeContentProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public class LocalHelpPage
extends RootScopePage {
    private Button searchAll;
    private Button searchSelected;
    private CheckboxTreeViewer tree;
    private ITreeContentProvider treeContentProvider;
    private ILabelProvider elementLabelProvider;
    private WorkingSet workingSet;
    private Button capabilityFiltering;

    public void init(IEngineDescriptor ed, String scopeSetName) {
        super.init(ed, scopeSetName);
        if (scopeSetName != null) {
            this.workingSet = BaseHelpSystem.getWorkingSetManager().getWorkingSet(scopeSetName);
        }
    }

    protected int createScopeContents(Composite parent) {
        Font font = parent.getFont();
        this.initializeDialogUnits((Control)parent);
        this.searchAll = new Button(parent, 16);
        this.searchAll.setText(Messages.selectAll);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.searchAll.setLayoutData((Object)gd);
        this.searchAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocalHelpPage.this.tree.getTree().setEnabled(false);
            }
        });
        this.searchSelected = new Button(parent, 16);
        this.searchSelected.setText(Messages.selectWorkingSet);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.searchSelected.setLayoutData((Object)gd);
        this.searchSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocalHelpPage.this.tree.getTree().setEnabled(true);
            }
        });
        if (this.workingSet == null) {
            this.searchAll.setSelection(true);
        } else {
            this.searchSelected.setSelection(true);
        }
        Label label = new Label(parent, 64);
        label.setFont(font);
        label.setText(Messages.WorkingSetContent);
        gd = new GridData(772);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.tree = new CheckboxTreeViewer(parent, 2816);
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(15);
        gd.horizontalSpan = 2;
        this.tree.getControl().setLayoutData((Object)gd);
        this.tree.getControl().setFont(font);
        this.treeContentProvider = new HelpWorkingSetTreeContentProvider();
        this.tree.setContentProvider((IContentProvider)this.treeContentProvider);
        this.elementLabelProvider = new HelpWorkingSetElementLabelProvider();
        this.tree.setLabelProvider((IBaseLabelProvider)this.elementLabelProvider);
        this.tree.setUseHashlookup(true);
        this.tree.setInput((Object)BaseHelpSystem.getWorkingSetManager().getRoot());
        this.tree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                LocalHelpPage.this.handleCheckStateChange(event);
            }
        });
        this.tree.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                final Object element = event.getElement();
                if (!LocalHelpPage.this.tree.getGrayed(element)) {
                    BusyIndicator.showWhile((Display)LocalHelpPage.this.getShell().getDisplay(), (Runnable)new Runnable(){

                        public void run() {
                            LocalHelpPage.this.setSubtreeChecked(element, LocalHelpPage.this.tree.getChecked(element), false);
                        }
                    });
                }
            }
        });
        this.tree.getTree().setEnabled(this.workingSet != null);
        this.capabilityFiltering = new Button(parent, 32);
        String checkboxLabel = HelpBasePlugin.getActivitySupport().getLocalScopeCheckboxLabel();
        if (checkboxLabel == null) {
            checkboxLabel = Messages.LocalHelpPage_capabilityFiltering_name;
        }
        this.capabilityFiltering.setText(checkboxLabel);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.capabilityFiltering.setLayoutData((Object)gd);
        this.initializeCheckedState();
        this.applyDialogFont(parent);
        return 1;
    }

    private void initializeCheckedState() {
        IPreferenceStore store = this.getPreferenceStore();
        this.capabilityFiltering.setSelection(store.getBoolean(String.valueOf(this.getEngineDescriptor().getId()) + "." + "capabilityFiltering"));
        if (this.workingSet == null) {
            return;
        }
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                Object[] elements = LocalHelpPage.this.workingSet.getElements();
                LocalHelpPage.this.tree.setCheckedElements(elements);
                int i = 0;
                while (i < elements.length) {
                    Object element = elements[i];
                    if (LocalHelpPage.this.isExpandable(element)) {
                        LocalHelpPage.this.setSubtreeChecked(element, true, true);
                    }
                    LocalHelpPage.this.updateParentState(element, true);
                    ++i;
                }
            }
        });
    }

    boolean isExpandable(Object element) {
        return this.treeContentProvider.hasChildren(element);
    }

    void updateParentState(Object child, boolean baseChildState) {
        if (child == null) {
            return;
        }
        Object parent = this.treeContentProvider.getParent(child);
        if (parent == null) {
            return;
        }
        boolean allSameState = true;
        Object[] children = null;
        children = this.treeContentProvider.getChildren(parent);
        int i = children.length - 1;
        while (i >= 0) {
            if (this.tree.getChecked(children[i]) != baseChildState || this.tree.getGrayed(children[i])) {
                allSameState = false;
                break;
            }
            --i;
        }
        this.tree.setGrayed(parent, !allSameState);
        this.tree.setChecked(parent, !allSameState || baseChildState);
        this.updateParentState(parent, baseChildState);
    }

    void setSubtreeChecked(Object parent, boolean state, boolean checkExpandedState) {
        Object[] children = this.treeContentProvider.getChildren(parent);
        int i = children.length - 1;
        while (i >= 0) {
            Object element = children[i];
            if (state) {
                this.tree.setChecked(element, true);
                this.tree.setGrayed(element, false);
            } else {
                this.tree.setGrayChecked(element, false);
            }
            if (this.isExpandable(element)) {
                this.setSubtreeChecked(element, state, checkExpandedState);
            }
            --i;
        }
    }

    private void findCheckedElements(List checkedResources, Object parent) {
        Object[] children = this.treeContentProvider.getChildren(parent);
        int i = 0;
        while (i < children.length) {
            if (this.tree.getGrayed(children[i])) {
                this.findCheckedElements(checkedResources, children[i]);
            } else if (this.tree.getChecked(children[i])) {
                checkedResources.add(children[i]);
            }
            ++i;
        }
    }

    void handleCheckStateChange(final CheckStateChangedEvent event) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                Object element = event.getElement();
                boolean state = event.getChecked();
                LocalHelpPage.this.tree.setGrayed(element, false);
                if (LocalHelpPage.this.isExpandable(element)) {
                    LocalHelpPage.this.setSubtreeChecked(element, state, state);
                }
                LocalHelpPage.this.updateParentState(element, state);
            }
        });
    }

    public WorkingSet getWorkingSet() {
        ArrayList elements = new ArrayList(10);
        this.findCheckedElements(elements, this.tree.getInput());
        if (this.workingSet == null) {
            this.workingSet = new WorkingSet(this.getScopeSetName(), elements.toArray(new AdaptableHelpResource[elements.size()]));
        } else {
            this.workingSet.setName(this.getScopeSetName());
            this.workingSet.setElements(elements.toArray(new AdaptableHelpResource[elements.size()]));
        }
        return this.workingSet;
    }

    public boolean performOk() {
        if (this.searchSelected.getSelection()) {
            BaseHelpSystem.getWorkingSetManager().addWorkingSet(this.getWorkingSet());
        } else {
            BaseHelpSystem.getWorkingSetManager().removeWorkingSet(this.getWorkingSet());
        }
        this.getPreferenceStore().setValue(this.getKey("workingSet"), this.getScopeSetName());
        this.getPreferenceStore().setValue(this.getKey("capabilityFiltering"), this.capabilityFiltering.getSelection());
        return super.performOk();
    }

    private String getKey(String key) {
        return String.valueOf(this.getEngineDescriptor().getId()) + "." + key;
    }
}

