/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.IOException;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.help.IToc;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.util.URLCoder;
import org.eclipse.help.internal.webapp.HelpWebappPlugin;
import org.eclipse.help.internal.webapp.servlet.CookieUtil;
import org.eclipse.help.internal.workingset.AdaptableHelpResource;
import org.eclipse.help.internal.workingset.AdaptableToc;
import org.eclipse.help.internal.workingset.AdaptableTocsArray;
import org.eclipse.help.internal.workingset.AdaptableTopic;
import org.eclipse.help.internal.workingset.IHelpWorkingSetManager;
import org.eclipse.help.internal.workingset.WorkingSet;
import org.eclipse.help.internal.workingset.WorkingSetComparator;

public class InfocenterWorkingSetManager
implements IHelpWorkingSetManager {
    private static final String COOKIE_NAME = "wset";
    private static final int MAX_COOKIES = 15;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String currentWorkingSet = "";
    private SortedSet workingSets = new TreeSet(new WorkingSetComparator());
    private String locale;
    private AdaptableTocsArray root;

    public InfocenterWorkingSetManager(HttpServletRequest request, HttpServletResponse response, String locale) {
        this.request = request;
        this.response = response;
        this.locale = locale;
        this.restoreState();
    }

    public AdaptableTocsArray getRoot() {
        if (this.root == null) {
            this.root = new AdaptableTocsArray((IToc[])HelpPlugin.getTocManager().getTocs(this.locale));
        }
        return this.root;
    }

    public void addWorkingSet(WorkingSet workingSet) throws IOException {
        if (workingSet == null || this.workingSets.contains(workingSet)) {
            return;
        }
        this.workingSets.add(workingSet);
        this.saveState();
    }

    public WorkingSet createWorkingSet(String name, AdaptableHelpResource[] elements) {
        return new WorkingSet(name, elements);
    }

    public WorkingSet getWorkingSet(String name) {
        if (name == null || this.workingSets == null) {
            return null;
        }
        Iterator iter = this.workingSets.iterator();
        while (iter.hasNext()) {
            WorkingSet workingSet = (WorkingSet)iter.next();
            if (!name.equals(workingSet.getName())) continue;
            return workingSet;
        }
        return null;
    }

    public WorkingSet[] getWorkingSets() {
        return this.workingSets.toArray(new WorkingSet[this.workingSets.size()]);
    }

    public void removeWorkingSet(WorkingSet workingSet) {
        this.workingSets.remove(workingSet);
        try {
            this.saveState();
        }
        catch (IOException iOException) {}
    }

    private void restoreState() {
        String data = CookieUtil.restoreString(COOKIE_NAME, this.request);
        if (data == null) {
            return;
        }
        String[] values = data.split("\\|", -1);
        if (values.length < 1) {
            return;
        }
        this.currentWorkingSet = URLCoder.decode((String)values[0]);
        int i = 1;
        while (i < values.length) {
            block6: {
                String[] nameAndHrefs = values[i].split("&", -1);
                String name = URLCoder.decode((String)nameAndHrefs[0]);
                AdaptableHelpResource[] elements = new AdaptableHelpResource[nameAndHrefs.length - 1];
                int e = 0;
                while (e < nameAndHrefs.length - 1) {
                    int h = e + 1;
                    elements[e] = this.getAdaptableToc(URLCoder.decode((String)nameAndHrefs[h]));
                    if (elements[e] == null) {
                        elements[e] = this.getAdaptableTopic(URLCoder.decode((String)nameAndHrefs[h]));
                    }
                    if (elements[e] != null) {
                        ++e;
                        continue;
                    }
                    break block6;
                }
                WorkingSet ws = this.createWorkingSet(name, elements);
                this.workingSets.add(ws);
            }
            ++i;
        }
    }

    private void saveState() throws IOException {
        StringBuffer data = new StringBuffer();
        data.append(URLCoder.encode((String)this.currentWorkingSet));
        Iterator i = this.workingSets.iterator();
        while (i.hasNext()) {
            data.append('|');
            WorkingSet ws = (WorkingSet)i.next();
            data.append(URLCoder.encode((String)ws.getName()));
            AdaptableHelpResource[] resources = ws.getElements();
            int j = 0;
            while (j < resources.length) {
                data.append('&');
                IAdaptable parent = resources[j].getParent();
                if (parent == this.getRoot()) {
                    data.append(URLCoder.encode((String)resources[j].getHref()));
                } else {
                    AdaptableToc toc = (AdaptableToc)parent;
                    AdaptableHelpResource[] siblings = toc.getChildren();
                    int t = 0;
                    while (t < siblings.length) {
                        if (siblings[t] == resources[j]) {
                            data.append(URLCoder.encode((String)toc.getHref()));
                            data.append('_');
                            data.append(t);
                            data.append('_');
                            break;
                        }
                        ++t;
                    }
                }
                ++j;
            }
        }
        try {
            CookieUtil.saveString(COOKIE_NAME, data.toString(), 15, this.request, this.response);
        }
        catch (IOException ioe) {
            if (HelpWebappPlugin.DEBUG_WORKINGSETS) {
                System.out.println("InfocenterWorkingSetManager.saveState(): Too much data to save: " + data.toString());
            }
            throw ioe;
        }
    }

    public void workingSetChanged(WorkingSet changedWorkingSet) throws IOException {
        this.saveState();
    }

    public AdaptableToc getAdaptableToc(String href) {
        return this.getRoot().getAdaptableToc(href);
    }

    public AdaptableTopic getAdaptableTopic(String id) {
        if (id == null || id.length() == 0) {
            return null;
        }
        int len = id.length();
        if (id.charAt(len - 1) == '_') {
            String indexStr = id.substring(id.lastIndexOf(95, len - 2) + 1, len - 1);
            int index = 0;
            try {
                index = Integer.parseInt(indexStr);
            }
            catch (Exception exception) {}
            String tocStr = id.substring(0, id.lastIndexOf(95, len - 2));
            AdaptableToc toc = this.getAdaptableToc(tocStr);
            if (toc == null) {
                return null;
            }
            AdaptableHelpResource[] topics = toc.getChildren();
            if (index < 0 || index >= topics.length) {
                return null;
            }
            return (AdaptableTopic)topics[index];
        }
        return null;
    }

    public String getCurrentWorkingSet() {
        return this.currentWorkingSet;
    }

    public void setCurrentWorkingSet(String workingSet) {
        this.currentWorkingSet = workingSet;
        try {
            this.saveState();
        }
        catch (IOException iOException) {}
    }
}

