/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.actions.OpenFileInSystemEditorAction;
import org.eclipse.team.internal.ui.synchronize.actions.OpenInCompareAction;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizePageSite;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.OpenWithMenu;

public class OpenWithActionGroup
extends ActionGroup {
    private OpenFileInSystemEditorAction openFileAction;
    private OpenInCompareAction openInCompareAction;
    private final boolean includeOpenInCompare;
    private final ISynchronizePageConfiguration configuration;

    public OpenWithActionGroup(ISynchronizePageConfiguration configuration, boolean includeOpenInCompare) {
        this.configuration = configuration;
        this.includeOpenInCompare = includeOpenInCompare;
        this.makeActions();
    }

    protected void makeActions() {
        IWorkbenchSite ws = this.getSite().getWorkbenchSite();
        if (ws != null) {
            this.openFileAction = new OpenFileInSystemEditorAction(ws.getPage());
            if (this.includeOpenInCompare) {
                this.openInCompareAction = new OpenInCompareAction(this.configuration);
            }
        }
    }

    private ISynchronizeParticipant getParticipant() {
        return this.configuration.getParticipant();
    }

    private ISynchronizePageSite getSite() {
        return this.configuration.getSite();
    }

    public void fillContextMenu(IMenuManager menu, String groupId) {
        ISelection selection = this.getSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection && !this.hasFileMenu(menu)) {
            this.fillOpenWithMenu(menu, groupId, (IStructuredSelection)selection);
        }
    }

    private boolean hasFileMenu(IMenuManager menu) {
        return menu.find(this.openFileAction.getId()) != null;
    }

    private void fillOpenWithMenu(IMenuManager menu, String groupId, IStructuredSelection selection) {
        IWorkbenchSite ws;
        if (selection == null || selection.size() < 1) {
            return;
        }
        Object[] elements = selection.toArray();
        IResource[] resources = Utils.getResources(elements);
        if (resources.length == 0 && this.openInCompareAction != null) {
            ISynchronizeParticipant participant;
            if (elements.length > 0 && (participant = this.getParticipant()) instanceof ModelSynchronizeParticipant) {
                ModelSynchronizeParticipant msp = (ModelSynchronizeParticipant)participant;
                boolean allElementsHaveCompareInput = true;
                int i = 0;
                while (i < elements.length) {
                    if (!msp.hasCompareInputFor(elements[i])) {
                        allElementsHaveCompareInput = false;
                        break;
                    }
                    ++i;
                }
                if (allElementsHaveCompareInput) {
                    menu.appendToGroup(groupId, (IAction)this.openInCompareAction);
                }
            }
            return;
        }
        int i = 0;
        while (i < resources.length) {
            if (resources[i].getType() != 1) {
                return;
            }
            ++i;
        }
        if (resources.length > 0 && this.openInCompareAction != null) {
            menu.appendToGroup(groupId, (IAction)this.openInCompareAction);
        }
        i = 0;
        while (i < resources.length) {
            if (!resources[i].exists()) {
                return;
            }
            ++i;
        }
        if (this.openFileAction != null) {
            this.openFileAction.selectionChanged(selection);
            menu.appendToGroup(groupId, (IAction)this.openFileAction);
        }
        if (resources.length == 1 && (ws = this.getSite().getWorkbenchSite()) != null) {
            MenuManager submenu = new MenuManager(TeamUIMessages.OpenWithActionGroup_0);
            submenu.add((IContributionItem)new OpenWithMenu(ws.getPage(), (IAdaptable)resources[0]));
            menu.appendToGroup(groupId, (IContributionItem)submenu);
        }
    }

    public void openInCompareEditor() {
        if (this.openInCompareAction != null) {
            this.openInCompareAction.run();
        }
    }
}

