/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.jdml;

import com.rsi.jdml.IDMLInitializer;
import com.rsi.jdml.INativeLocation;
import com.rsi.jdml.LibraryLoadException;
import com.rsi.jdml.internal.NativeLocation;
import java.io.File;

public class PlatformSupport {
    private static final String SEP = File.separator;
    private static final String DEBUG_KEYWORD = "loadDebug";
    private static final String JDML_LIB_NAME = "idl_jdml";
    private static final String DML_LIB_NAME = "idl_dml";
    private static final String BML_LIB_NAME = "idl_bml";
    private static final String IDLOPS_LIB_NAME = "idl_ops";
    private static final String IDL_LIB_NAME_WIN = "idl.dll";
    private static final String IDL_LIB_NAME_MAC = "libidl.dylib";
    private static final String IDL_LIB_NAME_UNIX = "libidl.so";
    public static final String JDML_PROP_NAME = "JDMLDir";
    public static final String DML_PROP_NAME = "DMLDir";
    public static final String BML_PROP_NAME = "BMLDir";
    public static final String IDL_PROP_NAME = "IDLDir";
    public static final String IDLOPS_PROP_NAME = "IDLOPSDir";
    protected static String g_osgiArch;
    protected static String g_osgiOS;
    protected static String g_osgiWindowSystem;
    protected static String g_osName;
    private static boolean g_bDiagnostics;
    private static String g_IDLBinDir;
    private static String g_IDLDTBinDir;

    static {
        g_bDiagnostics = false;
        g_IDLBinDir = null;
        g_IDLDTBinDir = null;
        g_osgiArch = System.getProperty("osgi.arch");
        g_osgiOS = System.getProperty("osgi.os");
        g_osgiWindowSystem = System.getProperty("osgi.ws");
        g_osName = System.getProperty("os.name");
        if (System.getProperty(DEBUG_KEYWORD) != null) {
            g_bDiagnostics = true;
        }
    }

    public static boolean isWindows() {
        return g_osName.startsWith("Windows");
    }

    public static boolean isMac() {
        return g_osName.startsWith("Mac");
    }

    public static boolean isLinux() {
        return g_osName.startsWith("Linux");
    }

    private static void loadLibraryPerDefaultPath(String sLibName) throws Throwable {
        try {
            System.loadLibrary(sLibName);
        }
        catch (UnsatisfiedLinkError e) {
            if (e.getMessage().toLowerCase().indexOf("already loaded") < 0) {
                if (g_bDiagnostics) {
                    System.err.println("*** " + e);
                }
                throw e;
            }
        }
        catch (Throwable e) {
            if (g_bDiagnostics) {
                System.err.println("*** " + e);
            }
            throw e;
        }
    }

    private static void loadExplicitLibrary(String sLibLocation, String sLibName) throws Throwable {
        String libraryPath = sLibName;
        try {
            libraryPath = String.valueOf(sLibLocation) + SEP + System.mapLibraryName(sLibName);
            if (g_bDiagnostics) {
                System.out.println("Attempting to load " + libraryPath);
            }
            System.load(libraryPath);
        }
        catch (UnsatisfiedLinkError e) {
            if (e.getMessage().toLowerCase().indexOf("already loaded") < 0) {
                if (g_bDiagnostics) {
                    File file = new File(libraryPath);
                    if (!file.exists()) {
                        System.err.println("Library \"" + libraryPath + "\" does not exist.");
                    }
                    System.err.println("*** " + e);
                }
                throw e;
            }
        }
        catch (Throwable e) {
            if (g_bDiagnostics) {
                System.err.println("*** " + e);
            }
            throw e;
        }
    }

    public static void loadNeededLibrary(INativeLocation nativeLocation, String sLibName) throws LibraryLoadException {
        String sLibLocation = nativeLocation.getLocation();
        try {
            if (sLibLocation == null) {
                PlatformSupport.loadLibraryPerDefaultPath(sLibName);
            } else {
                PlatformSupport.loadExplicitLibrary(sLibLocation, sLibName);
            }
            if (g_bDiagnostics) {
                System.out.println("Successfully loaded " + System.mapLibraryName(sLibName) + " from " + nativeLocation);
            }
        }
        catch (Throwable e) {
            System.err.println("Failed to load " + sLibName + " from " + nativeLocation);
            throw new LibraryLoadException(nativeLocation, sLibName, sLibLocation, e);
        }
    }

    public static String convertFileURLToNativePath(String nativeURL) {
        String binary_location = nativeURL;
        try {
            if (PlatformSupport.isWindows()) {
                binary_location = binary_location.substring(1);
                String[] pieces = binary_location.split("/");
                int len = pieces.length;
                binary_location = "";
                int i = 0;
                while (i < len - 1) {
                    binary_location = String.valueOf(binary_location) + pieces[i] + File.separator;
                    ++i;
                }
                binary_location = String.valueOf(binary_location) + pieces[len - 1];
            } else if (binary_location.endsWith(File.separator)) {
                binary_location = binary_location.substring(0, binary_location.length() - 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return binary_location;
    }

    public static String convertPathToNativeSeparators(String initial) {
        String[] pieces = initial.split("/");
        int len = pieces.length;
        String s2 = "";
        int i = 0;
        while (i < len - 1) {
            s2 = String.valueOf(s2) + pieces[i] + File.separator;
            ++i;
        }
        s2 = String.valueOf(s2) + pieces[len - 1];
        return s2;
    }

    private static void verifyLibrary(INativeLocation loc, String libName, boolean isJNILib) {
        if (g_bDiagnostics) {
            String locRationale;
            String path = loc == null ? System.mapLibraryName(libName) : String.valueOf(loc.getLocation()) + SEP + System.mapLibraryName(libName);
            if (PlatformSupport.isMac() && !isJNILib) {
                path = path.replaceAll(".jnilib", ".dylib");
            }
            File file = new File(path);
            boolean exists = file.exists();
            String string = locRationale = loc == null ? "null" : loc.getRationale();
            if (exists) {
                System.out.println("OK: Library \"" + path + "\" exists. (Location rationale : " + locRationale + ")");
            } else {
                System.out.println("Warning: Library \"" + path + "\" does NOT exist. (Location rationale : " + locRationale + ")");
            }
        }
    }

    private static void verifyLibraryLocations(IDMLInitializer init) throws LibraryLoadException {
        PlatformSupport.verifyLibrary(PlatformSupport.getJDMLLocation(init), JDML_LIB_NAME, true);
        PlatformSupport.verifyLibrary(PlatformSupport.getDMLLocation(init), DML_LIB_NAME, false);
        PlatformSupport.verifyLibrary(PlatformSupport.getBMLLocation(init), BML_LIB_NAME, false);
        PlatformSupport.verifyLibrary(PlatformSupport.getIDLLocation(init), IDLOPS_LIB_NAME, false);
    }

    private static INativeLocation getBMLLocation(IDMLInitializer init) {
        INativeLocation location = init != null ? init.getBMLLocation() : PlatformSupport.getDirectoryByProperty(BML_PROP_NAME, null);
        return location;
    }

    private static INativeLocation getDMLLocation(IDMLInitializer init) {
        INativeLocation location = init != null ? init.getDMLLocation() : PlatformSupport.getDirectoryByProperty(DML_PROP_NAME, null);
        return location;
    }

    private static INativeLocation getIDLLocation(IDMLInitializer init) {
        INativeLocation location = init != null ? init.getIDLLocation() : PlatformSupport.getDirectoryByProperty(IDL_PROP_NAME, null);
        return location;
    }

    private static INativeLocation getJDMLLocation(IDMLInitializer init) {
        INativeLocation location = init != null ? init.getJDMLLocation() : PlatformSupport.getDirectoryByProperty(JDML_PROP_NAME, null);
        return location;
    }

    public static void loadLibraries(IDMLInitializer init) throws LibraryLoadException {
        INativeLocation dml_location = null;
        INativeLocation jdml_location = null;
        PlatformSupport.verifyLibraryLocations(init);
        if (PlatformSupport.isWindows()) {
            dml_location = PlatformSupport.getDMLLocation(init);
            PlatformSupport.loadNeededLibrary(dml_location, DML_LIB_NAME);
        }
        jdml_location = PlatformSupport.getJDMLLocation(init);
        PlatformSupport.loadNeededLibrary(jdml_location, JDML_LIB_NAME);
    }

    public static INativeLocation getDirectoryByProperty(String prop, INativeLocation defaultDir) {
        String dir = System.getProperty(prop);
        INativeLocation retVal = defaultDir;
        retVal = dir == null || dir.equals("") ? defaultDir : new NativeLocation(dir, "it is set by the property " + prop + ".");
        return retVal;
    }

    public static String getPlatformBinDirectory() {
        if (g_IDLBinDir == null) {
            if (PlatformSupport.isWindows()) {
                g_IDLBinDir = "bin.x86";
            } else if (g_osgiOS.equals("linux")) {
                if (g_osgiArch.equals("x86")) {
                    g_IDLBinDir = "bin.linux.x86";
                } else if (g_osgiArch.equals("x86_64")) {
                    g_IDLBinDir = "bin.linux.x86_64";
                }
            } else if (PlatformSupport.isMac()) {
                if (g_osgiArch.equals("ppc")) {
                    g_IDLBinDir = "bin.darwin.ppc";
                } else if (g_osgiArch.equals("x86")) {
                    g_IDLBinDir = "bin.darwin.i386";
                }
            } else if (g_osgiWindowSystem.equals("gtk")) {
                if (g_osgiArch.equals("sparc")) {
                    g_IDLBinDir = "bin.solaris2.sparc";
                } else if (g_osgiArch.equals("sparc64")) {
                    g_IDLBinDir = "bin.solaris2.sparc64";
                }
            } else if (g_osgiWindowSystem.equals("hpux")) {
                g_IDLBinDir = "bin.hp";
            } else if (g_osgiWindowSystem.equals("aix")) {
                g_IDLBinDir = "bin.ibm";
            }
            if (g_IDLBinDir == null) {
                System.err.println("OSGI Arch:" + g_osgiArch + " OS:" + g_osgiOS + " WS:" + g_osgiWindowSystem + " cannot be mapped to an IDL bin.<os>.<arch> combination.");
            }
        }
        if (g_bDiagnostics) {
            System.out.println("Bin directory: " + g_IDLBinDir);
        }
        return g_IDLBinDir;
    }

    public static String getIDLDTBinDirectory() {
        if (g_IDLDTBinDir == null) {
            if (PlatformSupport.isWindows()) {
                g_IDLDTBinDir = ".";
            } else if (g_osgiOS.equals("linux")) {
                g_IDLDTBinDir = "bin.linux.x86";
            } else if (PlatformSupport.isMac()) {
                if (g_osgiArch.equals("ppc")) {
                    g_IDLDTBinDir = "bin.darwin.ppc";
                } else if (g_osgiArch.equals("x86")) {
                    g_IDLDTBinDir = "bin.darwin.i386";
                }
            } else if (g_osgiWindowSystem.equals("gtk")) {
                g_IDLDTBinDir = "bin.solaris2.sparc";
            }
            if (g_IDLDTBinDir == null) {
                System.err.println("OSGI Arch:" + g_osgiArch + " OS:" + g_osgiOS + " WS:" + g_osgiWindowSystem + " cannot be mapped to an IDLDT bin.<os>.<arch> combination.");
            }
        }
        if (g_bDiagnostics) {
            System.out.println("Bin directory: " + g_IDLDTBinDir);
        }
        return g_IDLDTBinDir;
    }

    public static String getIDLLibName() {
        if (PlatformSupport.isWindows()) {
            return IDL_LIB_NAME_WIN;
        }
        if (PlatformSupport.isMac()) {
            return IDL_LIB_NAME_MAC;
        }
        return IDL_LIB_NAME_UNIX;
    }

    public static String getJavaBinLocation() {
        String javaHome = System.getProperty("java.home");
        javaHome = PlatformSupport.isWindows() ? String.valueOf(javaHome) + "\\bin\\javah.exe" : (PlatformSupport.isMac() ? String.valueOf(javaHome) + "/bin/java" : String.valueOf(javaHome) + "/bin/java");
        return javaHome;
    }
}

