/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.jdml;

public class IDLVariable {
    public static final int VARTYPE_UNDEF = 0;
    public static final int VARTYPE_BYTE = 1;
    public static final int VARTYPE_INT = 2;
    public static final int VARTYPE_LONG = 3;
    public static final int VARTYPE_FLOAT = 4;
    public static final int VARTYPE_DOUBLE = 5;
    public static final int VARTYPE_COMPLEX = 6;
    public static final int VARTYPE_STRING = 7;
    public static final int VARTYPE_STRUCT = 8;
    public static final int VARTYPE_DCOMPLEX = 9;
    public static final int VARTYPE_PTR = 10;
    public static final int VARTYPE_OBJREF = 11;
    public static final int VARTYPE_UINT = 12;
    public static final int VARTYPE_ULONG = 13;
    public static final int VARTYPE_LONG64 = 14;
    public static final int VARTYPE_ULONG64 = 15;
    private int m_type = 0;
    private Object m_value = null;

    public static IDLVariable createIDLVariable() {
        return new IDLVariable();
    }

    public void setUnsupportedType(int ty) {
        this.m_type = ty;
        this.m_value = null;
    }

    public void setString(String v) {
        this.m_value = v == null ? null : new String(v);
        this.m_type = 7;
    }

    public void setByte(byte v) {
        this.m_type = 1;
        this.m_value = new Byte(v);
    }

    public void setInt(short v) {
        this.m_type = 2;
        this.m_value = new Short(v);
    }

    public void setUint(short v) {
        this.m_type = 12;
        this.m_value = new Short(v);
    }

    public void setLong(int v) {
        this.m_type = 3;
        this.m_value = new Integer(v);
    }

    public void setUlong(int v) {
        this.m_type = 13;
        this.m_value = new Integer(v);
    }

    public void setLong64(long v) {
        this.m_type = 14;
        this.m_value = new Long(v);
    }

    public void setUlong64(long v) {
        this.m_type = 15;
        this.m_value = new Long(v);
    }

    public void setFloat(float v) {
        this.m_type = 4;
        this.m_value = new Float(v);
    }

    public void setDouble(double v) {
        this.m_type = 5;
        this.m_value = new Double(v);
    }

    public int getType() {
        return this.m_type;
    }

    public Object getValue() {
        return this.m_value;
    }

    public String getString() {
        if (this.m_type != 7) {
            return null;
        }
        return (String)this.m_value;
    }

    public static String getTypeName(int typ) {
        switch (typ) {
            case 1: {
                return "Byte";
            }
            case 2: {
                return "Int";
            }
            case 3: {
                return "Long";
            }
            case 4: {
                return "Float";
            }
            case 5: {
                return "Double";
            }
            case 7: {
                return "String";
            }
            case 12: {
                return "Uint";
            }
            case 13: {
                return "Ulong";
            }
            case 14: {
                return "Long64";
            }
            case 15: {
                return "Ulong64";
            }
            case 6: {
                return "Complex";
            }
            case 0: {
                return "Undefined";
            }
            case 8: {
                return "Struct";
            }
            case 9: {
                return "Dcomplex";
            }
            case 10: {
                return "Pointer";
            }
            case 11: {
                return "Objref";
            }
        }
        return "";
    }

    public static boolean isTypeSupported(int typ) {
        switch (typ) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        String result = "IDLVariable [" + IDLVariable.getTypeName(this.m_type);
        if (IDLVariable.isTypeSupported(this.m_type)) {
            result = String.valueOf(result) + " " + this.m_value;
        }
        result = String.valueOf(result) + "]";
        return result;
    }
}

