/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.jdml;

public class DebugInfoDTO {
    private String m_filePath;
    private int m_line;
    private int m_oldline;
    private int m_newline;
    private int m_flags;
    private boolean m_onRecompile;
    private boolean m_breakOnce;
    private String m_breakCondition;
    private int m_breakAfter;
    public static final int BKPT_FLAG_NULL = 0;
    public static final int BKPT_FLAG_ENABLE = 1;
    public static final int BKPT_FLAG_DISABLE = 2;
    public static final int BKPT_FLAG_CLEAR = 4;
    public static final int BKPT_FLAG_ERROR = 8;

    public DebugInfoDTO(int line, int old_line, int new_line, int flags, int breakAfter, boolean onRecompile, boolean breakOnce, String filePath, String condition) {
        this.m_filePath = filePath == null || filePath.equals("") ? null : new String(filePath);
        this.m_breakCondition = condition == null || condition.equals("") ? null : new String(condition);
        this.m_line = line;
        this.m_oldline = old_line;
        this.m_newline = new_line;
        this.m_flags = flags;
        this.m_onRecompile = onRecompile;
        this.m_breakOnce = breakOnce;
        this.m_breakAfter = breakAfter;
    }

    public DebugInfoDTO(DebugInfoDTO dto) {
        this(dto.m_line, dto.m_oldline, dto.m_newline, dto.m_flags, dto.m_breakAfter, dto.m_onRecompile, dto.m_breakOnce, dto.m_filePath, dto.m_breakCondition);
    }

    public static DebugInfoDTO createDebugInfoDTO(int line, int old_line, int new_line, int flags, int breakAfter, boolean onRecompile, boolean breakOnce, String filePath, String condition) {
        return new DebugInfoDTO(line, old_line, new_line, flags, breakAfter, onRecompile, breakOnce, filePath, condition);
    }

    public int getLine() {
        return this.m_line;
    }

    public int getOldLine() {
        return this.m_oldline;
    }

    public int getNewLine() {
        return this.m_newline;
    }

    public int getFlags() {
        return this.m_flags;
    }

    public boolean isBreakpointBeingEnabled() {
        return (this.m_flags & 1) == 1;
    }

    public boolean isBreakpointBeingDisabled() {
        return (this.m_flags & 2) == 2;
    }

    public boolean isBreakpointBeingCleared() {
        return (this.m_flags & 4) == 4;
    }

    public String getFilePath() {
        return this.m_filePath;
    }

    public int getBreakAfter() {
        return this.m_breakAfter;
    }

    public String getBreakCondition() {
        return this.m_breakCondition;
    }

    public boolean getBreakOnce() {
        return this.m_breakOnce;
    }

    public boolean getOnRecompile() {
        return this.m_onRecompile;
    }

    public String toString() {
        return "DebugInfoDTO [line=" + this.getLine() + " file=" + this.getFilePath() + " old_line=" + this.getOldLine() + " new_line=" + this.getNewLine() + " flags=0x" + Integer.toHexString(this.getFlags()) + " breakAfter=" + this.getBreakAfter() + " onRecompile=" + this.getOnRecompile() + " breakOnce=" + this.getBreakOnce() + " condition=" + this.getBreakCondition() + "]";
    }
}

