/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.jdml;

import com.rsi.idldt.core.utils.Rectangle;
import com.rsi.jdml.BreakpointDTO;
import com.rsi.jdml.CommandFinishedDTO;
import com.rsi.jdml.CompileErrorContext;
import com.rsi.jdml.DebugInfoDTO;
import com.rsi.jdml.IDLPreferencesDTO;
import com.rsi.jdml.IDLVariable;
import com.rsi.jdml.IDMLInitializer;
import com.rsi.jdml.IErrorInfo;
import com.rsi.jdml.IIDLVariableContainer;
import com.rsi.jdml.IInterpreterResponses;
import com.rsi.jdml.KeyboardEvent;
import com.rsi.jdml.LibraryLoadException;
import com.rsi.jdml.PlatformSupport;
import com.rsi.jdml.RecallHistoryList;
import com.rsi.jdml.StackFramesDTO;
import com.rsi.jdml.internal.DMLHashtableEntry;
import com.rsi.jdml.internal.IDLCookie;
import com.rsi.jdml.internal.IDLHashtable;
import com.rsi.jdml.internal.ModalDialogInfo;
import java.util.Hashtable;

public class DMLAccess {
    private static final int SYSTEM_VARS = 0;
    private static final int HEAP_VARS = 1;
    public static final int VAR_IS_PARAM = 1;
    public static final int VAR_IS_READ_ONLY = 2;
    public static final int VAR_IS_INDEXABLE = 4;
    public static final int VAR_IS_COMMON_BLOCK = 8;
    public static final int VAR_HAS_CHANGED = 16;
    public static final int VAR_HAS_CHILD_CHANGED = 32;
    public static final int VAR_SHOULD_REDO_CHILD = 64;
    public static final int FRAME_HAS_ROUTINE_CHANGED = 1;
    public static final int FRAME_HAS_FILE_CHANGED = 2;
    public static final int FRAME_HAS_LINENUM_CHANGED = 4;
    public static final int FRAME_HAS_VARINFO_CHANGED = 8;
    public static final int STACK_HAS_CHANGED = 1;
    public static final int STACK_IS_CLIPPED = 2;
    public static final int STACK_MEMORY_ERROR = 4;
    public static final int VARTYPE_UNDEF = 0;
    public static final int VARTYPE_BYTE = 1;
    public static final int VARTYPE_INT = 2;
    public static final int VARTYPE_LONG = 3;
    public static final int VARTYPE_FLOAT = 4;
    public static final int VARTYPE_DOUBLE = 5;
    public static final int VARTYPE_COMPLEX = 6;
    public static final int VARTYPE_STRING = 7;
    public static final int VARTYPE_STRUCT = 8;
    public static final int VARTYPE_DCOMPLEX = 9;
    public static final int VARTYPE_PTR = 10;
    public static final int VARTYPE_OBJREF = 11;
    public static final int VARTYPE_UINT = 12;
    public static final int VARTYPE_ULONG = 13;
    public static final int VARTYPE_LONG64 = 14;
    public static final int VARTYPE_ULONG64 = 15;
    public static final String OPS_NAME_PREFIX = "DML$IDL$";
    public static final int DMLLOG_OFF = 0;
    public static final int DMLLOG_ENTER_EXIT = 1;
    public static final int DMLLOG_FINE = 2;
    public static final int DMLLOG_FINER = 3;
    private static boolean g_initialized = false;
    private static IDMLInitializer g_initializer = null;
    private static final String JDML_LOG_LEVEL = "JDMLLogLevel";
    private static final String JDML_LOG_THREADS = "JDMLLogThread";
    private static final String JDML_LOG_TIMES = "JDMLLogTime";
    private static final int g_logLevel;
    private static boolean g_logThreads;
    private static boolean g_logTimes;
    private static long g_time;
    private static IDLHashtable g_pidToObjectMap;
    private static Hashtable<Long, IDLCookie> g_pidToCookieMap;
    private static Long g_workbench_pid;
    public static final int OUTPUT_CONTEXT_NORMAL = 0;
    public static final int OUTPUT_CONTEXT_COMPILE_ERR = 1;
    public static final int OUTPUT_CONTEXT_RUNTIME_ERR = 2;

    static {
        g_pidToObjectMap = new IDLHashtable();
        g_pidToCookieMap = new Hashtable();
        g_workbench_pid = null;
        g_logLevel = Integer.getInteger(JDML_LOG_LEVEL, 0);
        g_logThreads = System.getProperty(JDML_LOG_THREADS) != null;
        g_logTimes = System.getProperty(JDML_LOG_TIMES) != null;
        g_time = System.currentTimeMillis();
    }

    private static native int nInitializeJDML(int var0);

    public static synchronized void initializeJDML() {
        DMLAccess.logEnter("initializeJDML");
        DMLAccess.nInitializeJDML(g_logLevel);
        DMLAccess.logExit("initializeJDML");
    }

    private static IInterpreterResponses getResponseHandler(long debugID) {
        return g_pidToObjectMap.getResponseHandler(debugID);
    }

    private static native int nInitializeDML(IDMLInitializer var0);

    public static synchronized int initializeDML(IDMLInitializer init) throws LibraryLoadException {
        DMLAccess.logExit("initializeDML");
        int retVal = 0;
        if (!g_initialized) {
            PlatformSupport.loadLibraries(init);
            DMLAccess.initializeJDML();
            if (init != null) {
                g_initializer = init;
            }
            retVal = DMLAccess.nInitializeDML(init);
        }
        DMLAccess.logExit("initializeDML returns" + retVal);
        return retVal;
    }

    public static void releaseDML() {
    }

    public static String getOPSNameForWorkbench() {
        while (g_workbench_pid == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        IDLCookie cookie = g_pidToCookieMap.get(g_workbench_pid);
        return OPS_NAME_PREFIX + Integer.toHexString(cookie.getDebugID());
    }

    public static native long nCreateIDLInstance(IDLCookie var0, IDMLInitializer var1);

    public static synchronized long createIDLInstance(IInterpreterResponses respHandler) {
        DMLAccess.logEnter("createIDLInstance rh=" + respHandler);
        IDLCookie idlcookie = new IDLCookie();
        long id = DMLAccess.nCreateIDLInstance(idlcookie, g_initializer);
        if (id > 0L) {
            g_pidToObjectMap.put(id, new DMLHashtableEntry(respHandler));
            Long proc_id = new Long(id);
            g_pidToCookieMap.put(proc_id, idlcookie);
            if (g_workbench_pid == null) {
                g_workbench_pid = proc_id;
            }
        }
        DMLAccess.logExit("createIDLInstance id=0x" + Long.toHexString(id));
        return id;
    }

    public static native long nStartIDLInstance(long var0);

    public static synchronized long startIDLInstance(long debugID) {
        DMLAccess.logEnter("startIDLInstance", debugID);
        long retVal = DMLAccess.nStartIDLInstance(debugID);
        DMLAccess.logExit("startIDLInstance ret=" + retVal);
        return retVal;
    }

    public static native long nDestroyIDLInstance(long var0);

    public static synchronized long destroyIDLInstance(long debugID) {
        DMLAccess.logEnter("destroyIDLInstance", debugID);
        long retVal = DMLAccess.nDestroyIDLInstance(debugID);
        g_pidToObjectMap.remove(debugID);
        g_pidToCookieMap.remove(new Long(debugID));
        DMLAccess.logExit("destroyIDLInstance retVal=" + retVal);
        return retVal;
    }

    private static native int nExecuteString(long var0, String var2);

    public static synchronized int executeString(long debugID, String cmd) {
        DMLAccess.logEnter("executeString", debugID);
        DMLAccess.commandStarted(debugID);
        int retVal = DMLAccess.nExecuteString(debugID, cmd);
        DMLAccess.logExit("executeString");
        return retVal;
    }

    private static native int nSilentExecuteString(long var0, String var2);

    public static synchronized int silentExecuteString(long debugID, String cmd) {
        DMLAccess.logEnter("silentExecuteString", debugID);
        DMLAccess.commandStarted(debugID);
        int retVal = DMLAccess.nSilentExecuteString(debugID, cmd);
        DMLAccess.logExit("silentExecuteString");
        return retVal;
    }

    private static native int nRequestAbort(long var0);

    public static int requestAbort(long debugID) {
        DMLAccess.logEnter("requestAbort", debugID);
        int retVal = DMLAccess.nRequestAbort(debugID);
        DMLAccess.logExit("requestAbort retVal=" + retVal);
        return retVal;
    }

    private static native int nGetLastError(long var0, IErrorInfo var2);

    public static synchronized int getLastError(long debugID, IErrorInfo err) {
        DMLAccess.logEnter("getLastError", debugID);
        int retVal = DMLAccess.nGetLastError(debugID, err);
        DMLAccess.logExit("getLastError retVal=" + retVal);
        return retVal;
    }

    private static native int nGetIDLVariable(long var0, String var2, IDLVariable var3);

    public static synchronized int getIDLVariable(long debugID, String varName, IDLVariable var) {
        DMLAccess.logEnter("getIDLVariable", debugID);
        int retVal = DMLAccess.nGetIDLVariable(debugID, varName, var);
        DMLAccess.logExit("getIDLVariable retVal=" + retVal);
        return retVal;
    }

    private static native void nSetTTYSize(long var0, int var2, int var3);

    public static synchronized void setTTYSize(long debugID, Rectangle tty) {
        DMLAccess.logEnter("setTTYSize", debugID);
        if (tty != null) {
            int h = tty.height;
            int w = tty.width;
            if (h > 0 && w > 0) {
                DMLAccess.nSetTTYSize(debugID, h, w);
            }
        }
        DMLAccess.logExit("setTTYSize");
    }

    private static native void nUpdateVariableValue(long var0, long var2, String var4);

    public static void updateVariableValue(long debugID, long varID, String newValue) {
        DMLAccess.logEnter("updateVariableValue", debugID);
        DMLAccess.nUpdateVariableValue(debugID, varID, newValue);
        DMLAccess.logExit("updateVariableValue");
    }

    private static native void nUpdateBreakpoint(long var0, int var2, BreakpointDTO var3, boolean var4);

    public static void updateBreakpoint(long debugID, int break_op, BreakpointDTO bkpt) {
        DMLAccess.logEnter("updateBreakpoint", debugID);
        DMLAccess.nUpdateBreakpoint(debugID, break_op, bkpt, false);
        DMLAccess.logExit("updateBreakpoint");
    }

    public static void routeShowBreakpoint(long debugID, DebugInfoDTO dto) {
        DMLAccess.logEnter("routeShowBreakpoint", debugID, " dto=" + dto);
        DebugInfoDTO newDTO = new DebugInfoDTO(dto);
        DMLAccess.getResponseHandler(debugID).showBreakpoint(newDTO);
        DMLAccess.logExit("routeShowBreakpoint");
    }

    public static void routeBreakpointMoved(long debugID, DebugInfoDTO dto) {
        DMLAccess.logEnter("routeBreakpointMoved", debugID, " dto=" + dto);
        DebugInfoDTO newDTO = new DebugInfoDTO(dto);
        DMLAccess.getResponseHandler(debugID).breakpointMoved(newDTO);
        DMLAccess.logExit("routeBreakpointMoved");
    }

    private static native void nGetStackFrameInformation(long var0, StackFramesDTO var2);

    public static synchronized void getStackFrameInformation(long debugID, StackFramesDTO frames) {
        DMLAccess.logEnter("getStackFrameInformation", debugID);
        DMLAccess.nGetStackFrameInformation(debugID, frames);
        DMLAccess.logExit("getStackFrameInformation");
    }

    private static native void nGetSystemHeapVariableInformation(long var0, int var2, IIDLVariableContainer var3);

    public static synchronized void getHeapVariableInformation(long debugID, IIDLVariableContainer dto) {
        DMLAccess.logEnter("getHeapVariableInformation", debugID);
        DMLAccess.nGetSystemHeapVariableInformation(debugID, 1, dto);
        DMLAccess.logExit("getHeapVariableInformation");
    }

    public static synchronized void getSystemVariableInformation(long debugID, IIDLVariableContainer dto) {
        DMLAccess.logEnter("getSystemVariableInformation", debugID);
        DMLAccess.nGetSystemHeapVariableInformation(debugID, 0, dto);
        DMLAccess.logExit("getSystemVariableInformation");
    }

    private static native void nGetRecallHistory(long var0, RecallHistoryList var2);

    public static void getRecallHistory(long debugID, RecallHistoryList rhistory) {
        DMLAccess.logEnter("getRecallHistory", debugID);
        DMLAccess.nGetRecallHistory(debugID, rhistory);
        DMLAccess.logExit("getRecallHistory");
    }

    private static native void nClearRecallHistory(long var0);

    public static void clearRecallHistory(long debugID) {
        DMLAccess.logEnter("clearRecallHistory", debugID);
        DMLAccess.nClearRecallHistory(debugID);
        DMLAccess.logExit("clearRecallHistory");
    }

    private static native void nSetPreferences(long var0, IDLPreferencesDTO var2);

    public static void setPreferences(long debugID, IDLPreferencesDTO prefs) {
        DMLAccess.logEnter("setPreferences", debugID);
        DMLAccess.nSetPreferences(debugID, prefs);
        DMLAccess.logExit("setPreferences");
    }

    private static native void nGetPreferences(long var0, IDLPreferencesDTO var2);

    public static void getPreferences(long debugID, IDLPreferencesDTO prefs) {
        DMLAccess.logEnter("getPreferences", debugID);
        DMLAccess.nGetPreferences(debugID, prefs);
        DMLAccess.logExit("getPreferences");
    }

    private static native void nGetDefaultPreferences(long var0, IDLPreferencesDTO var2);

    public static void getDefaultPreferences(long debugID, IDLPreferencesDTO prefs) {
        DMLAccess.logEnter("nGetDefaultPreferences", debugID);
        DMLAccess.nGetDefaultPreferences(debugID, prefs);
        DMLAccess.logExit("nGetDefaultPreferences");
    }

    private static native int nAnswerReadIOLine(long var0, String var2);

    public static void answerReadIOLine(long debugID, String line) {
        DMLAccess.logEnter("answerReadIOLine", debugID);
        if (line != null) {
            DMLAccess.nAnswerReadIOLine(debugID, line);
        } else {
            DMLAccess.nAnswerReadIOLine(debugID, "");
        }
        DMLAccess.logExit("answerReadIOLine");
    }

    private static native void nAnswerReadProgramLine(long var0, String var2);

    public static void answerReadProgramLine(long debugID, String s) {
        DMLAccess.logEnter("answerReadProgramLine", debugID);
        DMLAccess.nAnswerReadProgramLine(debugID, s);
        DMLAccess.logExit("answerReadProgramLine");
    }

    private static native int nAnswerGetKeyboard(long var0, String var2);

    public static void answerGetKeyboard(long debugID, KeyboardEvent k) {
        DMLAccess.logEnter("answerGetKeyboard", debugID);
        if (k != null) {
            DMLAccess.nAnswerGetKeyboard(debugID, "" + k.getCharacter());
        } else {
            DMLAccess.nAnswerGetKeyboard(debugID, "");
        }
        DMLAccess.logExit("answerGetKeyboard");
    }

    private static native int nAnswerResetSessionConfirm(long var0, boolean var2);

    public static synchronized void answerResetSessionConfirm(long debugID, boolean answer) {
        DMLAccess.logEnter("answerResetSessionConfirm", debugID);
        DMLAccess.nAnswerResetSessionConfirm(debugID, answer);
        DMLAccess.logExit("answerResetSessionConfirm");
    }

    private static native int nAnswerModalMessage(long var0, boolean var2);

    public static void answerModalMessage(long debugID, boolean answer) {
        DMLAccess.logEnter("answerModalMessage", debugID);
        DMLAccess.nAnswerModalMessage(debugID, answer);
        DMLAccess.logExit("answerModalMessage");
    }

    public static synchronized void answerMoreQuery(long debugID, KeyboardEvent key) {
    }

    public static boolean exitDoneSeen(long debugID) {
        return DMLAccess.getResponseHandler(debugID).exitDoneSeen();
    }

    public static void exitDone(long debugID) {
        DMLAccess.logEnter("exitDone", debugID);
        DMLAccess.getResponseHandler(debugID).exitDone();
        DMLAccess.logExit("exitDone");
    }

    public static void deathHint(long debugID) {
        DMLAccess.logEnter("deathHint", debugID);
        DMLAccess.getResponseHandler(debugID).deathHint();
        DMLAccess.logExit("deathHint");
    }

    public static void processGone(long debugID) {
        DMLAccess.logEnter("processGone", debugID);
        DMLAccess.getResponseHandler(debugID).processGone();
        DMLAccess.logExit("processGone");
    }

    public static void resetDone(long debugID) {
        DMLAccess.logEnter("resetDone", debugID);
        DMLAccess.getResponseHandler(debugID).resetDone();
        DMLAccess.logExit("resetDone");
    }

    public static void commandStarted(long debugID) {
        DMLAccess.logEnter("commandStarted", debugID);
        DMLAccess.getResponseHandler(debugID).commandStarted();
        DMLAccess.logExit("commandStarted");
    }

    public static void commandFinished(long debugID, CommandFinishedDTO dto) {
        DMLAccess.logEnter("commandFinished", debugID);
        CommandFinishedDTO newDTO = new CommandFinishedDTO(dto);
        DMLAccess.getResponseHandler(debugID).commandFinished(newDTO);
        DMLAccess.logExit("commandFinished");
    }

    protected static CompileErrorContext createCompileErrorContext(int lineno, int charno, String fileName) {
        DMLAccess.logEnter("createCompileErrorContext");
        String newPath = new String(fileName);
        CompileErrorContext ctx = new CompileErrorContext(lineno, charno, newPath);
        DMLAccess.logExit("createCompileErrorContext ctx=" + ctx);
        return ctx;
    }

    protected static void setIDLOutputContext(long debugID, int context, CompileErrorContext ctx) {
        DMLAccess.logEnter("setIDLOutputContext", debugID);
        CompileErrorContext newCtx = ctx == null ? null : new CompileErrorContext(ctx);
        IInterpreterResponses rh = DMLAccess.getResponseHandler(debugID);
        rh.setIDLOutputContext(context, newCtx);
        DMLAccess.logExit("setIDLOutputContext");
    }

    protected static void routeOutput(long debugID, String s) {
        DMLAccess.logEnter("routeOutput", debugID);
        if (s != null && s.length() > 0) {
            String s1 = new String(s);
            String s2 = s1.replaceAll("\\r\\n", "\n");
            IInterpreterResponses rh = DMLAccess.getResponseHandler(debugID);
            rh.idlOutput(s2);
        }
        DMLAccess.logExit("routeOutput");
    }

    protected static void routeNewIDLRoutine(long debugID, String name, boolean isSystem, boolean isFunction) {
    }

    protected static void routeCommandStarted(long debugID) {
        DMLAccess.logEnter("routeCommandStarted", debugID);
        DMLAccess.logExit("routeCommandStarted");
    }

    protected static void routeCommandFinished(long debugID, int errCode, String err, String timestamp) {
        DMLAccess.logEnter("routeCommandFinished", debugID);
        String newErr = new String(err);
        String newTimestamp = new String(timestamp);
        DMLAccess.commandFinished(debugID, new CommandFinishedDTO(errCode, newErr, newTimestamp));
        DMLAccess.logExit("routeCommandFinished");
    }

    public static void routePromptChanged(long debugID, String prompt) {
        DMLAccess.logEnter("routePromptChanged", debugID);
        String newPrompt = new String(prompt);
        DMLAccess.getResponseHandler(debugID).promptChanged(newPrompt);
        DMLAccess.logExit("routePromptChanged");
    }

    public static void routePathChanged(long debugID, String path) {
        DMLAccess.logEnter("routePathChanged", debugID);
        String newPath = new String(path);
        DMLAccess.getResponseHandler(debugID).pathChanged(newPath);
        DMLAccess.logExit("routePathChanged");
    }

    public static void routeWorkingDirChanged(long debugID, String workingDir) {
        DMLAccess.logEnter("routeWorkingDirChanged", debugID);
        String newDir = new String(workingDir);
        DMLAccess.getResponseHandler(debugID).workingDirChanged(newDir);
        DMLAccess.logExit("routeWorkingDirChanged");
    }

    public static void routeDelvar(long debugID, String varname) {
        DMLAccess.logEnter("routeDelvar", debugID);
        String var = new String(varname);
        DMLAccess.getResponseHandler(debugID).mainVariableDeleted(var);
        DMLAccess.logExit("routeDelvar");
    }

    public static void routeIDLNotify(long debugID, String notifyid, IDLVariable parm1, IDLVariable parm2) {
        DMLAccess.logEnter("routeIDLNotify", debugID);
        String notify_id = new String(notifyid);
        DMLAccess.getResponseHandler(debugID).idlNotify(notify_id, parm1, parm2);
        DMLAccess.logExit("routeIDLNotify");
    }

    public static void routeVariablesChanged(long debugID) {
        DMLAccess.logEnter("routeVariablesChanged", debugID);
        DMLAccess.getResponseHandler(debugID).variablesChanged();
        DMLAccess.logExit("routeVariablesChanged");
    }

    public static void requestGetKeyboard(long debugID, int flags) {
        DMLAccess.logEnter("requestGetKeyboard", debugID);
        DMLAccess.getResponseHandler(debugID).requestGetKeyboard(flags);
        DMLAccess.logExit("requestGetKeyboard");
    }

    public static void requestResetConfirm(long debugID) {
        DMLAccess.logEnter("requestResetConfirm", debugID);
        DMLAccess.getResponseHandler(debugID).requestResetConfirm();
        DMLAccess.logExit("requestResetConfirm");
    }

    public static void requestIOLine(long debugID, String prompt) {
        DMLAccess.logEnter("requestIOLine", debugID);
        String newPrompt = new String(prompt);
        DMLAccess.getResponseHandler(debugID).requestIOLine(newPrompt);
        DMLAccess.logExit("requestIOLine");
    }

    public static void requestModalResponse(long debugID, boolean isInfo, String title, String message) {
        DMLAccess.logEnter("requestModalResponse", debugID);
        String newTitle = title == null ? null : new String(title);
        String newMessage = message == null ? null : new String(message);
        ModalDialogInfo info = new ModalDialogInfo(newTitle, newMessage, 2, false, false);
        DMLAccess.getResponseHandler(debugID).requestModalResponse(info);
        DMLAccess.logExit("requestModalResponse");
    }

    public static void requestOpenFile(long debugID, String filePath) {
        DMLAccess.logEnter("requestOpenFile", debugID);
        String newPath = new String(filePath);
        DMLAccess.getResponseHandler(debugID).requestOpenFile(newPath);
        DMLAccess.logExit("requestOpenFile");
    }

    public static void interpreterStopped(long debugID, String filePath, String module, int lineno, int errCode) {
        DMLAccess.logEnter("interpreterStopped", debugID);
        String newPath = new String(filePath);
        String newModule = new String(module);
        DMLAccess.logMiddle(2, "interpreterStopped", "at " + newPath + " mod:" + newModule + " lineno=" + lineno + " err=" + errCode);
        DMLAccess.getResponseHandler(debugID).interpreterStopped(newPath, newModule, lineno, errCode);
        DMLAccess.logExit("interpreterStopped");
    }

    public static void alertCompileFile(long debugID, String filePath) {
        DMLAccess.logEnter("alertCompileFile", debugID, " filePath" + filePath);
        String newPath = new String(filePath);
        DMLAccess.getResponseHandler(debugID).alertCompileFile(newPath);
        DMLAccess.logExit("alertCompileFile");
    }

    public static void routeHelpTopic(long debugID, String topic) {
        DMLAccess.logEnter("routeHelpTopic", debugID, " topic" + topic);
        String newTopic = new String(topic);
        DMLAccess.getResponseHandler(debugID).helpTopic(newTopic);
        DMLAccess.logExit("routeHelpTopic");
    }

    public static void requestMoreResponse(long debugID) {
        DMLAccess.logEnter("requestMoreResponse", debugID);
        DMLAccess.getResponseHandler(debugID).requestMoreResponse();
        DMLAccess.logExit("requestMoreResponse");
    }

    public static void requestProgramLine(long debugID) {
        DMLAccess.logEnter("requestProgramLine", debugID);
        DMLAccess.getResponseHandler(debugID).requestProgramLine();
        DMLAccess.logExit("requestProgramLine");
    }

    public static void setInitialTime() {
        g_time = System.currentTimeMillis();
    }

    private static long getDelta() {
        return System.currentTimeMillis() - g_time;
    }

    private static void logExit(String methodName) {
        if (g_logLevel >= 1) {
            DMLAccess.internalLogExit(methodName);
        }
    }

    private static void logEnter(String methodName) {
        if (g_logLevel >= 1) {
            DMLAccess.internalLogEnter(methodName);
        }
    }

    private static void logEnter(String methodName, long debugID) {
        if (g_logLevel >= 1) {
            DMLAccess.internalLogEnter(String.valueOf(methodName) + " id=0x" + Long.toHexString(debugID));
        }
    }

    private static void logEnter(String methodName, long debugID, String additional) {
        if (g_logLevel >= 1) {
            DMLAccess.internalLogEnter(String.valueOf(methodName) + " id=0x" + Long.toHexString(debugID) + additional);
        }
    }

    private static void logMiddle(int level, String methodName, String message) {
        if (g_logLevel >= level) {
            DMLAccess.internalLogMiddle("-" + methodName + " " + message);
        }
    }

    private static void internalLog(String s) {
        if (g_logLevel > 0) {
            System.out.println(s);
        }
    }

    private static String calculatePrefix() {
        String prefix = "";
        if (g_logTimes) {
            prefix = String.valueOf(DMLAccess.getDelta()) + "ms ";
        }
        return prefix;
    }

    private static String calculateAdditionalLogging() {
        String more = "";
        if (g_logThreads) {
            more = " thread=" + Thread.currentThread().getName();
        }
        return more;
    }

    private static void internalLogEnter(String s) {
        String prefix = DMLAccess.calculatePrefix();
        String more = DMLAccess.calculateAdditionalLogging();
        DMLAccess.internalLog(String.valueOf(prefix) + ">" + s + more);
    }

    private static void internalLogMiddle(String message) {
        String prefix = DMLAccess.calculatePrefix();
        DMLAccess.internalLog(String.valueOf(prefix) + "-" + message);
    }

    private static void internalLogExit(String s) {
        String prefix = DMLAccess.calculatePrefix();
        String more = DMLAccess.calculateAdditionalLogging();
        DMLAccess.internalLog(String.valueOf(prefix) + "<" + s + more);
    }

    public static void reportJNIExceptionInfo(Object o) {
        System.out.println("JNI Info: thread=" + Thread.currentThread());
        if (o instanceof Throwable) {
            Throwable exc = (Throwable)o;
            exc.printStackTrace(System.out);
            Throwable cause = exc.getCause();
            if (cause != null) {
                System.out.println("... caused by:");
                cause.printStackTrace(System.out);
            }
        }
    }
}

