/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.launching;

import com.rsi.idldt.core.IDLDTCorePlugin;
import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.core.Messages;
import com.rsi.idldt.core.utils.Tracer;
import com.rsi.idldt.debug.internal.model.IDLDebugTarget;
import com.rsi.idldt.launching.IDLRunConfiguration;
import com.rsi.idldt.launching.IIDLRunner;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;

public class StandardIDLRunner
implements IIDLRunner {
    protected IIDLProcessProxy m_idl;

    public StandardIDLRunner(IIDLProcessProxy process) {
        this.m_idl = process;
    }

    protected String renderDebugTarget(String id) {
        return Messages.bind(Messages.IDLRunner_TargetLabel, id);
    }

    public static String renderProcessLabel(String[] commandLine) {
        String timestamp = DateFormat.getDateTimeInstance(2, 2).format(new Date(System.currentTimeMillis()));
        return Messages.bind(Messages.IDLRunner_ProcessLabel, commandLine[0], timestamp);
    }

    protected boolean fileExists(File file) {
        return file.exists() && file.isFile();
    }

    public void run(IDLRunConfiguration config, ILaunch launch, IProgressMonitor theMonitor) throws CoreException {
        IProgressMonitor monitor = theMonitor;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.m_idl = config.getIDLProcess();
        Tracer.trace(Tracer.TRACE_DEBUG_MODEL2, "idl=" + this.m_idl);
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        subMonitor.beginTask("StandardIDLRunner.Launching_VM..._1", 2);
        subMonitor.subTask("StandardIDLRunner.Constructing_command_line..._2");
        subMonitor.worked(1);
        if (monitor.isCanceled()) {
            return;
        }
        subMonitor.subTask("StandardIDLRunner.Starting_IDL process...");
        Tracer.trace(Tracer.TRACE_DEBUG_MODEL2, "=StandardIDLRunner::run");
        IDLDebugTarget target = new IDLDebugTarget(launch, this.m_idl);
        this.m_idl.setDebugTarget(target);
        subMonitor.worked(1);
        subMonitor.done();
    }

    protected void throwException(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, IDLDTCorePlugin.getPluginIdentifier(), code, message, exception));
    }
}

