/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.launching;

import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.core.utils.Tracer;
import com.rsi.idldt.launching.IDLRunConfiguration;
import com.rsi.idldt.launching.IIDLRunner;
import com.rsi.idldt.launching.ProSourceLookupDirector;
import com.rsi.idldt.launching.StandardIDLRunner;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.ISourceLocator;

public class IDLLaunchDelegate
implements ILaunchConfigurationDelegate {
    public static final String ID_IDL_LAUNCH_CONFIG = "com.rsi.idldt.launching.localIDLApplication";

    public static ILaunchConfigurationType getIDLLaunchConfigType() {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        return lm.getLaunchConfigurationType(ID_IDL_LAUNCH_CONFIG);
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor theMonitor) throws CoreException {
        Tracer.trace(Tracer.TRACE_DEBUG_MODEL2, ">IDLLocalApplLauchConfig::launch config=" + configuration);
        String pid = configuration.getAttribute("com.rsi.idldt.launching.DEBUG_ID", "");
        Tracer.trace(Tracer.TRACE_DEBUG_MODEL2, "pid=" + pid);
        long pid2 = Long.valueOf(pid);
        IIDLProcessProxy idl = IDLProcessManager.getProcessByID(pid2);
        Tracer.trace(Tracer.TRACE_DEBUG_MODEL2, "idl=" + idl);
        IProgressMonitor monitor = theMonitor;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(MessageFormat.format("{0}...", configuration.getName()), 100);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.subTask("verifying launch configuration");
        IIDLRunner runner = this.getIDLRunner(mode);
        IDLRunConfiguration runConfig = new IDLRunConfiguration(idl);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.worked(25);
        monitor.subTask("IDLLocalApplicationLaunchConfigurationDelegate.Creating_source_locator..._2");
        this.setDefaultSourceLocator(launch, configuration);
        monitor.worked(15);
        Tracer.trace(Tracer.TRACE_DEBUG_MODEL2, "-IDLLocalApplLauchConfig::launch Now launch...");
        runner.run(runConfig, launch, monitor);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.done();
        Tracer.trace(Tracer.TRACE_DEBUG_MODEL2, "<IDLLocalApplLauchConfig::launch");
    }

    private IIDLRunner getIDLRunner(String mode) {
        if ("debug".equals(mode)) {
            return new StandardIDLRunner(IDLProcessManager.getActiveProcess());
        }
        return null;
    }

    protected void setDefaultSourceLocator(ILaunch launch, ILaunchConfiguration configuration) throws CoreException {
        Tracer.trace(Tracer.TRACE_DEBUG_MODEL2, ">AbstrIDLLaunchConfig::setDefaultSourceLocator(" + configuration + ")");
        if (launch.getSourceLocator() == null) {
            ProSourceLookupDirector sourceLocator = new ProSourceLookupDirector();
            sourceLocator.setSourcePathComputer(this.getLaunchManager().getSourcePathComputer("com.rsi.idldt.launching.sourceLookup.ProSourcePathComputer"));
            sourceLocator.initializeDefaults(configuration);
            launch.setSourceLocator((ISourceLocator)sourceLocator);
        }
        Tracer.trace(Tracer.TRACE_DEBUG_MODEL2, "<AbstrIDLLaunchConfig::setDefaultSourceLocator");
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }
}

