/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.debug.internal.model;

import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.core.utils.Tracer;
import com.rsi.idldt.debug.internal.model.IDLDebugElement;
import com.rsi.idldt.debug.internal.model.IDLDebugTarget;
import com.rsi.idldt.debug.internal.model.IDLStackFrame;
import com.rsi.idldt.debug.internal.model.IDLValue;
import com.rsi.idldt.debug.internal.model.IDLVariableEditor;
import com.rsi.idldt.debug.internal.model.IDeleteVariable;
import com.rsi.idldt.debug.internal.model.IRenameVariable;
import com.rsi.jdml.IIDLVariableContainer;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementEditor;

public class IDLVariable
extends IDLDebugElement
implements IVariable,
IIDLVariableContainer,
Comparable,
IRenameVariable,
IDeleteVariable {
    public static final int VAR_IS_PARAM = 1;
    public static final int VAR_IS_READ_ONLY = 2;
    public static final int VAR_IS_INDEXABLE = 4;
    public static final int VAR_IS_COMMON_BLOCK = 8;
    public static final int VAR_HAS_CHANGED = 16;
    public static final int VAR_HAS_CHILD_CHANGED = 32;
    public static final int VAR_SHOULD_REDO_CHILD = 64;
    public static final int VARTYPE_UNDEF = 0;
    public static final int VARTYPE_BYTE = 1;
    public static final int VARTYPE_INT = 2;
    public static final int VARTYPE_LONG = 3;
    public static final int VARTYPE_FLOAT = 4;
    public static final int VARTYPE_DOUBLE = 5;
    public static final int VARTYPE_COMPLEX = 6;
    public static final int VARTYPE_STRING = 7;
    public static final int VARTYPE_STRUCT = 8;
    public static final int VARTYPE_DCOMPLEX = 9;
    public static final int VARTYPE_PTR = 10;
    public static final int VARTYPE_OBJREF = 11;
    public static final int VARTYPE_UINT = 12;
    public static final int VARTYPE_ULONG = 13;
    public static final int VARTYPE_LONG64 = 14;
    public static final int VARTYPE_ULONG64 = 15;
    public static final int ARRAY_VAL_PRINT_DIMS_CHILD = 4096;
    public static final int VAR_IS_CATEGORY = 8192;
    public static final int VAR_IS_ONE_ELEMENT_ARRAY = 16384;
    public static final String IDL_DE_TEMP_VAR_NAME = "_idlidetempvar_";
    public static final String IDL_DE_VAR_HELPINFO = "_idlidevarhelpinfo_";
    public static final String IDL_VARIABLE_BUILD_OBJECT = "__oIDLDT_PROJECT_BUILDER";
    public static final String IDL_VARIABLE_EXEC_SAVEFILE = "__oIDLDT_EXEC_SAVFILE";
    public static final String IDL_HIDE_PREFIX = "_idl_hidden_wbv_";
    protected static final String PRINT_DIMS_CHILD = "Print Dimensions";
    private int m_lastChangeIndex = -1;
    private String m_name;
    private IDLValue m_value;
    private int m_flags;
    private int m_numDims;
    private String m_arrayIndex;
    private String m_arrayValue;
    private String m_commonBlockName;
    private IIDLVariableContainer m_parent;
    private IDLVariableEditor variableEditor = new IDLVariableEditor();
    private boolean isRenaming;

    public static IDLVariable createIDLVariable(long debugID, String name, int flags, long cookie, int type, String value, int numDims, String arrayIndex, String arrayValue, String commonBlockName) {
        IIDLProcessProxy idl = IDLProcessManager.getProcessByID(debugID);
        IDLDebugTarget target = idl.getDebugTarget();
        IDLVariable v = new IDLVariable(target, name, flags, cookie, type, value, numDims, arrayIndex, arrayValue, commonBlockName);
        return v;
    }

    private IDLVariable(IDLDebugTarget target, String name, int flags, long cookie, int type, String value, int numDims, String arrayIndex, String arrayValue, String commonBlockName) {
        super(target);
        this.m_name = name;
        this.initializeValue(target, type, value, flags, cookie, numDims, arrayIndex, arrayValue, commonBlockName);
    }

    private void initializeValue(IDLDebugTarget target, int type, String value, int flags, long cookie, int numDims, String arrayIndex, String arrayValue, String commonBlockName) {
        String val;
        String[] tokens;
        String displayValue = value;
        this.m_flags = flags;
        this.m_numDims = numDims;
        this.m_arrayIndex = arrayIndex;
        this.m_arrayValue = arrayValue;
        this.m_commonBlockName = commonBlockName;
        boolean bArray = this.isArray();
        boolean bStruct = type == 8;
        boolean bIsOneElementArray = "Array[1]".equals(value);
        if (bIsOneElementArray) {
            this.m_flags |= 0x4000;
            if (arrayValue != null) {
                displayValue = arrayValue;
            }
        }
        this.m_value = new IDLValue(target, type, displayValue, cookie);
        if (bStruct && arrayValue == null && (tokens = (val = this.m_value.getValueString().trim()).split(" ", 3)).length > 1) {
            this.m_arrayValue = "{ " + tokens[1] + " }";
        }
        if (bArray && (flags & 0x1000) != 4096) {
            this.m_value.setIsArrayValue(this);
            String childValueName = PRINT_DIMS_CHILD;
            if (!this.isOneElementArray()) {
                String print_dims_default_value = this.m_value.getDefaultPrintDimensions();
                IDLVariable v = new IDLVariable(target, childValueName, 4096, -1L, 7, print_dims_default_value, numDims, arrayIndex, "", commonBlockName);
                this.addIDLVariable(v);
            }
        }
    }

    public void setParent(IIDLVariableContainer parent) {
        this.m_parent = parent;
    }

    public IDLVariable getParent() {
        if (this.m_parent instanceof IDLVariable) {
            return (IDLVariable)this.m_parent;
        }
        return null;
    }

    public int compareTo(Object obj1) {
        if (obj1 instanceof IDLVariable) {
            IDLVariable v1 = (IDLVariable)obj1;
            return this.getName().compareToIgnoreCase(v1.getName());
        }
        return 1;
    }

    public IValue getValue() {
        return this.m_value;
    }

    public boolean hasValueChanged() {
        boolean changed = this.getChangeCount() == this.m_debugTarget.getSuspendCount();
        return changed;
    }

    public String getName() {
        return this.m_name;
    }

    public String getParentQualifiedName() {
        IDLVariable p;
        String name = this.getName();
        if (this.m_parent != null && this.m_parent instanceof IDLVariable && (p = (IDLVariable)this.m_parent).isStructure()) {
            String parentName = null;
            if (p.getName().toLowerCase().startsWith("<objheapvar")) {
                if ((p = p.getParent()) != null) {
                    parentName = p.getParentQualifiedName();
                }
            } else if (p.getName().toLowerCase().startsWith("<ptrheapvar")) {
                if ((p = p.getParent()) != null) {
                    parentName = "(*" + p.getParentQualifiedName() + ")";
                }
            } else {
                parentName = p.getParentQualifiedName();
            }
            name = String.valueOf(parentName) + "." + name;
        }
        return name;
    }

    public String getCommonBlockName() {
        return this.m_commonBlockName;
    }

    public int getFlags() {
        return this.m_flags;
    }

    public int getType() {
        if (this.m_value == null) {
            return 0;
        }
        return this.m_value.getType();
    }

    public String getArrayIndex() {
        return this.m_arrayIndex;
    }

    public String getArrayValue() {
        return this.m_arrayValue;
    }

    public int getNumDims() {
        return this.m_numDims;
    }

    public String getUserPrintDims() {
        IDLVariable v = this.getIDLVariable(PRINT_DIMS_CHILD);
        String userPrintDims = null;
        try {
            userPrintDims = v.getValue().getValueString();
        }
        catch (DebugException debugException) {}
        return userPrintDims;
    }

    public String getReferenceTypeName() throws DebugException {
        if (this.m_value != null) {
            return this.m_value.getReferenceTypeName();
        }
        return null;
    }

    public void setValue(String expression) throws DebugException {
        this.m_value.setValueString(expression);
    }

    public void setValue(IValue value) throws DebugException {
        this.setValue(value.getValueString());
    }

    public boolean supportsValueModification() {
        if (this.isReadOnly()) {
            return false;
        }
        if (this.isArray() && !this.isOneElementArray()) {
            return false;
        }
        if (this.isStructure()) {
            return false;
        }
        if (this.isCategory()) {
            return false;
        }
        if (this.m_value.hasVariables()) {
            return false;
        }
        return !this.hasHeapParent();
    }

    public boolean verifyValue(String expression) throws DebugException {
        Tracer.trace(Tracer.TRACE_DEBUG_MODEL2, "=NYI IDLVariable::verifyValue returns true");
        return true;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return this.verifyValue(value.getValueString());
    }

    public void addIDLVariable(IDLVariable var) {
        this.m_value.addIDLVariable(var);
    }

    public IDLVariable[] getIDLVariables() {
        return this.m_value.getIDLVariables();
    }

    public IDLVariable getIDLVariable(String name) {
        return this.m_value.getIDLVariable(name);
    }

    protected void setChangeCount(int count) {
        this.m_lastChangeIndex = count;
    }

    protected int getChangeCount() {
        return this.m_lastChangeIndex;
    }

    public boolean isCommonBlock() {
        return (this.m_flags & 8) != 0;
    }

    public boolean isIndexable() {
        return (this.m_flags & 4) != 0;
    }

    public boolean isParam() {
        return (this.m_flags & 1) != 0;
    }

    public boolean isReadOnly() {
        return (this.m_flags & 2) != 0;
    }

    public boolean isArray() {
        return (this.m_flags & 4) != 0;
    }

    public boolean isOneElementArray() {
        return (this.m_flags & 0x4000) != 0;
    }

    public boolean isStructure() {
        return this.m_value.getType() == 8;
    }

    public boolean isPointer() {
        return this.m_value.getType() == 10;
    }

    public boolean isObjref() {
        return this.m_value.getType() == 11;
    }

    public boolean hasChildChanged() {
        return (this.m_flags & 0x20) != 0;
    }

    public boolean isHeapref() {
        int type = this.m_value.getType();
        return type == 10 || type == 11;
    }

    public boolean hasHeapParent() {
        IDLVariable var = this;
        while (var != null) {
            if (var.getName().charAt(0) == '<') {
                return true;
            }
            var = var.getParent();
        }
        return false;
    }

    public boolean hasChanged() {
        return (this.m_flags & 0x10) != 0;
    }

    public boolean shouldRedoChild() {
        return (this.m_flags & 0x40) != 0;
    }

    public void handleVariableChanged(IDLVariable changedVar) {
        boolean changed = false;
        if (changedVar.hasChanged() || changedVar.hasChildChanged()) {
            this.setChangeCount(this.m_debugTarget.getSuspendCount());
        }
        if (changedVar.hasChanged()) {
            this.m_value = (IDLValue)changedVar.getValue();
            this.m_flags = changedVar.m_flags;
            this.m_numDims = changedVar.m_numDims;
            this.m_arrayIndex = changedVar.m_arrayIndex;
            this.m_arrayValue = changedVar.m_arrayValue;
            this.m_commonBlockName = changedVar.m_commonBlockName;
            if (this.isArray() && !this.isOneElementArray() && (this.m_flags & 0x1000) != 4096) {
                String printDimsVar = PRINT_DIMS_CHILD;
                String print_dims_default_value = this.m_value.getDefaultPrintDimensions();
                IDLVariable v = new IDLVariable(this.getIDLDebugTarget(), printDimsVar, 4096, -1L, 7, print_dims_default_value, this.m_numDims, this.m_arrayIndex, "", this.m_commonBlockName);
                this.addIDLVariable(v);
            }
            changed = true;
        } else {
            if (changedVar.shouldRedoChild()) {
                this.m_value.removeAllChildren();
            }
            if (changedVar.hasChildChanged()) {
                IDLVariable[] newVars = changedVar.getIDLVariables();
                int i = 0;
                while (i < newVars.length) {
                    String newName = newVars[i].getName();
                    IDLVariable matchingVar = this.getIDLVariable(newName);
                    if (matchingVar == null) {
                        this.addIDLVariable(newVars[i]);
                        changed = true;
                    } else {
                        matchingVar.handleVariableChanged(newVars[i]);
                    }
                    ++i;
                }
            }
        }
        if (changed) {
            this.fireChangeEvent(512);
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IElementEditor.class)) {
            return this.variableEditor;
        }
        Object retVal = null;
        retVal = super.getAdapter(adapter);
        Tracer.trace(Tracer.TRACE_DEBUG_MODEL_ADAPTERS, "=IDLVariable:getAdapter(" + adapter + ") --> returns " + retVal);
        return retVal;
    }

    public void dumpRecursively(String spacing) {
        System.out.println(String.valueOf(spacing) + this);
        this.m_value.dumpRecursively(String.valueOf(spacing) + "  ");
    }

    public String toString() {
        return "IDLVariable [" + this.m_name + "=" + this.m_value.getValueString() + "]";
    }

    public static void printVarChangedDiagnostic(IDLVariable v) {
        System.out.print("Var=" + v + " changed:");
        if (v.hasChanged()) {
            System.out.print("changed, ");
        }
        if (v.shouldRedoChild()) {
            System.out.print("redo child, ");
        }
        if (v.hasChildChanged()) {
            System.out.print("child changed, ");
        }
        System.out.println(")");
    }

    public void setChildChanged() {
        this.m_flags |= 0x20;
        this.setChangeCount(this.m_debugTarget.getSuspendCount());
    }

    public void setReadOnly() {
        this.m_flags |= 2;
    }

    public void setVarIsCategory() {
        this.m_flags |= 0x2000;
    }

    public boolean isCategory() {
        return (this.m_flags & 0x2000) != 0;
    }

    public static boolean isVariableHidden(String variableName) {
        if (variableName.equalsIgnoreCase(IDL_DE_TEMP_VAR_NAME) || variableName.equalsIgnoreCase(IDL_DE_VAR_HELPINFO) || variableName.equalsIgnoreCase(IDL_VARIABLE_BUILD_OBJECT) || variableName.equalsIgnoreCase(IDL_VARIABLE_EXEC_SAVEFILE)) {
            return true;
        }
        return variableName.toLowerCase().startsWith(IDL_HIDE_PREFIX);
    }

    public void setName(String name) {
        this.getIDLProcess().getCommandManager().renameVariable(this.m_name, name);
        this.m_name = name;
    }

    public boolean supportsRename() {
        return this.canBeRenamedOrDeleted();
    }

    public boolean canBeRenamedOrDeleted() {
        if (this.m_debugTarget == null || this.m_debugTarget.getThread() == null || this.m_debugTarget.getThread().isDebugging()) {
            return false;
        }
        if (this.getParent() != null) {
            return false;
        }
        if (this.isSystemVariable()) {
            return false;
        }
        if (this.isCommonBlock()) {
            return false;
        }
        return !this.isSpecialPlaceholder();
    }

    public boolean isSpecialPlaceholder() {
        return this.m_name.equals(IDLStackFrame.SYSTEM_VARIABLES_CATEGORY) || this.m_name.startsWith(IDLStackFrame.COMMON_BLOCK_CATEGORY_PREFIX) || this.m_name.equals(PRINT_DIMS_CHILD);
    }

    private boolean isSystemVariable() {
        return this.m_name.startsWith("!");
    }

    public boolean verifyName(String name) {
        if (name == null) {
            return false;
        }
        String trimmedName = name.trim();
        if (trimmedName.length() == 0 || trimmedName.equals(this.m_name)) {
            return false;
        }
        if (Character.isDigit(trimmedName.charAt(0))) {
            return false;
        }
        char[] chars = new char[trimmedName.length()];
        trimmedName.getChars(0, trimmedName.length(), chars, 0);
        int i = 0;
        while (i < chars.length) {
            if (!Character.isLetterOrDigit(chars[i]) && chars[i] != '_') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void deleteVariable() {
        this.getIDLProcess().getCommandManager().deleteVariable(this.m_name);
    }

    public boolean supportsDelete() {
        return this.canBeRenamedOrDeleted();
    }

    public boolean isRenaming() {
        return this.isRenaming;
    }

    public void setRenaming(boolean b) {
        this.isRenaming = b;
    }
}

