/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.debug.internal.model;

import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.core.Messages;
import com.rsi.idldt.core.internal.interp.commands.SilentExecuteStringCommand;
import com.rsi.idldt.core.interp.AbstractIDLCommand;
import com.rsi.idldt.core.interp.SimpleCommandListener;
import com.rsi.idldt.core.utils.Tracer;
import com.rsi.idldt.debug.internal.model.IDLDebugElement;
import com.rsi.idldt.debug.internal.model.IDLDebugTarget;
import com.rsi.idldt.debug.internal.model.IDLVariable;
import com.rsi.jdml.DMLAccess;
import com.rsi.jdml.IIDLVariableContainer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDLValue
extends IDLDebugElement
implements IValue,
IIDLVariableContainer {
    private int m_type;
    private String m_value;
    private boolean m_hasVariables;
    private Map<String, IDLVariable> m_vars;
    private long m_cookie;
    private boolean m_isArrayValue = false;
    private IDLVariable m_arrayVariable;
    private String m_dimensions;
    private long m_lastDetailPaneStringTime = 0L;
    private String m_lastDetailPaneString;

    public IDLValue(IDLDebugTarget target, int type, String value, long cookie) {
        super(target);
        this.m_type = type;
        this.m_hasVariables = false;
        this.m_cookie = cookie;
        this.setRawValueString(value);
    }

    public long getCookie() {
        return this.m_cookie;
    }

    public void setIsArrayValue(IDLVariable v) {
        this.m_isArrayValue = true;
        this.m_arrayVariable = v;
    }

    public boolean isArrayValue() {
        return this.m_isArrayValue;
    }

    public String getReferenceTypeName() throws DebugException {
        if (this.getType() >= 0) {
            String typename = com.rsi.jdml.IDLVariable.getTypeName(this.getType());
            if (this.m_dimensions != null) {
                typename = String.valueOf(typename) + this.m_dimensions;
            } else if (this.m_arrayVariable != null && this.m_arrayVariable.isOneElementArray()) {
                typename = String.valueOf(typename) + "[1]";
            }
            return typename;
        }
        return null;
    }

    public String getValueString() {
        return this.m_value;
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() throws DebugException {
        Map<String, IDLVariable> map = this.getVariablesAsMap();
        Collection<IDLVariable> c = map.values();
        if (c == Collections.EMPTY_SET) {
            return new IVariable[0];
        }
        return c.toArray(new IVariable[this.m_vars.size()]);
    }

    public boolean hasVariables() {
        return this.m_hasVariables;
    }

    @Override
    public void addIDLVariable(IDLVariable v) {
        this.m_hasVariables = true;
        if (this.m_vars == null) {
            this.m_vars = new TreeMap<String, IDLVariable>();
        }
        this.m_vars.put(v.getName(), v);
    }

    public void removeAllChildren() {
        this.m_hasVariables = false;
        if (this.m_vars != null) {
            this.m_vars.clear();
        }
    }

    @Override
    public IDLVariable getIDLVariable(String name) {
        if (this.m_vars == null) {
            return null;
        }
        return this.m_vars.get(name);
    }

    @Override
    public IDLVariable[] getIDLVariables() {
        Map<String, IDLVariable> map = this.getVariablesAsMap();
        Collection<IDLVariable> c = map.values();
        if (c == Collections.EMPTY_SET) {
            return new IDLVariable[0];
        }
        return c.toArray(new IDLVariable[map.size()]);
    }

    protected synchronized Map<String, IDLVariable> getVariablesAsMap() {
        if (this.m_vars != null) {
            return this.m_vars;
        }
        return Collections.emptyMap();
    }

    public void setValueString(String theExpression) {
        String expression = theExpression;
        Tracer.trace(Tracer.TRACE_DEBUG_MODEL2, "=IDLValue::setValueString(" + expression + ")");
        if (this.m_cookie != -1L) {
            this.getIDLProcess().getCommandManager().setVariableValue(this.m_cookie, expression);
            this.m_value = expression;
        } else {
            if (expression == null || expression.trim().length() == 0) {
                expression = "";
            }
            this.m_value = expression;
            this.forceModelUpdate();
        }
    }

    private void setRawValueString(String value) {
        this.m_value = value;
        if (this.getType() == 8) {
            String val = this.m_value.trim();
            int arrayIndex = val.indexOf("Array[");
            if (val.startsWith("-> ") && arrayIndex > 0) {
                this.m_value = "{ " + val.substring(3, arrayIndex) + " }";
                String arrayDims = val.substring(arrayIndex + 5);
                if (!"[1]".equals(arrayDims)) {
                    this.m_dimensions = arrayDims;
                    this.m_value = String.valueOf(this.m_value) + ' ' + this.m_dimensions;
                }
                return;
            }
        }
        if (this.m_value.startsWith("Array")) {
            this.m_dimensions = this.m_value.substring(5);
            if (!"[1]".equals(this.m_dimensions)) {
                try {
                    this.m_value = this.getReferenceTypeName();
                }
                catch (DebugException debugException) {}
                return;
            }
        }
        switch (this.getType()) {
            case 6: 
            case 9: {
                this.m_value = this.m_value.replaceAll(" +", " ");
                break;
            }
            case 7: {
                break;
            }
            default: {
                this.m_value = this.m_value.trim();
            }
        }
    }

    public boolean equals(Object obj) {
        Tracer.trace(Tracer.TRACE_DEBUG_MODEL2, "=IDLValue::equals");
        return obj instanceof IDLValue && ((IDLValue)obj).m_value.equals(this.m_value);
    }

    public int hashCode() {
        return this.m_value.hashCode();
    }

    public int getType() {
        return this.m_type;
    }

    protected void forceModelUpdate() {
        String tempVar = "_idlidetempvar_";
        SimpleCommandListener l = new SimpleCommandListener();
        IIDLProcessProxy idlProcess = this.getIDLProcess();
        String cmd = String.valueOf(tempVar) + " = 1";
        SilentExecuteStringCommand c = new SilentExecuteStringCommand(cmd);
        c.addCommandListener(l);
        c.setUpdateDebugModel(true);
        idlProcess.getCommandManager().queueCommand(c);
    }

    public String toString() {
        return "IDLValue [ty=" + this.getType() + " val=" + this.getValueString() + " hasChildren=" + this.m_hasVariables + "]";
    }

    public String getDetailPaneString() {
        if (this.isArrayValue() && this.m_arrayVariable != null && !this.m_arrayVariable.isOneElementArray()) {
            com.rsi.jdml.IDLVariable v;
            long current = System.currentTimeMillis();
            if (current - this.m_lastDetailPaneStringTime < 500L) {
                this.m_lastDetailPaneStringTime = System.currentTimeMillis();
                return this.m_lastDetailPaneString;
            }
            String printDims = this.m_arrayVariable.getUserPrintDims();
            if (printDims == null || printDims.trim().length() == 0) {
                printDims = this.getDefaultPrintDimensions();
            }
            if (!printDims.startsWith("[")) {
                printDims = "[" + printDims;
            }
            if (!printDims.endsWith("]")) {
                printDims = String.valueOf(printDims) + "]";
            }
            if ((v = this.runIDLPrintCommand(printDims)) == null) {
                return "";
            }
            String finalString = "";
            if ((finalString = String.valueOf(finalString) + v.getString()).equalsIgnoreCase("null") && v.getType() == 0) {
                finalString = Messages.IDLValue_ArrayPrintDimsErr;
            }
            this.m_lastDetailPaneString = finalString;
            return finalString;
        }
        this.m_lastDetailPaneStringTime = System.currentTimeMillis();
        return this.getValueString();
    }

    public com.rsi.jdml.IDLVariable runIDLPrintCommand(String printDims) {
        GetArrayValue idlCmd = new GetArrayValue(this.m_arrayVariable, printDims);
        IIDLProcessProxy idl = IDLProcessManager.getActiveProcess();
        idl.queueCommand(idlCmd);
        while (!idlCmd.hasFinished()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                break;
            }
        }
        this.m_lastDetailPaneStringTime = System.currentTimeMillis();
        if (!idlCmd.isValidResults()) {
            idlCmd.result.setUnsupportedType(0);
        }
        return idlCmd.result;
    }

    public long[] getDimensions() {
        if (this.m_arrayVariable != null && this.m_arrayVariable.isOneElementArray()) {
            long[] result = new long[]{1L};
            return result;
        }
        if (this.m_dimensions == null || this.m_dimensions.length() == 0) {
            return null;
        }
        int i = this.m_dimensions.indexOf(91);
        String s = this.m_dimensions.substring(i + 1);
        i = s.lastIndexOf(93);
        s = s.substring(0, i);
        String[] dims = s.split(",");
        long[] result = new long[dims.length];
        int j = 0;
        while (j < dims.length) {
            result[j] = Long.parseLong(dims[j].trim());
            ++j;
        }
        return result;
    }

    public String getDefaultPrintDimensions() {
        long[] dims = this.getDimensions();
        if (dims == null || dims.length == 0) {
            return "";
        }
        int maxBinAmount = 100;
        String s = "[";
        int num_dims = dims.length;
        int binAmount = 1;
        int i = 0;
        while (i < num_dims) {
            long d = dims[i];
            while (d > 0L) {
                if (d * (long)binAmount <= (long)maxBinAmount) break;
                --d;
            }
            d = d <= 0L ? 1L : d;
            binAmount = (int)((long)binAmount * d);
            s = String.valueOf(s) + "0:" + Long.toString(d - 1L) + ",";
            ++i;
        }
        i = s.lastIndexOf(44);
        s = s.subSequence(0, i) + "]";
        return s;
    }

    public void dumpRecursively(String spacing) {
        System.out.println(String.valueOf(spacing) + this);
        IDLVariable[] vars = this.getIDLVariables();
        int i = 0;
        while (i < vars.length) {
            vars[i].dumpRecursively(String.valueOf(spacing) + "  ");
            ++i;
        }
    }

    private static class GetArrayValue
    extends AbstractIDLCommand {
        volatile com.rsi.jdml.IDLVariable result = null;
        IDLVariable m_arrayVariable;
        String m_printDims;
        private volatile boolean m_finished = false;
        private volatile boolean m_bValidResults = false;

        public GetArrayValue(IDLVariable arrayVariable, String printDims) {
            this.m_arrayVariable = arrayVariable;
            this.m_printDims = printDims;
            this.setUpdateDebugModel(false);
        }

        public void activate(IIDLProcessProxy idl) {
            idl.getLogWindowHandler().setSuppressOutput(true);
            String cmd = "_idlidetempvar_ = 'null'";
            DMLAccess.silentExecuteString(idl.getDebugID(), cmd);
            cmd = "_idlidetempvar_ = strjoin(string(" + this.m_arrayVariable.getParentQualifiedName() + this.m_printDims + ", /print), 13b) ;<!--VWWEval-->";
            DMLAccess.silentExecuteString(idl.getDebugID(), cmd);
            this.result = new com.rsi.jdml.IDLVariable();
            DMLAccess.getIDLVariable(idl.getDebugID(), "_idlidetempvar_", this.result);
            cmd = "_idlidevarhelpinfo_=0b & help, " + this.m_arrayVariable.getParentQualifiedName() + this.m_printDims + ", output=" + "_idlidevarhelpinfo_" + " & " + "_idlidevarhelpinfo_" + " = (" + "_idlidevarhelpinfo_" + "[0] ne '')";
            DMLAccess.silentExecuteString(idl.getDebugID(), cmd);
            com.rsi.jdml.IDLVariable helpinfo = new com.rsi.jdml.IDLVariable();
            DMLAccess.getIDLVariable(idl.getDebugID(), "_idlidevarhelpinfo_", helpinfo);
            this.m_bValidResults = helpinfo.getValue() == null ? false : helpinfo.getValue().equals(new Byte(1));
            try {
                Thread.sleep(500L);
                idl.getLogWindowHandler().setSuppressOutput(false);
            }
            catch (InterruptedException interruptedException) {}
            this.m_finished = true;
        }

        public boolean isValidResults() {
            return this.m_bValidResults;
        }

        public boolean hasFinished() {
            return this.m_finished;
        }

        public boolean shouldReplaceDuplicate() {
            return true;
        }
    }
}

