/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.debug.internal.model;

import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.core.ResponseManager;
import com.rsi.idldt.core.internal.CommandManager;
import com.rsi.idldt.core.internal.interp.commands.SilentExecuteStringCommand;
import com.rsi.idldt.core.internal.interp.commands.UpdateDebugModelCommand;
import com.rsi.idldt.core.interp.IInterpreterCommands;
import com.rsi.idldt.core.interp.SimpleCommandListener;
import com.rsi.idldt.debug.internal.model.IDLBreakpointManager;
import com.rsi.idldt.debug.internal.model.IDLDebugElement;
import com.rsi.idldt.debug.internal.model.IDLDebugTarget;
import com.rsi.idldt.debug.internal.model.IDLStackFrame;
import com.rsi.jdml.HeapVariableDTO;
import com.rsi.jdml.StackFramesDTO;
import com.rsi.jdml.SystemVariableDTO;
import java.util.Collections;
import java.util.Vector;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;

public class IDLThread
extends IDLDebugElement
implements IThread {
    private int m_suspendCount = 0;
    private Vector<IDLStackFrame> m_frames = new Vector(10);
    public static final int IDLE = 1;
    public static final int RUNNING = 2;
    public static final int SUSPENDED = 3;
    private int m_state = 1;
    private boolean m_isStepping = false;
    private boolean m_isTerminating;
    private boolean m_bRunTimeErrorOccurred;
    private IBreakpoint m_currentBreakpoint;

    public IDLThread(IDLDebugTarget target) {
        super(target);
    }

    public synchronized IStackFrame[] getStackFrames() {
        return this.getIDLStackFrames();
    }

    public boolean hasStackFrames() {
        return this.isSuspended() || this.isStepping();
    }

    public int getPriority() {
        return 0;
    }

    public IStackFrame getTopStackFrame() {
        return this.getTopIDLStackFrame();
    }

    public String getName() {
        return "IDL thread";
    }

    public IBreakpoint[] getBreakpoints() {
        IBreakpoint[] bkpts = this.m_currentBreakpoint != null ? new IBreakpoint[]{this.m_currentBreakpoint} : new IBreakpoint[]{};
        return bkpts;
    }

    public boolean canResume() {
        return this.m_state == 3;
    }

    public boolean canSuspend() {
        return this.m_state == 2;
    }

    public boolean isSuspended() {
        return this.m_state == 1 || this.m_state == 3;
    }

    public void resume() throws DebugException {
        this.m_isStepping = false;
        this.getIDLProcess().queueSilentExecuteString(".continue");
    }

    public void suspend() throws DebugException {
        this.getIDLProcess().requestAbort();
    }

    public boolean isDebugging() {
        IDLStackFrame frame = this.getTopIDLStackFrame();
        if (frame != null && frame.getLevel() > 1) {
            return true;
        }
        frame = this.getMainIDLStackFrame();
        return frame != null && frame.getLineNumber() > 0;
    }

    private void setState(int newState) {
        this.m_state = newState;
        switch (this.m_state) {
            case 1: {
                this.m_debugTarget.notifyOfTerminate();
                break;
            }
            case 2: {
                this.m_debugTarget.notifyOfResume();
                break;
            }
            case 3: {
                this.m_debugTarget.notifyOfSuspend();
                break;
            }
        }
    }

    public int getThreadState() {
        return this.m_state;
    }

    private void setSuspendState() {
        this.setState(this.isDebugging() ? 3 : 1);
    }

    public boolean canStepInto() {
        return this.m_state == 3;
    }

    public void stepInto() throws DebugException {
        this.m_isStepping = true;
        this.getIDLProcess().queueSilentExecuteString(".step");
    }

    public boolean canStepOver() {
        return this.m_state == 3;
    }

    public void stepOver() throws DebugException {
        this.m_isStepping = true;
        this.getIDLProcess().queueSilentExecuteString(".stepover");
    }

    public boolean canStepReturn() {
        return this.m_state == 3;
    }

    public void stepReturn() throws DebugException {
        this.m_isStepping = true;
        this.getIDLProcess().queueSilentExecuteString(".out");
    }

    public boolean isStepping() {
        return this.m_isStepping;
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return false;
    }

    public void terminate() throws DebugException {
        long time;
        if (this.m_isTerminating) {
            return;
        }
        this.m_isTerminating = true;
        IIDLProcessProxy idl = this.getIDLProcess();
        ResponseManager rm = idl.getResponseManager();
        if (idl.getDebugID() == 0L || rm != null && rm.exitDoneSeen()) {
            this.m_isTerminating = false;
            return;
        }
        idl.requestAbort();
        String c = "Retall";
        SilentExecuteStringCommand cmd = new SilentExecuteStringCommand(c);
        SimpleCommandListener l = new SimpleCommandListener();
        cmd.addCommandListener(l);
        idl.queueCommand(cmd);
        for (time = 0L; time < 1000L && idl.getDebugID() != 0L && !l.hasFinished(); time += 20L) {
            try {
                Thread.sleep(20L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                break;
            }
        }
        if (idl.getDebugID() == 0L) {
            this.m_isTerminating = false;
            return;
        }
        c = "Widget_Control,/RESET & Close,/FORCE,/ALL & Heap_gc";
        cmd = new SilentExecuteStringCommand(c);
        l = new SimpleCommandListener();
        cmd.addCommandListener(l);
        idl.queueCommand(cmd);
        for (time = 0L; time < 4000L && idl.getDebugID() != 0L && !l.hasFinished(); time += 20L) {
            try {
                Thread.sleep(20L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                break;
            }
        }
        this.m_isTerminating = false;
    }

    public synchronized IDLStackFrame[] getIDLStackFrames() {
        Vector reversed = (Vector)this.m_frames.clone();
        Collections.reverse(reversed);
        return reversed.toArray(new IDLStackFrame[this.m_frames.size()]);
    }

    public IDLStackFrame getIDLStackFrame(String frameName) {
        IDLStackFrame[] frames = this.getIDLStackFrames();
        int i = 0;
        while (i < frames.length) {
            if (frameName.equalsIgnoreCase(frames[i].getName())) {
                return frames[i];
            }
            ++i;
        }
        return null;
    }

    public IDLStackFrame getTopIDLStackFrame() {
        int size = this.m_frames.size();
        if (size == 0) {
            return null;
        }
        return this.m_frames.get(size - 1);
    }

    public IDLStackFrame getMainIDLStackFrame() {
        return this.m_frames.size() == 0 ? null : this.m_frames.get(0);
    }

    private synchronized IDLStackFrame getIDLStackFrameByLevel(int level) {
        return this.m_frames.get(level - 1);
    }

    private synchronized void setIDLStackFrameByLevel(int level, IDLStackFrame dto) {
        dto.categorizeCommonBlockVariables();
        this.m_frames.set(level - 1, dto);
    }

    public int getSuspendCount() {
        return this.m_suspendCount;
    }

    public void incrementSuspendCount() {
        ++this.m_suspendCount;
    }

    public synchronized void suspendDebugModel(StackFramesDTO frames, SystemVariableDTO sysVars, HeapVariableDTO heapVars) {
        this.incrementSuspendCount();
        this.handleStackFrameChange(frames);
        this.handleHeapVariableChange(heapVars);
        this.handleSystemVariableChange(sysVars);
        this.setSuspendState();
        if (this.m_bRunTimeErrorOccurred) {
            this.fireSuspendEvent(16);
            this.m_bRunTimeErrorOccurred = false;
        } else if (this.m_currentBreakpoint != null) {
            this.m_isStepping = false;
            this.fireSuspendEvent(16);
        } else if (this.isStepping()) {
            this.m_isStepping = false;
            this.fireSuspendEvent(8);
        } else {
            this.fireSuspendEvent(8);
        }
        this.m_debugTarget.purgeRunToLineBreakpoint();
    }

    public synchronized void handleInterpreterStopped(String filename, String module, int line, int err) {
        this.m_currentBreakpoint = IDLBreakpointManager.findByFileLine(this.m_debugTarget, filename, line);
        this.m_bRunTimeErrorOccurred = err != 0;
        CommandManager cm = this.getCommandManager();
        if (cm != null && !cm.isExecutingCommand()) {
            this.getIDLProcess().queueCommand(new UpdateDebugModelCommand());
        }
    }

    public void commandStarted() {
        CommandManager cm = this.getCommandManager();
        if (cm != null && !cm.isCurrentCommandUpdatingDebugModel()) {
            return;
        }
        this.setState(2);
        this.fireResumeEvent(32);
        this.m_currentBreakpoint = null;
    }

    public void commandFinished() {
    }

    private synchronized void handleStackFrameChange(StackFramesDTO frames) {
        if (!frames.hasChanged()) {
            return;
        }
        int newTotal = frames.getTotal();
        int oldTotal = this.m_frames.size();
        this.m_frames.setSize(newTotal);
        if (newTotal == 0) {
            return;
        }
        for (IDLStackFrame dto : frames) {
            int level = dto.getLevel();
            String name = dto.getName();
            IDLStackFrame oldFrame = null;
            if (level <= oldTotal) {
                oldFrame = this.getIDLStackFrameByLevel(level);
            }
            if (oldFrame != null && !oldFrame.getName().equalsIgnoreCase(name)) {
                oldFrame = null;
            }
            if (oldFrame == null) {
                this.setIDLStackFrameByLevel(level, dto);
                continue;
            }
            oldFrame.handleDataUpdate(dto);
        }
    }

    private synchronized void handleSystemVariableChange(SystemVariableDTO dto) {
        this.m_debugTarget.handleSystemVariableChange(dto);
        int i = 0;
        while (i < this.m_frames.size()) {
            IDLStackFrame f = this.m_frames.get(i);
            f.handleSystemVariableChange(dto);
            ++i;
        }
    }

    private synchronized void handleHeapVariableChange(HeapVariableDTO dto) {
        IDLStackFrame mainSF = this.getMainIDLStackFrame();
        if (mainSF != null) {
            mainSF.handleHeapVariableChange(dto);
        }
    }

    public Object getAdapter(Class adapter) {
        Object retVal = null;
        retVal = super.getAdapter(adapter);
        return retVal;
    }

    private CommandManager getCommandManager() {
        IInterpreterCommands ic = this.getIDLProcess().getCommandManager();
        CommandManager cm = null;
        if (ic instanceof CommandManager) {
            cm = (CommandManager)ic;
        }
        return cm;
    }

    public String toString() {
        String state;
        switch (this.m_state) {
            case 1: {
                state = "IDLE";
                break;
            }
            case 2: {
                state = "RUNNING";
                break;
            }
            case 3: {
                state = "SUSPENDED";
                break;
            }
            default: {
                state = "BAD STATE";
            }
        }
        return "IDLThread: state = " + state + "; suspendCount = " + this.m_suspendCount;
    }
}

