/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.debug.internal.model;

import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.core.Messages;
import com.rsi.idldt.core.utils.Tracer;
import com.rsi.idldt.debug.internal.model.IDLDebugElement;
import com.rsi.idldt.debug.internal.model.IDLDebugTarget;
import com.rsi.idldt.debug.internal.model.IDLVariable;
import com.rsi.jdml.HeapVariableDTO;
import com.rsi.jdml.IIDLVariableContainer;
import com.rsi.jdml.SystemVariableDTO;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;

public class IDLStackFrame
extends IDLDebugElement
implements IStackFrame,
IIDLVariableContainer {
    public static final int FRAME_HAS_ROUTINE_CHANGED = 1;
    public static final int FRAME_HAS_FILE_CHANGED = 2;
    public static final int FRAME_HAS_LINENUM_CHANGED = 4;
    public static final int FRAME_HAS_VARINFO_CHANGED = 8;
    public static final String SYSTEM_VARIABLES_CATEGORY = String.valueOf(' ') + Messages.IDLStackFrame_SystemVariable;
    public static final String COMMON_BLOCK_CATEGORY_PREFIX = String.valueOf(' ') + Messages.IDLStackFrame_CommonVariable;
    private String m_name;
    private int m_lineno;
    private Map<String, IDLVariable> m_vars;
    private Map<String, IDLVariable> m_heapvars;
    private Map<String, IDLVariable> m_commonBlocks = Collections.synchronizedSortedMap(new TreeMap());
    private String m_filePath;
    private String m_fileName;
    private int m_level;
    private int m_flags;

    private IDLStackFrame(IDLDebugTarget target, String name, String file, int line_no, int level, int flags) {
        super(target);
        this.m_vars = Collections.synchronizedSortedMap(new TreeMap());
        this.m_heapvars = Collections.synchronizedSortedMap(new TreeMap());
        this.m_name = name;
        this.m_lineno = line_no;
        this.m_filePath = file;
        this.m_fileName = file != null ? new Path(file).lastSegment() : null;
        this.m_level = level;
        this.m_flags = flags;
        Tracer.trace(Tracer.TRACE_DEBUG_MODEL2, "IDLStackFrame::ctor target=" + target);
    }

    public static IDLStackFrame createIDLStackFrame(long debugID, String name, String file, int line_no, int level, int flags) {
        IIDLProcessProxy idl = IDLProcessManager.getProcessByID(debugID);
        IDLDebugTarget target = idl.getDebugTarget();
        IDLStackFrame sf = new IDLStackFrame(target, name, file, line_no, level, flags);
        return sf;
    }

    private IDLVariable getCategoryVariable(String name) {
        IIDLProcessProxy p = this.getIDLProcess();
        int type = -1;
        IDLVariable var = IDLVariable.createIDLVariable(p.getDebugID(), name, 0, 0L, type, "", 0, null, null, null);
        var.setVarIsCategory();
        return var;
    }

    protected void buildFramesListOfSystemVariables() {
        IDLVariable[] sysvars = this.m_debugTarget.getSystemVariables();
        if (sysvars.length <= 0) {
            return;
        }
        IDLVariable sysVarCategory = this.getCategoryVariable(SYSTEM_VARIABLES_CATEGORY);
        int i = 0;
        while (i < sysvars.length) {
            sysVarCategory.addIDLVariable(sysvars[i]);
            ++i;
        }
        this.m_vars.put(sysVarCategory.getName(), sysVarCategory);
    }

    public boolean canStepInto() {
        return this.getThread().canStepInto();
    }

    public boolean canStepOver() {
        return this.getThread().canStepOver();
    }

    public boolean canStepReturn() {
        return this.getThread().canStepReturn();
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public void stepInto() throws DebugException {
        this.getThread().stepInto();
    }

    public void stepOver() throws DebugException {
        this.getThread().stepOver();
    }

    public void stepReturn() throws DebugException {
        this.getThread().stepReturn();
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    public void suspend() throws DebugException {
        this.getThread().suspend();
    }

    public boolean canTerminate() {
        return this.getThread().canTerminate();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getThread().terminate();
    }

    public IThread getThread() {
        return this.m_debugTarget.getThread();
    }

    public IVariable[] getVariables() throws DebugException {
        Tracer.trace(Tracer.TRACE_DEBUG_MODEL2, "=IDLStackFrame:getVariables");
        Tracer.trace(Tracer.TRACE_DEBUG_MODEL2, "S.F = " + this.m_name + " Num Vars = " + this.m_vars.size());
        return this.m_vars.values().toArray(new IVariable[this.m_vars.size()]);
    }

    public boolean hasVariables() {
        boolean retVal = false;
        if (this.m_vars != null) {
            retVal = this.m_vars.size() > 0;
        }
        return retVal;
    }

    public int getLineNumber() {
        return this.m_lineno > 0 ? this.m_lineno : -1;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return null;
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public IDLVariable[] getIDLVariables() {
        return this.m_vars.values().toArray(new IDLVariable[this.m_vars.size()]);
    }

    public void addIDLVariable(IDLVariable var) {
        this.m_vars.put(var.getName(), var);
    }

    public void removeIDLVariable(String name) {
        IDLVariable v = this.m_vars.get(name.toUpperCase());
        if (v != null) {
            this.m_vars.remove(name.toUpperCase());
        }
    }

    public void removeAllVariablesInStackFrame() {
        this.m_commonBlocks.clear();
        this.m_heapvars.clear();
        this.m_vars.clear();
        this.fireChangeEvent(512);
    }

    public IDLVariable getIDLVariable(String name) {
        IDLVariable v = this.m_vars.get(name.toUpperCase());
        if (v != null) {
            return v;
        }
        Collection<IDLVariable> values = this.m_commonBlocks.values();
        for (IDLVariable element : values) {
            v = element.getIDLVariable(name.toUpperCase());
            if (v == null) continue;
            return v;
        }
        IDLVariable systemVars = this.m_vars.get(SYSTEM_VARIABLES_CATEGORY);
        return systemVars.getIDLVariable(name.toUpperCase());
    }

    public IDLVariable getIDLHeapVariable(String name) {
        IDLVariable heapvar = this.m_heapvars.get(name);
        return heapvar;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getFilePath() {
        return this.m_filePath;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public int getLevel() {
        return this.m_level;
    }

    public boolean hasRoutineChanged() {
        return (this.m_flags & 1) == 1;
    }

    public boolean hasFileChanged() {
        return (this.m_flags & 2) == 2;
    }

    public boolean hasLineChanged() {
        return (this.m_flags & 4) == 4;
    }

    public boolean haveVariablesChanged() {
        return (this.m_flags & 8) == 8;
    }

    public void handleDataUpdate(IDLStackFrame changedSF) {
        boolean changed = false;
        try {
            if (changedSF.hasFileChanged()) {
                this.m_filePath = changedSF.getFilePath();
                this.m_fileName = changedSF.getFileName();
                changed = true;
            }
            if (changedSF.hasLineChanged()) {
                this.m_lineno = changedSF.getLineNumber();
            }
            if (changedSF.haveVariablesChanged()) {
                IDLVariable[] changedVars = changedSF.getIDLVariables();
                int i = 0;
                while (i < changedVars.length) {
                    IDLVariable changed_var = changedVars[i];
                    if (changed_var.isCommonBlock()) {
                        this.handleCommonBlockVariable(changed_var);
                    } else {
                        String changedName = changed_var.getName();
                        if (!IDLVariable.isVariableHidden(changed_var.getName())) {
                            IDLVariable matchingVar = this.m_vars.get(changedName);
                            if (matchingVar == null) {
                                this.addIDLVariable(changed_var);
                            } else {
                                matchingVar.handleVariableChanged(changed_var);
                            }
                            changed = true;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (changed) {
            this.fireChangeEvent(512);
        }
    }

    protected void handleCommonBlockVariable(IDLVariable commonBlockVar) {
        IDLVariable cBlockVarCategory;
        String commonBlockName = commonBlockVar.getCommonBlockName();
        String cBlockCategoryname = String.valueOf(COMMON_BLOCK_CATEGORY_PREFIX) + ' ' + commonBlockName;
        if (this.m_commonBlocks.containsKey(commonBlockName)) {
            cBlockVarCategory = this.m_commonBlocks.get(commonBlockName);
        } else {
            cBlockVarCategory = this.getCategoryVariable(cBlockCategoryname);
            this.m_commonBlocks.put(commonBlockName, cBlockVarCategory);
            this.m_vars.put(cBlockVarCategory.getName(), cBlockVarCategory);
        }
        IDLVariable v = cBlockVarCategory.getIDLVariable(commonBlockVar.getName());
        if (v != null) {
            v.handleVariableChanged(commonBlockVar);
            cBlockVarCategory.setChildChanged();
        } else {
            cBlockVarCategory.addIDLVariable(commonBlockVar);
        }
    }

    public void handleSystemVariableChange(SystemVariableDTO dto) {
        boolean changed = false;
        IDLVariable sysVarCategory = this.getCategoryVariable(SYSTEM_VARIABLES_CATEGORY);
        this.m_vars.remove(sysVarCategory);
        this.buildFramesListOfSystemVariables();
        IDLVariable[] newVars = dto.getIDLVariables();
        if (newVars.length == 0) {
            return;
        }
        IDLVariable root = this.m_vars.get(SYSTEM_VARIABLES_CATEGORY);
        int i = 0;
        while (i < newVars.length) {
            IDLVariable v = root.getIDLVariable(newVars[i].getName());
            if (v != null) {
                v.handleVariableChanged(newVars[i]);
                changed = true;
            }
            ++i;
        }
        if (changed) {
            root.setChildChanged();
        }
        if (changed) {
            this.fireChangeEvent(512);
        }
    }

    public void handleHeapVariableChange(HeapVariableDTO dto) {
        boolean changed = false;
        IDLVariable[] newVars = dto.getIDLVariables();
        int i = 0;
        while (i < newVars.length) {
            try {
                String name = newVars[i].getName();
                IDLVariable var = this.m_heapvars.get(name);
                if (var == null) {
                    this.m_heapvars.put(name, newVars[i]);
                } else {
                    var.handleVariableChanged(newVars[i]);
                }
                changed = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        if (changed) {
            this.fireChangeEvent(512);
        }
    }

    public void categorizeCommonBlockVariables() {
        IDLVariable[] vars = this.getIDLVariables();
        this.m_vars.clear();
        int i = 0;
        while (i < vars.length) {
            IDLVariable v = vars[i];
            if (v.isCommonBlock()) {
                this.handleCommonBlockVariable(v);
            } else {
                this.m_vars.put(v.getName(), v);
            }
            ++i;
        }
    }

    public void addDummyArrayVariables() {
    }

    public Object getAdapter(Class adapter) {
        Object retVal = null;
        retVal = super.getAdapter(adapter);
        Tracer.trace(Tracer.TRACE_DEBUG_MODEL_ADAPTERS, "=IDLStackFrame:getAdapter(" + adapter + ") --> returns " + retVal);
        return retVal;
    }

    public String toString() {
        return "IDLStackFrame [" + this.m_name + "]";
    }
}

