/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.debug.internal.model;

import com.rsi.idldt.core.dom.IDOMNode;
import com.rsi.idldt.core.dom.IIDLCompilationUnit;
import com.rsi.idldt.core.dom.IIDLDOMManager;
import com.rsi.idldt.core.internal.dom.IDLDOMManager;
import com.rsi.idldt.debug.internal.model.AbstractIDLBreakpoint;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;

public class IDLLineBreakpoint
extends AbstractIDLBreakpoint {
    protected IResource m_resource;

    public IDLLineBreakpoint() {
    }

    public IDLLineBreakpoint(IResource resource, int lineNumber, int offset) throws CoreException {
        this(resource, lineNumber, offset, false);
    }

    public IDLLineBreakpoint(final IResource resource, final int lineNumber, final int offset, final boolean isRunToLine) throws CoreException {
        this.m_resource = resource;
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = resource.createMarker("com.rsi.idldt.core.marker.IDLLineBreakpoint");
                marker.setAttribute("message", (Object)("Line Breakpoint: " + resource.getName() + " [line: " + lineNumber + "]"));
                IDLLineBreakpoint.this.setMarker(marker);
                IDLLineBreakpoint.this.setBaseAttributes(marker, IDLLineBreakpoint.this.getModelIdentifier(), Boolean.TRUE, lineNumber, offset, IDLLineBreakpoint.this.getRoutineNameFromDOM());
                IDLLineBreakpoint.this.setConditionalAttributes(marker, false, false, null, 0);
                if (isRunToLine) {
                    IDLLineBreakpoint.this.setRunToLineAttributes(marker);
                }
            }
        };
        this.run(this.getMarkerRule(resource), runnable);
    }

    public void changeMarkerLineNumber(final int lineNumber) {
        final IMarker marker = this.getMarker();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                String resourceName = "";
                if (IDLLineBreakpoint.this.m_resource != null && IDLLineBreakpoint.this.m_resource.getName() != null) {
                    resourceName = IDLLineBreakpoint.this.m_resource.getName();
                }
                marker.setAttribute("message", (Object)("Line Breakpoint: " + resourceName + " [line: " + lineNumber + "]"));
                marker.setAttribute("ROUTINE_INFO", (Object)IDLLineBreakpoint.this.getRoutineNameFromDOM());
            }
        };
        try {
            this.run(this.getMarkerRule(this.m_resource), runnable);
        }
        catch (DebugException debugException) {}
    }

    public String getOSFilePath() {
        return this.getResource().getLocation().toOSString();
    }

    public String toString() {
        return String.valueOf(this.getToStringResourceName()) + this.getToStringLineNumber() + this.getToStringExtraInformation();
    }

    protected String getRoutineNameFromDOM() {
        IIDLCompilationUnit cu;
        IIDLDOMManager dm;
        int offset;
        IResource resource = this.getResource();
        String routineName = "";
        if (resource instanceof IFile && (offset = this.getDOMOffset()) >= 0 && (dm = IDLDOMManager.getActiveManager()) != null && (cu = dm.getCompilationUnit((IFile)resource)) != null) {
            IDOMNode node = cu.getElementAt(offset);
            routineName = node.getElementName();
        }
        return routineName;
    }
}

