/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.debug.internal.model;

import com.rsi.idldt.core.dom.IDOMNode;
import com.rsi.idldt.core.dom.IIDLCompilationUnit;
import com.rsi.idldt.core.dom.IIDLDOMManager;
import com.rsi.idldt.core.internal.dom.IDLDOMManager;
import com.rsi.idldt.debug.internal.model.AbstractIDLBreakpoint;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;

public class IDLExternalLineBreakpoint
extends AbstractIDLBreakpoint {
    protected IResource m_resource;

    public IDLExternalLineBreakpoint() {
    }

    public IDLExternalLineBreakpoint(IPath path, int lineNumber, int offset) throws CoreException {
        this(path, lineNumber, offset, false);
    }

    public IDLExternalLineBreakpoint(IPath path, int lineNumber, int offset, boolean isRunToLine) throws CoreException {
        IWorkspaceRoot resource = ResourcesPlugin.getWorkspace().getRoot();
        this.m_resource = resource;
        IWorkspaceRunnable runnable = new IWorkspaceRunnable((IResource)resource, path, lineNumber, offset, isRunToLine){
            private final /* synthetic */ IResource val$resource;
            private final /* synthetic */ IPath val$path;
            private final /* synthetic */ int val$lineNumber;
            private final /* synthetic */ int val$offset;
            private final /* synthetic */ boolean val$isRunToLine;
            {
                this.val$resource = iResource;
                this.val$path = iPath;
                this.val$lineNumber = n;
                this.val$offset = n2;
                this.val$isRunToLine = bl;
            }

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = this.val$resource.createMarker("com.rsi.idldt.core.marker.IDLExternalLineBreakpoint");
                marker.setAttribute("EXTERNAL_FILE_PATH", (Object)(this.val$path == null ? "" : this.getCanonicalPath(this.val$path)));
                marker.setAttribute("message", (Object)("External Line Breakpoint: " + this.val$resource.getName() + " [line: " + this.val$lineNumber + "]"));
                IDLExternalLineBreakpoint.this.setMarker(marker);
                IDLExternalLineBreakpoint.this.setBaseAttributes(marker, IDLExternalLineBreakpoint.this.getModelIdentifier(), Boolean.TRUE, this.val$lineNumber, this.val$offset, IDLExternalLineBreakpoint.this.getRoutineNameFromDOM());
                IDLExternalLineBreakpoint.this.setConditionalAttributes(marker, false, false, null, 0);
                if (this.val$isRunToLine) {
                    IDLExternalLineBreakpoint.this.setRunToLineAttributes(marker);
                }
            }

            private String getCanonicalPath(IPath p) {
                String s;
                try {
                    s = p.toFile().getCanonicalPath();
                }
                catch (IOException iOException) {
                    s = "";
                }
                return s;
            }
        };
        this.run(this.getMarkerRule((IResource)resource), runnable);
    }

    public void changeMarkerLineNumber(final int lineNumber) {
        final IMarker marker = this.getMarker();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                String resource_name = "";
                if (IDLExternalLineBreakpoint.this.m_resource != null) {
                    resource_name = IDLExternalLineBreakpoint.this.m_resource.getName();
                }
                marker.setAttribute("message", (Object)("External Line Breakpoint: " + resource_name + " [line: " + lineNumber + "]"));
                marker.setAttribute("ROUTINE_INFO", (Object)IDLExternalLineBreakpoint.this.getRoutineNameFromDOM());
            }
        };
        try {
            this.run(this.getMarkerRule(this.m_resource), runnable);
        }
        catch (DebugException debugException) {}
    }

    public String getOSFilePath() {
        return this.getFilePath();
    }

    public String toString() {
        return String.valueOf(this.getToStringResourceName()) + this.getToStringLineNumber() + this.getToStringExtraInformation();
    }

    protected String getToStringResourceName() {
        return this.getFilePath();
    }

    protected String getRoutineNameFromDOM() {
        IIDLCompilationUnit cu;
        IIDLDOMManager dm;
        int offset;
        File file = new File(this.getOSFilePath());
        String routineName = "";
        if (file.exists() && (offset = this.getDOMOffset()) >= 0 && (dm = IDLDOMManager.getActiveManager()) != null && (cu = dm.getCompilationUnit(file)) != null) {
            IDOMNode node = cu.getElementAt(offset);
            routineName = node.getElementName();
        }
        return routineName;
    }
}

