/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.debug.internal.model;

import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.core.Messages;
import com.rsi.idldt.core.interp.IInterpreterDebugListener;
import com.rsi.idldt.core.utils.Tracer;
import com.rsi.idldt.core.utils.WorkspaceUtilities;
import com.rsi.idldt.debug.internal.model.IDLBreakpointManager;
import com.rsi.idldt.debug.internal.model.IDLDebugElement;
import com.rsi.idldt.debug.internal.model.IDLExternalLineBreakpoint;
import com.rsi.idldt.debug.internal.model.IDLLineBreakpoint;
import com.rsi.idldt.debug.internal.model.IDLStackFrame;
import com.rsi.idldt.debug.internal.model.IDLThread;
import com.rsi.idldt.debug.internal.model.IDLVariable;
import com.rsi.idldt.debug.model.IIDLBreakpoint;
import com.rsi.idldt.debug.model.IIDLDebugTargetListener;
import com.rsi.jdml.DebugInfoDTO;
import com.rsi.jdml.HeapVariableDTO;
import com.rsi.jdml.StackFramesDTO;
import com.rsi.jdml.SystemVariableDTO;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDLDebugTarget
extends IDLDebugElement
implements IDebugTarget,
IInterpreterDebugListener,
IBreakpointManagerListener {
    private IIDLProcessProxy m_idlProcess;
    private String m_name;
    private ILaunch m_launch;
    private IDLThread m_thread;
    private IDLThread[] m_threads;
    private boolean m_supportTerminate;
    private boolean m_supportDisconnect;
    private IIDLBreakpoint m_runToLineBreakpoint;
    private Map<String, IDLVariable> m_sysVars = new TreeMap<String, IDLVariable>();
    private final AbstractList<IIDLDebugTargetListener> m_debugListeners = new Vector<IIDLDebugTargetListener>(1);

    public IDLDebugTarget(ILaunch launch, IIDLProcessProxy idl) {
        super(null);
        this.setDebugTarget(this);
        this.m_idlProcess = idl;
        this.m_launch = launch;
        this.m_supportTerminate = true;
        this.m_supportDisconnect = false;
        this.m_runToLineBreakpoint = null;
        this.m_idlProcess.addInterpreterDebugListener(this);
        this.m_thread = new IDLThread(this);
        this.m_threads = new IDLThread[1];
        this.m_threads[0] = this.m_thread;
        this.setName(Messages.IDLStackFrame_DebugTarget);
        this.initialize();
        IBreakpointManager breakpointManager = this.getBreakpointManager();
        breakpointManager.addBreakpointListener((IBreakpointListener)this);
        breakpointManager.addBreakpointManagerListener((IBreakpointManagerListener)this);
    }

    protected synchronized void initialize() {
        Tracer.trace(Tracer.TRACE_DEBUG_MODEL2, "=IDLDebugTarget::initialize");
        if (Tracer.TRACE_DEBUG_MODEL2) {
            this.initDebugEventsLogging();
        }
        this.getLaunch().addDebugTarget((IDebugTarget)this);
        this.fireCreationEvent();
        this.m_thread.fireCreationEvent();
    }

    private void initDebugEventsLogging() {
        DebugPlugin.getDefault().addDebugEventListener(new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                int i = 0;
                while (i < events.length) {
                    Tracer.trace(true, "*****    " + events[i]);
                    ++i;
                }
            }
        });
    }

    private IBreakpointManager getBreakpointManager() {
        return IDLBreakpointManager.getBreakpointManager();
    }

    public void postStartup() {
        this.installBreakpoints();
    }

    public void performReset() {
        this.installBreakpoints();
    }

    private void installBreakpoints() {
        IBreakpoint[] bkpts = this.getBreakpointManager().getBreakpoints("idl.debugModel");
        int i = 0;
        while (i < bkpts.length) {
            this.breakpointAdded(bkpts[i]);
            ++i;
        }
    }

    public IProcess getProcess() {
        Tracer.trace(Tracer.TRACE_DEBUG_MODEL2, "=IDLDebugTarget:getProcess returns null");
        return null;
    }

    public String getName() throws DebugException {
        return this.m_name;
    }

    public IThread[] getThreads() {
        return this.m_threads;
    }

    public ILaunch getLaunch() {
        return this.m_launch;
    }

    public boolean hasThreads() {
        return true;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return breakpoint instanceof IIDLBreakpoint;
    }

    public boolean canTerminate() {
        return this.m_supportTerminate && this.getThread().canTerminate();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getThread().terminate();
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public void resume() throws DebugException {
        Tracer.trace(Tracer.TRACE_DEBUG_MODEL2, "=IDLDebugTarget:resume");
        this.getThread().resume();
    }

    public void suspend() throws DebugException {
        this.getThread().suspend();
    }

    public boolean canDisconnect() {
        return this.m_supportDisconnect;
    }

    public void disconnect() throws DebugException {
        Tracer.trace(Tracer.TRACE_DEBUG_MODEL2, "=IDLDebugTarget:disconnect (NOT SUPPORTED)");
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) {
        return null;
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        Tracer.trace(Tracer.TRACE_DEBUG_MODEL2, "=IDLDebugTarget:breakpointAdded(" + breakpoint + ")");
        if (this.supportsBreakpoint(breakpoint)) {
            IIDLBreakpoint idlBreakpoint = (IIDLBreakpoint)breakpoint;
            boolean isRunToLine = idlBreakpoint.isRunToLine();
            if (!idlBreakpoint.wasChangedByIDL()) {
                idlBreakpoint.installBreakpoint(this);
            }
            try {
                IBreakpointManager bpm = IDLBreakpointManager.getBreakpointManager();
                if (!(idlBreakpoint.isEnabled() && bpm.isEnabled() || isRunToLine)) {
                    idlBreakpoint.disableBreakpoint(this);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (isRunToLine) {
                this.m_runToLineBreakpoint = idlBreakpoint;
            }
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        IIDLBreakpoint idlBreakpoint;
        Tracer.trace(Tracer.TRACE_DEBUG_MODEL2, "=IDLDebugTarget:breakpointRemoved(" + breakpoint + ")");
        if (this.supportsBreakpoint(breakpoint) && !(idlBreakpoint = (IIDLBreakpoint)breakpoint).wasChangedByIDL() && !idlBreakpoint.isRunToLine()) {
            idlBreakpoint.removeBreakpoint(this);
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        Tracer.trace(Tracer.TRACE_DEBUG_MODEL2, "=NYI IDLDebugTarget:breakpointChanged(" + breakpoint + ")");
        if (this.supportsBreakpoint(breakpoint)) {
            IIDLBreakpoint idlBreakpoint = (IIDLBreakpoint)breakpoint;
            if (idlBreakpoint.wasChangedByIDL()) {
                idlBreakpoint.setChangedByIDL(false);
                return;
            }
            try {
                int old_line = delta.getAttribute("lineNumber", -1);
                int new_line = delta.getMarker().getAttribute("lineNumber", -1);
                if (old_line != new_line) {
                    idlBreakpoint.setLine(old_line);
                    this.breakpointRemoved(idlBreakpoint, null);
                    idlBreakpoint.setLine(new_line);
                    idlBreakpoint.changeMarkerLineNumber(new_line);
                    idlBreakpoint.setOnRecompile(true);
                    this.breakpointAdded(breakpoint);
                } else if (breakpoint.isEnabled() && this.getBreakpointManager().isEnabled()) {
                    idlBreakpoint.enableBreakpoint(this);
                } else {
                    idlBreakpoint.disableBreakpoint(this);
                }
            }
            catch (CoreException coreException) {}
        }
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        IBreakpoint[] breakpoints = this.getBreakpointManager().getBreakpoints(this.getModelIdentifier());
        int i = 0;
        while (i < breakpoints.length) {
            IIDLBreakpoint idlBreakpoint = (IIDLBreakpoint)breakpoints[i];
            if (enabled) {
                idlBreakpoint.enableBreakpoint(this);
            } else {
                idlBreakpoint.disableBreakpoint(this);
            }
            ++i;
        }
    }

    public void breakpointMovedByIDL(DebugInfoDTO dto) {
        String file = dto.getFilePath();
        int oldLine = dto.getOldLine();
        int newLine = dto.getNewLine();
        IIDLBreakpoint bp = IDLBreakpointManager.findByFileLine(this, file, oldLine);
        if (bp != null) {
            if (bp.isRunToLine()) {
                bp.setChangedByIDL(true);
                bp.setLine(newLine);
                bp.setChangedByIDL(false);
            } else {
                IIDLBreakpoint match = IDLBreakpointManager.findByFileLine(file, newLine);
                if (match != null) {
                    try {
                        bp.setChangedByIDL(true);
                        bp.delete();
                        bp.setChangedByIDL(false);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                } else {
                    bp.setChangedByIDL(true);
                    bp.setLine(newLine);
                    bp.changeMarkerLineNumber(newLine);
                    bp.setChangedByIDL(false);
                }
            }
        }
    }

    public void showBreakpoint(DebugInfoDTO dto) {
        if (dto.isBreakpointBeingCleared() && this.getIDLProcess().isExecutingReset()) {
            return;
        }
        String file = dto.getFilePath();
        int line = dto.getLine();
        IIDLBreakpoint bp = IDLBreakpointManager.findByFileLine(file, line);
        IBreakpointManager bpm = IDLBreakpointManager.getBreakpointManager();
        if (dto.isBreakpointBeingEnabled()) {
            try {
                if (bp == null) {
                    IFile resource = WorkspaceUtilities.getWorkspaceFileByOSPath(file);
                    if (resource == null) {
                        Path path = new Path(file);
                        bp = new IDLExternalLineBreakpoint((IPath)path, line, 0);
                    } else {
                        bp = new IDLLineBreakpoint((IResource)resource, line, 0);
                    }
                    bp.setBreakCondition(dto.getBreakCondition());
                    bp.setBreakOnce(dto.getBreakOnce());
                    bp.setBreakAfter(dto.getBreakAfter());
                    bp.setOnRecompile(dto.getOnRecompile());
                    bp.setChangedByIDL(true);
                    bpm.addBreakpoint((IBreakpoint)bp);
                    bp.setChangedByIDL(true);
                    if (!bpm.isEnabled()) {
                        bp.disableBreakpoint(this);
                    }
                } else {
                    bp.setEnabled(true);
                    if (!bpm.isEnabled()) {
                        bp.disableBreakpoint(this);
                    }
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else if (dto.isBreakpointBeingDisabled()) {
            if (bp != null) {
                try {
                    if (bpm.isEnabled()) {
                        bp.setEnabled(false);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        } else if (dto.isBreakpointBeingCleared() && bp != null) {
            try {
                bp.setChangedByIDL(true);
                bpm.removeBreakpoint((IBreakpoint)bp, true);
                bp.setChangedByIDL(false);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public int getSuspendCount() {
        return this.getThread().getSuspendCount();
    }

    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    public IIDLProcessProxy getIDLProcess() {
        return this.m_idlProcess;
    }

    public IDLThread getThread() {
        return this.m_thread;
    }

    public IVariable getSystemVariable(String varName) {
        IDLVariable var = null;
        String[] parts = varName.split("\\.");
        try {
            var = this.getThread().getMainIDLStackFrame().getIDLVariable(parts[0]);
        }
        catch (Throwable throwable) {
            return null;
        }
        try {
            int i = 1;
            while (i < parts.length) {
                var = var.getIDLVariable(parts[i]);
                ++i;
            }
        }
        catch (Exception exception) {
            var = null;
        }
        return var;
    }

    public IDLVariable getIDLVariable(String frameName, String varName) {
        try {
            IDLStackFrame frame = this.getThread().getIDLStackFrame(frameName);
            if (frame != null) {
                IDLVariable var = frame.getIDLVariable(varName);
                return var;
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    public List<IDLVariable> getIDLScopeVariables() {
        ArrayList<IDLVariable> vars = new ArrayList<IDLVariable>();
        IDLStackFrame frame = this.getThread().getTopIDLStackFrame();
        if (frame != null) {
            IDLVariable[] varArray = frame.getIDLVariables();
            int i = 0;
            while (i < varArray.length) {
                if (!varArray[i].isSpecialPlaceholder()) {
                    vars.add(varArray[i]);
                }
                ++i;
            }
        }
        return vars;
    }

    public void purgeRunToLineBreakpoint() {
        if (this.m_runToLineBreakpoint != null) {
            try {
                String file = this.m_runToLineBreakpoint.getFilePath();
                int line = this.m_runToLineBreakpoint.getLine();
                IIDLBreakpoint original = IDLBreakpointManager.findByFileLine(file, line);
                if (original != null) {
                    original.installBreakpoint(this);
                } else {
                    this.m_runToLineBreakpoint.removeBreakpoint(this);
                }
                this.m_runToLineBreakpoint.delete();
                this.m_runToLineBreakpoint = null;
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public IIDLBreakpoint getRunToLineBreakpoint() {
        return this.m_runToLineBreakpoint;
    }

    @Override
    public void handleInterpreterStopped(String filename, String module, int line, int err) {
        this.m_thread.handleInterpreterStopped(filename, module, line, err);
    }

    @Override
    public synchronized void suspendDebugModel(StackFramesDTO frames, SystemVariableDTO sysVars, HeapVariableDTO heapVars) {
        this.m_thread.suspendDebugModel(frames, sysVars, heapVars);
    }

    @Override
    public void commandFinished() {
        Tracer.trace(Tracer.TRACE_DEBUG_MODEL2, "=IDLDebugTarget:commandFinished");
        this.m_thread.commandFinished();
    }

    @Override
    public void commandStarted() {
        this.m_thread.commandStarted();
    }

    public void addIDLDebugTargetListener(IIDLDebugTargetListener l) {
        if (l != null && !this.m_debugListeners.contains(l)) {
            this.m_debugListeners.add(l);
        }
    }

    public void removeIDLDebugTargetListener(IIDLDebugTargetListener l) {
        if (l != null) {
            this.m_debugListeners.remove(l);
        }
    }

    protected void notifyOfResume() {
        IIDLDebugTargetListener listener = null;
        int i = 0;
        int n = this.m_debugListeners.size();
        while (i < n) {
            listener = this.m_debugListeners.get(i);
            listener.targetResumed();
            ++i;
        }
    }

    protected void notifyOfSuspend() {
        IIDLDebugTargetListener listener = null;
        int i = 0;
        int n = this.m_debugListeners.size();
        while (i < n) {
            listener = this.m_debugListeners.get(i);
            listener.targetSuspended();
            ++i;
        }
    }

    protected void notifyOfTerminate() {
        IIDLDebugTargetListener listener = null;
        int i = 0;
        int n = this.m_debugListeners.size();
        while (i < n) {
            listener = this.m_debugListeners.get(i);
            listener.targetTerminated();
            ++i;
        }
    }

    public void handleSystemVariableChange(SystemVariableDTO dto) {
        IDLVariable[] newVars = dto.getIDLVariables();
        int i = 0;
        while (i < newVars.length) {
            try {
                String name = newVars[i].getName();
                IDLVariable var = this.m_sysVars.get(name);
                if (var == null) {
                    this.m_sysVars.put(name, newVars[i]);
                } else {
                    IDLVariable newVar = newVars[i];
                    var.handleVariableChanged(newVar);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public IDLVariable[] getSystemVariables() {
        return this.m_sysVars.values().toArray(new IDLVariable[this.m_sysVars.size()]);
    }

    @Override
    public Object getAdapter(Class adapter) {
        Object retVal = null;
        retVal = super.getAdapter(adapter);
        Tracer.trace(Tracer.TRACE_DEBUG_MODEL_ADAPTERS, "=IDLDebugTarget:getAdapter(" + adapter + ") --> returns " + retVal);
        return retVal;
    }

    public String toString() {
        return "IDLDebugTarget";
    }
}

