/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.debug.internal.model;

import com.rsi.idldt.debug.internal.model.IDLDebugTarget;
import com.rsi.idldt.debug.model.IIDLBreakpoint;
import java.util.Vector;
import org.eclipse.core.resources.IMarker;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;

public class IDLBreakpointManager {
    public static IBreakpointManager getBreakpointManager() {
        return DebugPlugin.getDefault().getBreakpointManager();
    }

    public static IBreakpoint getBreakpoint(IMarker marker) {
        return IDLBreakpointManager.getBreakpointManager().getBreakpoint(marker);
    }

    public static IBreakpoint[] getIDLBreakpoints() {
        IBreakpointManager mgr = IDLBreakpointManager.getBreakpointManager();
        return mgr.getBreakpoints("idl.debugModel");
    }

    public static IIDLBreakpoint[] getAllFromFile(String fileName) {
        IBreakpoint[] breakpoints = IDLBreakpointManager.getIDLBreakpoints();
        Vector<IIDLBreakpoint> v = new Vector<IIDLBreakpoint>(breakpoints.length);
        int i = 0;
        while (i < breakpoints.length) {
            IIDLBreakpoint bp = (IIDLBreakpoint)breakpoints[i];
            if (fileName.compareToIgnoreCase(bp.getFilePath()) == 0) {
                v.add(bp);
            }
            ++i;
        }
        return v.toArray(new IIDLBreakpoint[v.size()]);
    }

    public static IIDLBreakpoint findByFileLine(String file, int line) {
        IIDLBreakpoint match = null;
        IBreakpoint[] breakpoints = IDLBreakpointManager.getIDLBreakpoints();
        int i = 0;
        while (i < breakpoints.length) {
            IIDLBreakpoint bp = (IIDLBreakpoint)breakpoints[i];
            if (bp.matches(file, line)) {
                match = bp;
                break;
            }
            ++i;
        }
        return match;
    }

    public static IIDLBreakpoint findByFileLine(IDLDebugTarget debugTarget, String file, int line) {
        IIDLBreakpoint match = IDLBreakpointManager.findByFileLine(file, line);
        if (match != null) {
            return match;
        }
        IIDLBreakpoint runToLineBreakpoint = debugTarget.getRunToLineBreakpoint();
        if (runToLineBreakpoint != null && runToLineBreakpoint.matches(file, line)) {
            return runToLineBreakpoint;
        }
        return null;
    }
}

