/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.debug.internal.model;

import com.rsi.idldt.core.internal.interp.commands.UpdateBreakpointCommand;
import com.rsi.idldt.debug.internal.model.IDLDebugTarget;
import com.rsi.idldt.debug.model.IIDLBreakpoint;
import com.rsi.jdml.BreakpointDTO;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.model.LineBreakpoint;

public abstract class AbstractIDLBreakpoint
extends LineBreakpoint
implements IIDLBreakpoint {
    protected static final String DOM_OFFSET = "DOM_OFFSET";
    protected static final String RUN_TO_LINE = "RUN_TO_LINE";
    public static final String EXTERNAL_FILE_PATH = "EXTERNAL_FILE_PATH";
    protected static final String BREAK_ON_RECOMPILE = "ON_RECOMPILE";
    protected static final String BREAK_ONCE = "BREAK_ONCE";
    protected static final String BREAK_CONDITION = "BREAK_CONDITION";
    protected static final String BREAK_AFTER_COUNT = "BREAK_AFTER_COUNT";
    protected static final String ROUTINE_INFO = "ROUTINE_INFO";
    public static final String IDL_LINE_BREAKPOINT_MARKER = "com.rsi.idldt.core.marker.IDLLineBreakpoint";
    public static final String IDL_LINE_EXTERNAL_BREAKPOINT_MARKER = "com.rsi.idldt.core.marker.IDLExternalLineBreakpoint";
    protected BreakpointDTO m_dto;
    private boolean m_changedByIDL = false;
    private boolean m_isRunToLine = false;
    protected String m_additionalInfo = null;

    protected void setBaseAttributes(IMarker marker, String modelIdentifier, Boolean enabled, int lineNumber, int offset, String routineName) throws CoreException {
        HashMap<String, String> attributes = marker.getAttributes();
        if (attributes == null) {
            attributes = new HashMap<String, String>(4);
        }
        attributes.put("org.eclipse.debug.core.id", modelIdentifier);
        attributes.put("org.eclipse.debug.core.enabled", (String)((Object)enabled));
        attributes.put("lineNumber", (String)((Object)new Integer(lineNumber)));
        attributes.put(DOM_OFFSET, (String)((Object)new Integer(offset)));
        attributes.put(ROUTINE_INFO, routineName);
        marker.setAttributes(attributes);
    }

    protected void setConditionalAttributes(IMarker marker, boolean onRecompile, boolean breakOnce, String condition, int breakAfterCount) throws CoreException {
        HashMap<String, Boolean> attributes = marker.getAttributes();
        if (attributes == null) {
            attributes = new HashMap<String, Boolean>(4);
        }
        attributes.put(BREAK_ON_RECOMPILE, new Boolean(onRecompile));
        attributes.put(BREAK_ONCE, new Boolean(breakOnce));
        attributes.put(BREAK_CONDITION, (Boolean)((Object)condition));
        attributes.put(BREAK_AFTER_COUNT, (Boolean)((Object)new Integer(breakAfterCount)));
        marker.setAttributes(attributes);
    }

    protected void setRunToLineAttributes(IMarker marker) throws CoreException {
        HashMap<String, Boolean> attributes = marker.getAttributes();
        if (attributes == null) {
            attributes = new HashMap<String, Boolean>(2);
        }
        attributes.put("org.eclipse.debug.core.persisted", Boolean.FALSE);
        attributes.put(RUN_TO_LINE, Boolean.TRUE);
        marker.setAttributes(attributes);
        this.m_isRunToLine = true;
    }

    public String getModelIdentifier() {
        return "idl.debugModel";
    }

    public int getDOMOffset() {
        return this.getAttribute(DOM_OFFSET, -1);
    }

    private BreakpointDTO getDTO() {
        if (this.m_dto == null) {
            this.m_dto = new BreakpointDTO(this.getCanonicalName(this.getFilePath()), this.getLine(), this.getOnRecompile(), this.getBreakOnce(), this.getBreakCondition(), this.getBreakAfter());
        }
        return this.m_dto;
    }

    public int getLine() {
        try {
            return this.getLineNumber();
        }
        catch (CoreException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void setLine(int newLine) {
        this.m_dto = null;
        this.putAttribute("lineNumber", newLine);
    }

    public void setChangedByIDL(boolean changedByIDL) {
        this.m_changedByIDL = changedByIDL;
    }

    public boolean wasChangedByIDL() {
        return this.m_changedByIDL;
    }

    public String getFilePath() {
        IResource r = this.getResource();
        if (r instanceof IFile) {
            IPath path = r.getLocation();
            return path != null ? path.toOSString() : null;
        }
        return this.getExternalPath().replace('/', File.separatorChar);
    }

    public String getExternalPath() {
        return this.getAttribute(EXTERNAL_FILE_PATH, null);
    }

    public int getBreakAfter() {
        return this.getAttribute(BREAK_AFTER_COUNT, 0);
    }

    public void setBreakAfter(int count) {
        this.putAttribute(BREAK_AFTER_COUNT, count);
    }

    public String getBreakCondition() {
        return this.getAttribute(BREAK_CONDITION, null);
    }

    public void setBreakCondition(String condition) {
        this.putAttribute(BREAK_CONDITION, condition);
    }

    public boolean getBreakOnce() {
        return this.getAttribute(BREAK_ONCE, false);
    }

    public void setBreakOnce(boolean breakOnce) {
        this.putAttribute(BREAK_ONCE, breakOnce);
    }

    public boolean getOnRecompile() {
        return this.getAttribute(BREAK_ON_RECOMPILE, false);
    }

    public void setOnRecompile(boolean onRecompile) {
        this.putAttribute(BREAK_ON_RECOMPILE, onRecompile);
        this.m_dto = null;
    }

    protected IResource getResource() {
        return this.getMarker().getResource();
    }

    public boolean isRunToLine() {
        return this.m_isRunToLine;
    }

    public void setEnabled(boolean enabled) throws CoreException {
        super.setEnabled(enabled);
    }

    public void installBreakpoint(IDLDebugTarget target) {
        target.getIDLProcess().queueCommand(new UpdateBreakpointCommand(1, this.getDTO()));
    }

    public void removeBreakpoint(IDLDebugTarget target) {
        target.getIDLProcess().queueCommand(new UpdateBreakpointCommand(4, this.getDTO()));
    }

    public void enableBreakpoint(IDLDebugTarget target) {
        target.getIDLProcess().queueCommand(new UpdateBreakpointCommand(1, this.getDTO()));
    }

    public void disableBreakpoint(IDLDebugTarget target) {
        target.getIDLProcess().queueCommand(new UpdateBreakpointCommand(2, this.getDTO()));
    }

    protected String getCanonicalName(String in_name) {
        if (in_name.length() == 0) {
            return in_name;
        }
        try {
            File file = new File(in_name);
            String canonical_name = file.getCanonicalFile().getAbsolutePath();
            return canonical_name;
        }
        catch (IOException iOException) {
            return in_name;
        }
    }

    public boolean matches(String filename, int line) {
        try {
            String this_fname = this.getCanonicalName(this.getOSFilePath());
            String passedin_fname = this.getCanonicalName(filename);
            if (line == this.getLine() && passedin_fname.equalsIgnoreCase(this_fname)) {
                return true;
            }
        }
        catch (Throwable throwable) {}
        return false;
    }

    public abstract String getOSFilePath();

    public String toString() {
        return String.valueOf(this.getToStringResourceName()) + this.getToStringLineNumber();
    }

    protected String getToStringResourceName() {
        return this.getMarker().getResource().getName();
    }

    protected String getToStringLineNumber() {
        return " [line: " + this.getLine() + "]";
    }

    private void putAttribute(String attributeName, int value) {
        IMarker m = this.getMarker();
        if (m != null) {
            try {
                m.setAttribute(attributeName, value);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private void putAttribute(String attributeName, boolean value) {
        IMarker m = this.getMarker();
        if (m != null) {
            try {
                m.setAttribute(attributeName, value);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private void putAttribute(String attributeName, String value) {
        IMarker m = this.getMarker();
        if (m != null) {
            try {
                m.setAttribute(attributeName, (Object)value);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private int getAttribute(String attributeName, int defaultValue) {
        IMarker m = this.getMarker();
        if (m != null) {
            return m.getAttribute(attributeName, defaultValue);
        }
        return defaultValue;
    }

    private boolean getAttribute(String attributeName, boolean defaultValue) {
        IMarker m = this.getMarker();
        if (m != null) {
            return m.getAttribute(attributeName, defaultValue);
        }
        return defaultValue;
    }

    private String getAttribute(String attributeName, String defaultValue) {
        IMarker m = this.getMarker();
        if (m != null) {
            return m.getAttribute(attributeName, defaultValue);
        }
        return defaultValue;
    }

    protected String getToStringExtraInformation() {
        String routineName = this.getAttribute(ROUTINE_INFO, "");
        if (routineName.equals("")) {
            routineName = this.getRoutineNameFromDOM();
            this.putAttribute(ROUTINE_INFO, routineName);
        }
        return routineName.equals("") ? "" : " - " + routineName;
    }

    protected abstract String getRoutineNameFromDOM();
}

