/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core.utils;

import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class WorkspaceUtilities {
    public static IFile getWorkspaceFile(IFileStore fs) {
        IFileInfo info = fs.fetchInfo();
        if (info.isDirectory() || !info.exists()) {
            return null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        Path path = new Path(fs.toURI().getPath());
        IFile file = workspace.getRoot().getFileForLocation((IPath)path);
        return file;
    }

    public static IFile getWorkspaceFileByOSPath(String path) {
        IFileStore fs = EFS.getLocalFileSystem().getStore((IPath)new Path(path));
        return WorkspaceUtilities.getWorkspaceFile(fs);
    }
}

