/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core.utils;

import org.eclipse.core.runtime.Platform;

public class Tracer {
    private static final String TRACE_ID = "com.rsi.idldt.core/debug";
    private static final String TRACE_MOCKIDL_ID = "com.rsi.idldt.core/debug/mockidl";
    private static final String TRACE_DML_ID = "com.rsi.idldt.core/debug/dml";
    private static final String TRACE_JDML_ID = "com.rsi.idldt.core/debug/jdml";
    private static final String TRACE_MODEL_IDENTIFIERS_ID = "com.rsi.idldt.core/debug/model/identifiers";
    private static final String TRACE_MODEL_DEBUG_ID = "com.rsi.idldt.core/debug/model/debug";
    private static final String TRACE_RESOURCE_CHANGES_ID = "com.rsi.idldt.core/debug/resourceChanges";
    private static final String TRACE_DEBUG_SUBSYSTEM = "com.rsi.idldt.core/debug/debugger";
    private static final String TRACE_DEBUG_ADAPTERS = "com.rsi.idldt.core/debug/debugger/adapters";
    private static final String TRUE = "true";
    public static final boolean IS_DEBUGGING = "true".equalsIgnoreCase(Tracer.getPlatformDebugOption("com.rsi.idldt.core/debug", "true"));
    public static final boolean TRACE_MOCKIDL = IS_DEBUGGING && "true".equalsIgnoreCase(Tracer.getPlatformDebugOption("com.rsi.idldt.core/debug/mockidl", "true"));
    public static final boolean TRACE_DML = IS_DEBUGGING && "true".equalsIgnoreCase(Tracer.getPlatformDebugOption("com.rsi.idldt.core/debug/dml", "true"));
    public static int TRACE_JDML;
    public static final boolean TRACE_IDENTIFIERS_MODEL;
    public static final boolean TRACE_DEBUG_MODEL;
    public static final boolean TRACE_RESOURCE_CHANGES;
    public static boolean TRACE_DEBUG_MODEL2;
    public static final boolean TRACE_DEBUG_MODEL_ADAPTERS;

    static {
        String jdml = Tracer.getPlatformDebugOption(TRACE_JDML_ID, "1");
        if (!IS_DEBUGGING || jdml == null) {
            TRACE_JDML = 0;
        } else {
            try {
                TRACE_JDML = Integer.parseInt(jdml);
            }
            catch (Exception exception) {
                TRACE_JDML = 0;
            }
        }
        TRACE_IDENTIFIERS_MODEL = IS_DEBUGGING && TRUE.equalsIgnoreCase(Tracer.getPlatformDebugOption(TRACE_MODEL_IDENTIFIERS_ID, "false"));
        TRACE_DEBUG_MODEL = IS_DEBUGGING && TRUE.equalsIgnoreCase(Tracer.getPlatformDebugOption(TRACE_MODEL_DEBUG_ID, "false"));
        TRACE_RESOURCE_CHANGES = IS_DEBUGGING && TRUE.equalsIgnoreCase(Tracer.getPlatformDebugOption(TRACE_RESOURCE_CHANGES_ID, "false"));
        TRACE_DEBUG_MODEL2 = IS_DEBUGGING && TRUE.equalsIgnoreCase(Tracer.getPlatformDebugOption(TRACE_DEBUG_SUBSYSTEM, "false"));
        TRACE_DEBUG_MODEL_ADAPTERS = IS_DEBUGGING && TRUE.equalsIgnoreCase(Tracer.getPlatformDebugOption(TRACE_DEBUG_ADAPTERS, "false"));
    }

    private static String getPlatformDebugOption(String prop, String default_value) {
        String x = default_value;
        try {
            x = Platform.getDebugOption((String)prop);
        }
        catch (Exception exception) {}
        return x;
    }

    public static void trace(boolean debugFlag, String s) {
        if (debugFlag) {
            System.out.println(s);
        }
    }

    public static void trace(String s) {
        if (IS_DEBUGGING) {
            Tracer.trace(true, s);
        }
    }

    public static void warning(String s) {
        Tracer.doWarning(s, 1);
    }

    public static void warning(String s, int depth) {
        Tracer.doWarning(s, depth);
    }

    private static void doWarning(String s, int depth) {
        int end = 2 + depth;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        if (end > stack.length) {
            end = stack.length;
        }
        System.out.println("Warning: " + s);
        int i = 2;
        while (i < end) {
            System.out.println("  at " + stack[i]);
            ++i;
        }
        System.out.println("\n");
    }
}

