/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core.interp;

import com.rsi.idldt.core.IDLDTCorePlugin;
import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.core.internal.IDLProcessProxy;
import com.rsi.idldt.core.interp.ICommandListener;
import com.rsi.jdml.DMLAccess;
import com.rsi.jdml.HeapVariableDTO;
import com.rsi.jdml.StackFramesDTO;
import com.rsi.jdml.SystemVariableDTO;
import java.util.AbstractList;
import java.util.Vector;

public abstract class AbstractIDLCommand {
    private AbstractList<ICommandListener> m_commandListeners;
    private boolean m_bUpdateDebugModel = true;

    public boolean shouldUpdateDebugModel() {
        return this.m_bUpdateDebugModel;
    }

    public void setUpdateDebugModel(boolean v) {
        this.m_bUpdateDebugModel = v;
    }

    public boolean addToFront() {
        return false;
    }

    public boolean shouldReplaceDuplicate() {
        return false;
    }

    public boolean isDuplicate(AbstractIDLCommand cmd) {
        return this.getClass().equals(cmd.getClass());
    }

    public void addCommandListener(ICommandListener l) {
        if (this.m_commandListeners == null) {
            this.m_commandListeners = new Vector<ICommandListener>(5);
        }
        if (l != null && !this.m_commandListeners.contains(l)) {
            this.m_commandListeners.add(l);
        }
    }

    public void removeCommandListener(ICommandListener l) {
        if (l != null) {
            this.m_commandListeners.remove(l);
        }
    }

    public void dispatchStarted() {
        if (this.m_commandListeners != null && this.m_commandListeners.size() > 0) {
            ICommandListener listener = null;
            int i = 0;
            while (i < this.m_commandListeners.size()) {
                listener = this.m_commandListeners.get(i);
                listener.commandStarted();
                ++i;
            }
        }
    }

    public void dispatchFinished() {
        if (this.m_commandListeners != null && this.m_commandListeners.size() > 0) {
            ICommandListener listener = null;
            int i = 0;
            while (i < this.m_commandListeners.size()) {
                listener = this.m_commandListeners.get(i);
                listener.commandFinished();
                ++i;
            }
        }
    }

    public final synchronized void runCommand(IDLProcessProxy idl) {
        this.dispatchStarted();
        this.activate(idl);
        if (this.shouldUpdateDebugModel()) {
            AbstractIDLCommand.updateDebugModel(idl);
        }
        this.dispatchFinished();
        if (DMLAccess.exitDoneSeen(idl.getDebugID())) {
            this.setUpdateDebugModel(false);
            IDLProcessManager.exiting();
            IDLDTCorePlugin.performIDEExit();
        }
    }

    public abstract void activate(IIDLProcessProxy var1);

    public static void updateDebugModel(IIDLProcessProxy idl) {
        long id = idl.getDebugID();
        StackFramesDTO frames = new StackFramesDTO();
        DMLAccess.getStackFrameInformation(id, frames);
        SystemVariableDTO sysVars = new SystemVariableDTO();
        DMLAccess.getSystemVariableInformation(id, sysVars);
        HeapVariableDTO heapVars = new HeapVariableDTO();
        idl.getDebugTarget().suspendDebugModel(frames, sysVars, heapVars);
    }
}

