/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core.internal.statemgr;

import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.internal.statemgr.AbstractInterpreterState;
import com.rsi.idldt.core.internal.statemgr.InterpreterStateMachine;
import com.rsi.idldt.core.interp.IInterpreterCommands;
import com.rsi.jdml.IModalDialogInfo;
import com.rsi.jdml.KeyboardEvent;

public class StateIdle
extends AbstractInterpreterState {
    private static final int[] VALID_KEYS = new int[]{0x1000002, 0x1000001};

    public StateIdle(InterpreterStateMachine interpreter, IInterpreterCommands commandMgr) {
        super(interpreter, commandMgr);
    }

    public void commandStarted() {
        this.m_interpStateManager.setState(this.m_interpStateManager.getExecutingState());
    }

    public boolean isInitialized() {
        return true;
    }

    public boolean isIdle() {
        return true;
    }

    public boolean isExecuting() {
        return false;
    }

    public boolean isExecutingReset() {
        return false;
    }

    public boolean isExpectingKey() {
        return true;
    }

    public boolean isBufferingKeys() {
        return false;
    }

    protected int[] getValidKeys() {
        return VALID_KEYS;
    }

    public boolean isExpectingTextLine() {
        return true;
    }

    public boolean isBlocked() {
        return false;
    }

    public void sendTextLine(String s) {
        this.m_commandManager.queueExecuteString(s);
    }

    public void sendKey(KeyboardEvent key) {
        boolean arrowUp = key.getKeyCode() == 0x1000001;
        String command = this.m_commandManager.getRecallBuffer(arrowUp);
        IDLProcessManager.getActiveProcess().getCommandLineHandler().commandRecalled(command);
    }

    public String getStateName() {
        return "Idle";
    }

    public void requestIOLine(String prompt) {
        this.m_interpStateManager.setState(this.m_interpStateManager.getWaitForIOLineState());
    }

    public void requestKeyboardInput(int wait) {
        if (wait == 0) {
            this.m_interpStateManager.setState(this.m_interpStateManager.getWaitForKeyboardUseBufferState());
        } else {
            this.m_interpStateManager.setState(this.m_interpStateManager.getWaitForKeyboardState());
        }
    }

    public void requestModalResponse(IModalDialogInfo modalInfo) {
        this.m_interpStateManager.setState(this.m_interpStateManager.getWaitForModalConfirmState());
    }
}

