/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core.internal.statemgr;

import com.rsi.idldt.core.internal.statemgr.AbstractInterpreterState;
import com.rsi.idldt.core.internal.statemgr.InterpreterStateMachine;
import com.rsi.idldt.core.interp.IInterpreterCommands;
import com.rsi.jdml.CommandFinishedDTO;
import com.rsi.jdml.IModalDialogInfo;
import com.rsi.jdml.KeyboardEvent;

public class StateExecuting
extends AbstractInterpreterState {
    private boolean m_isResetting = false;

    public StateExecuting(InterpreterStateMachine interpreter, IInterpreterCommands dispatcher) {
        super(interpreter, dispatcher);
    }

    public void commandFinished(CommandFinishedDTO err) {
        this.m_interpStateManager.setState(this.m_interpStateManager.getIdleState());
    }

    public void resetDone() {
        this.setExecutingReset(false);
        this.m_commandManager.reset();
    }

    public void requestIOLine(String prompt) {
        this.m_interpStateManager.setState(this.m_interpStateManager.getWaitForIOLineState());
    }

    public void requestProgramLine() {
        this.m_interpStateManager.setState(this.m_interpStateManager.getWaitForProgramLineState());
    }

    public void requestKeyboardInput(int wait) {
        if (wait == 0) {
            this.m_interpStateManager.setState(this.m_interpStateManager.getWaitForKeyboardUseBufferState());
        } else {
            this.m_interpStateManager.setState(this.m_interpStateManager.getWaitForKeyboardState());
        }
    }

    public void requestMoreResponse() {
        this.m_interpStateManager.setState(this.m_interpStateManager.getWaitForMoreState());
    }

    public void requestModalResponse(IModalDialogInfo modalInfo) {
        this.m_interpStateManager.setState(this.m_interpStateManager.getWaitForModalConfirmState());
    }

    public void requestResetConfirm() {
        this.m_interpStateManager.setState(this.m_interpStateManager.getWaitForResetConfirmState());
    }

    public boolean isInitialized() {
        return true;
    }

    public boolean isIdle() {
        return false;
    }

    public boolean isExecuting() {
        return true;
    }

    public boolean isExecutingReset() {
        return this.m_isResetting;
    }

    public boolean isExpectingKey() {
        return false;
    }

    public boolean isBufferingKeys() {
        return true;
    }

    public boolean isKeyValid(KeyboardEvent e) {
        int keyCode = e.getKeyCode();
        char c = e.getCharacter();
        if ((keyCode & 0x1000000) != 0) {
            return false;
        }
        return c >= ' ';
    }

    public boolean isExpectingTextLine() {
        return true;
    }

    public boolean isBlocked() {
        return false;
    }

    public void sendTextLine(String s) {
        this.m_commandManager.queueExecuteString(s);
    }

    public String getStateName() {
        return "Executing";
    }

    public void setExecutingReset(boolean b) {
        this.m_isResetting = b;
    }
}

