/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core.internal.statemgr;

import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.core.internal.IDLProcessProxy;
import com.rsi.idldt.core.internal.statemgr.AbstractInterpreterState;
import com.rsi.idldt.core.internal.statemgr.StateExecuting;
import com.rsi.idldt.core.internal.statemgr.StateIdle;
import com.rsi.idldt.core.internal.statemgr.StateInitializing;
import com.rsi.idldt.core.internal.statemgr.StateWaitingForIOLine;
import com.rsi.idldt.core.internal.statemgr.StateWaitingForKeyboard;
import com.rsi.idldt.core.internal.statemgr.StateWaitingForKeyboardUseBuffer;
import com.rsi.idldt.core.internal.statemgr.StateWaitingForModalConfirm;
import com.rsi.idldt.core.internal.statemgr.StateWaitingForMore;
import com.rsi.idldt.core.internal.statemgr.StateWaitingForProgramLine;
import com.rsi.idldt.core.internal.statemgr.StateWaitingForResetConfirm;
import com.rsi.idldt.core.interp.IInterpreterCommands;
import com.rsi.idldt.core.interp.IInterpreterStateChangeListener;
import com.rsi.idldt.core.interp.IInterpreterStateTracker;
import com.rsi.idldt.core.utils.Tracer;
import com.rsi.jdml.CommandFinishedDTO;
import com.rsi.jdml.DebugInfoDTO;
import com.rsi.jdml.IDLVariable;
import com.rsi.jdml.IModalDialogInfo;
import com.rsi.jdml.KeyboardEvent;
import java.util.AbstractList;
import java.util.Vector;

public class InterpreterStateMachine
implements IInterpreterStateTracker {
    AbstractInterpreterState initializingState;
    AbstractInterpreterState idleState;
    AbstractInterpreterState executingState;
    AbstractInterpreterState waitForIOLineState;
    AbstractInterpreterState waitForKeyboardState;
    AbstractInterpreterState waitForKeyboardUseBufferState;
    AbstractInterpreterState waitForMoreState;
    AbstractInterpreterState waitForResetConfirmState;
    AbstractInterpreterState waitForModalConfirmState;
    AbstractInterpreterState waitForProgramLineState;
    AbstractInterpreterState m_state;
    AbstractInterpreterState m_prevState;
    String m_prompt;
    IInterpreterCommands m_commandManager;
    IDLProcessProxy m_idlProcess;
    private final AbstractList<IInterpreterStateChangeListener> m_stateChangeListeners = new Vector<IInterpreterStateChangeListener>(1);

    public InterpreterStateMachine(IDLProcessProxy idl) {
        this.m_idlProcess = idl;
        this.m_commandManager = this.m_idlProcess.getCommandManager();
        this.initializingState = new StateInitializing(this, this.m_commandManager);
        this.idleState = new StateIdle(this, this.m_commandManager);
        this.executingState = new StateExecuting(this, this.m_commandManager);
        this.waitForIOLineState = new StateWaitingForIOLine(this, this.m_commandManager);
        this.waitForKeyboardState = new StateWaitingForKeyboard(this, this.m_commandManager);
        this.waitForKeyboardUseBufferState = new StateWaitingForKeyboardUseBuffer(this, this.m_commandManager);
        this.waitForMoreState = new StateWaitingForMore(this, this.m_commandManager);
        this.waitForModalConfirmState = new StateWaitingForModalConfirm(this, this.m_commandManager);
        this.waitForResetConfirmState = new StateWaitingForResetConfirm(this, this.m_commandManager);
        this.waitForProgramLineState = new StateWaitingForProgramLine(this, this.m_commandManager);
        this.m_state = this.initializingState;
    }

    public void setState(AbstractInterpreterState state, boolean savePrevious) {
        this.m_state.leavingState();
        this.m_prevState = savePrevious ? this.m_state : null;
        this.m_state = state;
        this.dispatchStateChanged();
    }

    public void setState(AbstractInterpreterState state) {
        this.setState(state, true);
    }

    public void restoreState() {
        if (this.m_prevState != null) {
            this.setState(this.m_prevState, false);
        } else {
            Tracer.warning("Cannot restore to null state!", 25);
        }
    }

    public void leavingState() {
    }

    public IIDLProcessProxy getIDLProxy() {
        return this.m_idlProcess;
    }

    public void sendTextLine(String s) {
        this.m_state.sendTextLine(s);
    }

    public void sendKey(KeyboardEvent key) {
        this.m_state.sendKey(key);
    }

    public void answerModalMessage(boolean answer) {
        this.m_state.answerModalMessage(answer);
    }

    public void answerResetSessionConfirm(boolean answer) {
        this.m_state.answerResetSessionConfirm(answer);
    }

    public void initDone() {
        this.m_state.initDone();
    }

    public void commandStarted() {
        this.m_state.commandStarted();
    }

    public void commandFinished(CommandFinishedDTO err) {
        this.m_state.commandFinished(err);
    }

    public void exitDone() {
        this.m_state.exitDone();
    }

    public boolean exitDoneSeen() {
        return this.m_state.exitDoneSeen();
    }

    public void idlOutput(String s) {
        this.m_state.idlOutput(s);
    }

    public void deathHint() {
        this.m_state.deathHint();
    }

    public void processGone() {
        this.m_state.processGone();
    }

    public void resetDone() {
        this.m_state.resetDone();
    }

    public void promptChanged(String p) {
    }

    public void pathChanged(String p) {
    }

    public void workingDirChanged(String newDir) {
    }

    public void mainVariableDeleted(String varName) {
    }

    public void idlNotify(String notifyId, IDLVariable parm1, IDLVariable parm2) {
    }

    public void breakpointMoved(DebugInfoDTO dto) {
    }

    public void showBreakpoint(DebugInfoDTO dto) {
    }

    public void requestIOLine(String prompt) {
        this.m_state.requestIOLine(prompt);
    }

    public void requestMoreResponse() {
        this.m_state.requestMoreResponse();
    }

    public void requestGetKeyboard(int wait) {
        this.m_state.requestKeyboardInput(wait);
    }

    public void requestProgramLine() {
        this.m_state.requestProgramLine();
    }

    public void requestOpenFile(String filePath) {
        this.m_state.requestOpenFile(filePath);
    }

    public void alertCompileFile(String filePath) {
        this.m_state.alertCompileFile(filePath);
    }

    public void requestModalResponse(IModalDialogInfo modalInfo) {
        this.m_state.requestModalResponse(modalInfo);
    }

    public void requestResetConfirm() {
        this.m_state.requestResetConfirm();
    }

    public boolean isInitialized() {
        return this.m_state.isInitialized();
    }

    public boolean isIdle() {
        return this.m_state.isIdle();
    }

    public boolean isExecuting() {
        return this.m_state.isExecuting();
    }

    public boolean isExecutingReset() {
        return this.m_state.isExecutingReset();
    }

    public boolean isExpectingKey() {
        return this.m_state.isExpectingKey();
    }

    public boolean useBufferedKeys() {
        return this.m_state.useBufferedKeys();
    }

    public boolean isBufferingKeys() {
        return this.m_state.isBufferingKeys();
    }

    public boolean isKeyValid(KeyboardEvent key) {
        return this.m_state.isKeyValid(key);
    }

    public boolean isExpectingTextLine() {
        return this.m_state.isExpectingTextLine();
    }

    public boolean isBlocked() {
        return this.m_state.isBlocked();
    }

    public void addStateChangeListener(IInterpreterStateChangeListener l) {
        if (l != null && !this.m_stateChangeListeners.contains(l)) {
            this.m_stateChangeListeners.add(l);
        }
        this.dispatchStateChanged();
    }

    public void removeStateChangeListener(IInterpreterStateChangeListener l) {
        if (l != null) {
            this.m_stateChangeListeners.remove(l);
        }
    }

    private void dispatchStateChanged() {
        if (this.m_stateChangeListeners != null && this.m_stateChangeListeners.size() > 0) {
            IInterpreterStateChangeListener listener = null;
            int i = 0;
            while (i < this.m_stateChangeListeners.size()) {
                listener = this.m_stateChangeListeners.get(i);
                listener.stateChanged(this.m_idlProcess);
                ++i;
            }
        }
    }

    protected AbstractInterpreterState getInitializinggState() {
        return this.initializingState;
    }

    protected AbstractInterpreterState getExecutingState() {
        return this.executingState;
    }

    protected AbstractInterpreterState getWaitForKeyboardState() {
        return this.waitForKeyboardState;
    }

    public AbstractInterpreterState getWaitForKeyboardUseBufferState() {
        return this.waitForKeyboardUseBufferState;
    }

    protected AbstractInterpreterState getWaitForMoreState() {
        return this.waitForMoreState;
    }

    protected AbstractInterpreterState getIdleState() {
        return this.idleState;
    }

    protected AbstractInterpreterState getWaitForIOLineState() {
        return this.waitForIOLineState;
    }

    protected AbstractInterpreterState getWaitForProgramLineState() {
        return this.waitForProgramLineState;
    }

    protected AbstractInterpreterState getWaitForResetConfirmState() {
        return this.waitForResetConfirmState;
    }

    protected AbstractInterpreterState getWaitForModalConfirmState() {
        return this.waitForModalConfirmState;
    }

    public String getStateName() {
        return this.m_state.getStateName();
    }

    public void setIDLOutputContext(int context, Object obj) {
        this.m_state.setIDLOutputContext(context, obj);
    }

    public void interpreterStopped(String newPath, String newModule, int lineno, int errCode) {
        this.m_state.interpreterStopped(newPath, newModule, lineno, errCode);
    }

    public void helpTopic(String topic) {
    }

    public void variablesChanged() {
    }
}

