/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core.internal.statemgr;

import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.core.internal.statemgr.InterpreterStateMachine;
import com.rsi.idldt.core.interp.IInterpreterCommands;
import com.rsi.idldt.core.interp.IInterpreterStateTracker;
import com.rsi.idldt.core.utils.Tracer;
import com.rsi.jdml.CommandFinishedDTO;
import com.rsi.jdml.DebugInfoDTO;
import com.rsi.jdml.IDLVariable;
import com.rsi.jdml.IModalDialogInfo;
import com.rsi.jdml.KeyboardEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInterpreterState
implements IInterpreterStateTracker {
    protected InterpreterStateMachine m_interpStateManager;
    protected IInterpreterCommands m_commandManager;

    public AbstractInterpreterState(InterpreterStateMachine stateManager, IInterpreterCommands commandMgr) {
        this.m_interpStateManager = stateManager;
        this.m_commandManager = commandMgr;
    }

    @Override
    public void interpreterStopped(String newPath, String newModule, int lineno, int errCode) {
    }

    @Override
    public IIDLProcessProxy getIDLProxy() {
        return this.m_interpStateManager.getIDLProxy();
    }

    @Override
    public void leavingState() {
    }

    @Override
    public void sendTextLine(String s) {
        this.handleInvalidRequest(this.getClass());
    }

    @Override
    public void sendKey(KeyboardEvent key) {
        this.handleInvalidRequest(this.getClass());
    }

    @Override
    public void answerModalMessage(boolean answer) {
        this.handleInvalidRequest(this.getClass());
    }

    @Override
    public void answerResetSessionConfirm(boolean answer) {
        this.handleInvalidRequest(this.getClass());
    }

    @Override
    public void initDone() {
        this.handleInvalidRequest(this.getClass());
    }

    @Override
    public void commandStarted() {
        this.handleInvalidRequest(this.getClass());
    }

    @Override
    public void commandFinished(CommandFinishedDTO err) {
        this.handleInvalidRequest(this.getClass());
    }

    @Override
    public void requestIOLine(String prompt) {
        this.handleInvalidRequest(this.getClass());
    }

    public void requestKeyboardInput(int wait) {
        this.handleInvalidRequest(this.getClass());
    }

    @Override
    public void requestMoreResponse() {
        this.handleInvalidRequest(this.getClass());
    }

    @Override
    public void requestModalResponse(IModalDialogInfo modalInfo) {
        this.handleInvalidRequest(this.getClass());
    }

    @Override
    public void requestOpenFile(String filePath) {
    }

    @Override
    public void alertCompileFile(String filePath) {
    }

    @Override
    public void requestResetConfirm() {
        this.handleInvalidRequest(this.getClass());
    }

    @Override
    public void deathHint() {
    }

    @Override
    public void processGone() {
    }

    @Override
    public void exitDone() {
    }

    @Override
    public boolean exitDoneSeen() {
        return false;
    }

    @Override
    public void idlOutput(String s) {
    }

    @Override
    public void promptChanged(String p) {
    }

    @Override
    public void pathChanged(String p) {
    }

    @Override
    public void workingDirChanged(String newDir) {
    }

    @Override
    public void mainVariableDeleted(String varName) {
    }

    @Override
    public void idlNotify(String notifyId, IDLVariable parm1, IDLVariable parm2) {
    }

    @Override
    public void breakpointMoved(DebugInfoDTO dto) {
    }

    @Override
    public void showBreakpoint(DebugInfoDTO dto) {
    }

    @Override
    public void requestGetKeyboard(int flags) {
        this.handleInvalidRequest(this.getClass());
    }

    @Override
    public void requestProgramLine() {
        this.handleInvalidRequest(this.getClass());
    }

    @Override
    public void resetDone() {
        this.handleInvalidRequest(this.getClass());
    }

    protected int[] getValidKeys() {
        return null;
    }

    @Override
    public boolean isKeyValid(KeyboardEvent e) {
        int key = e.getKeyCode();
        boolean valid = false;
        int[] valid_keys = this.getValidKeys();
        if (valid_keys == null) {
            valid = true;
        } else {
            int i = 0;
            while (i < valid_keys.length) {
                if (key == valid_keys[i]) {
                    valid = true;
                    break;
                }
                ++i;
            }
        }
        return valid;
    }

    @Override
    public boolean useBufferedKeys() {
        return false;
    }

    private void handleInvalidRequest(Class<? extends AbstractInterpreterState> cls) {
        Tracer.warning("Invalid request made while in m_state " + cls.getName() + " " + Thread.currentThread(), 25);
    }

    public String toString() {
        String className = this.getClass().getName();
        return className.substring(className.lastIndexOf(46) + 1);
    }

    @Override
    public void setIDLOutputContext(int context, Object obj) {
    }

    @Override
    public void helpTopic(String topic) {
    }

    @Override
    public void variablesChanged() {
    }
}

