/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core.internal.projects;

import com.rsi.idldt.core.projects.IIDLProjectManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class WorkspaceResourceStartupVisitor
implements IResourceVisitor {
    private IIDLProjectManager m_projectManager;
    private IProgressMonitor m_progressMonitor;

    public WorkspaceResourceStartupVisitor(IIDLProjectManager projectManager) {
        this(projectManager, null);
    }

    public WorkspaceResourceStartupVisitor(IIDLProjectManager projectManager, IProgressMonitor processMonitor) {
        this.m_projectManager = projectManager;
        this.m_progressMonitor = processMonitor;
    }

    public boolean visit(IResource resource) throws CoreException {
        boolean visitChildren = true;
        if (resource instanceof IProject) {
            visitChildren = this.m_projectManager.addProject((IProject)resource);
        } else if (resource instanceof IFolder) {
            this.m_projectManager.addFolder((IFolder)resource);
        } else if (resource instanceof IFile) {
            this.m_projectManager.addCompilationUnit((IFile)resource);
            this.showProgress();
        }
        return visitChildren;
    }

    private void showProgress() {
        if (this.m_progressMonitor != null) {
            this.m_progressMonitor.worked(1);
        }
    }
}

