/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core.internal.projects;

import com.rsi.idldt.core.internal.projects.WorkspaceResourceChangeDeltaVisitor;
import com.rsi.idldt.core.projects.IIDLProjectManager;
import com.rsi.idldt.core.utils.Tracer;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class WorkspaceResourceChangeListener
implements IResourceChangeListener {
    private IIDLProjectManager m_projectManager;
    private IProgressMonitor m_progressMonitor;
    ArrayList<Boolean> m_resourceDeleted = new ArrayList();

    public WorkspaceResourceChangeListener(IIDLProjectManager pm) {
        this.m_projectManager = pm;
    }

    protected void printFlags(int flags) {
        if ((flags & 0x100) == 1) {
            System.out.println("Content Changed");
        }
        if ((flags & 1) == 1) {
            System.out.println("Resource Added");
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.printEventInfo(event);
        WorkspaceResourceChangeDeltaVisitor deltaVisitor = null;
        switch (event.getType()) {
            case 1: {
                deltaVisitor = new WorkspaceResourceChangeDeltaVisitor(this.m_projectManager, this.m_progressMonitor);
                break;
            }
            case 8: {
                Object o = event.getSource();
                if (o instanceof IProject) {
                    this.m_projectManager.preBuildProject((IProject)o);
                    break;
                }
                this.m_projectManager.preBuildProject(null);
                break;
            }
            case 16: {
                Object o = event.getSource();
                if (o instanceof IProject) {
                    this.m_projectManager.postBuildProject((IProject)o);
                    break;
                }
                this.m_projectManager.postBuildProject(null);
            }
        }
        if (deltaVisitor != null) {
            try {
                event.getDelta().accept(deltaVisitor);
                this.m_projectManager.commit();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) {
                if (delta.getKind() == 2) {
                    WorkspaceResourceChangeListener.this.m_resourceDeleted.add(new Boolean(true));
                }
                return true;
            }
        };
        try {
            if (event.getDelta() != null) {
                event.getDelta().accept(visitor);
            }
        }
        catch (CoreException coreException) {}
        if (this.m_resourceDeleted.size() > 0) {
            this.m_resourceDeleted.clear();
            WorkspaceResourceChangeListener.updateProblemMarkers();
        }
    }

    public static void updateProblemMarkers() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        final IDecoratorManager decoratorManager = workbench.getDecoratorManager();
        workbench.getDisplay().asyncExec(new Runnable(){

            public void run() {
                decoratorManager.update("com.rsi.idldt.ui.problemsLabelDecorator");
            }
        });
    }

    private void printEventInfo(IResourceChangeEvent event) {
        String s;
        switch (event.getType()) {
            case 2: {
                s = "PRE_CLOSE";
                break;
            }
            case 4: {
                s = "PRE_DELETE";
                break;
            }
            case 8: {
                s = "PRE_BUILD";
                break;
            }
            case 16: {
                s = "POST_BUILD";
                break;
            }
            case 1: {
                s = "POST_CHANGE";
                break;
            }
            default: {
                s = "UNKNOWN";
            }
        }
        IResource res = event.getResource();
        this.printProjectMessage(String.valueOf(s) + ": " + (res != null ? res.getFullPath().toString() : "?"));
    }

    public void setProgressMonitor(IProgressMonitor pm) {
        this.m_progressMonitor = pm;
    }

    private void printProjectMessage(String s) {
        if (Tracer.TRACE_RESOURCE_CHANGES) {
            System.out.println("Projects: " + s);
        }
    }
}

