/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core.internal.projects;

import com.rsi.idldt.core.projects.IIDLProjectManager;
import com.rsi.idldt.core.utils.Tracer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class WorkspaceResourceChangeDeltaVisitor
implements IResourceDeltaVisitor {
    private IIDLProjectManager m_projectManager;
    private IProgressMonitor m_progressMonitor;

    public WorkspaceResourceChangeDeltaVisitor(IIDLProjectManager projectManager) {
        this(projectManager, null);
    }

    public WorkspaceResourceChangeDeltaVisitor(IIDLProjectManager projectManager, IProgressMonitor progressMonitor) {
        this.m_projectManager = projectManager;
        this.m_progressMonitor = progressMonitor;
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource res = delta.getResource();
        boolean visitChildren = true;
        this.printDeltaInfo(delta);
        if (res instanceof IProject) {
            IProject p = (IProject)res;
            switch (delta.getKind()) {
                case 1: {
                    visitChildren = this.m_projectManager.addProject(p);
                    break;
                }
                case 2: {
                    visitChildren = this.m_projectManager.removeProject(p);
                    break;
                }
                case 4: {
                    visitChildren = this.m_projectManager.changeProject(p, (delta.getFlags() & 0x4000) != 0, false);
                }
            }
        } else if (res instanceof IFolder) {
            IFolder f = (IFolder)res;
            switch (delta.getKind()) {
                case 1: {
                    this.m_projectManager.addFolder(f);
                    break;
                }
                case 2: {
                    this.m_projectManager.removeFolder(f);
                    break;
                }
                case 4: {
                    this.m_projectManager.changeFolder(f);
                }
            }
        } else if (res instanceof IFile) {
            IFile f = (IFile)res;
            switch (delta.getKind()) {
                case 1: {
                    this.m_projectManager.addCompilationUnit(f);
                    this.showProgress();
                    break;
                }
                case 2: {
                    this.m_projectManager.removeCompilationUnit(f);
                    break;
                }
                case 4: {
                    this.m_projectManager.changeCompilationUnit(f, (delta.getFlags() & 0x100) != 0);
                }
            }
        }
        return visitChildren;
    }

    private void showProgress() {
        if (this.m_progressMonitor != null) {
            this.m_progressMonitor.worked(1);
        }
    }

    private void printDeltaInfo(IResourceDelta delta) {
        this.printProjectMessage(String.valueOf(this.kindToString(delta.getKind())) + " " + this.resourceKindToString(delta.getResource().getType()) + ": " + delta.getResource().getFullPath());
        int flags = delta.getFlags();
        String s = "";
        if ((flags & 0x100) != 0) {
            s = String.valueOf(s) + " CONTENT";
        }
        if ((flags & 0x100000) != 0) {
            s = String.valueOf(s) + " ENCODING";
        }
        if ((flags & 0x80000) != 0) {
            s = String.valueOf(s) + " DESCRIPTION";
        }
        if ((flags & 0x4000) != 0) {
            s = String.valueOf(s) + " OPEN";
        }
        if ((flags & 0x8000) != 0) {
            s = String.valueOf(s) + " TYPE";
        }
        if ((flags & 0x10000) != 0) {
            s = String.valueOf(s) + " SYNC";
        }
        if ((flags & 0x20000) != 0) {
            s = String.valueOf(s) + " MARKERS";
        }
        if ((flags & 0x40000) != 0) {
            s = String.valueOf(s) + " REPLACED";
        }
        if ((flags & 0x2000) != 0) {
            s = String.valueOf(s) + " MOVED_TO";
        }
        if ((flags & 0x1000) != 0) {
            s = String.valueOf(s) + " MOVED_FROM";
        }
        this.printProjectMessage("\tFlags:" + s);
        if ((flags & 0x20000) != 0) {
            IMarkerDelta[] markerDelta = delta.getMarkerDeltas();
            int i = 0;
            while (i < markerDelta.length) {
                IMarker marker = markerDelta[i].getMarker();
                String markerString = "marker does not exist";
                try {
                    if (marker.exists()) {
                        markerString = "type: " + marker.getType() + ", ";
                        markerString = String.valueOf(markerString) + "attributes: ";
                        markerString = marker.getAttributes() != null ? String.valueOf(markerString) + marker.getAttributes().values() : String.valueOf(markerString) + "none";
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                this.printProjectMessage("\tmarkerDelta[" + i + "]: " + this.kindToString(markerDelta[i].getKind()) + " " + markerString);
                ++i;
            }
        }
    }

    private String kindToString(int kind) {
        String s;
        switch (kind) {
            case 1: {
                s = "Added";
                break;
            }
            case 2: {
                s = "Removed";
                break;
            }
            case 4: {
                s = "Changed";
                break;
            }
            default: {
                s = "Did something to";
            }
        }
        return s;
    }

    private String resourceKindToString(int type) {
        switch (type) {
            case 8: {
                return "root";
            }
            case 4: {
                return "project";
            }
            case 2: {
                return "folder";
            }
            case 1: {
                return "file";
            }
        }
        return "?";
    }

    private void printProjectMessage(String s) {
        if (Tracer.TRACE_RESOURCE_CHANGES) {
            System.out.println("Projects: " + s);
        }
    }
}

