/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core.internal.projects;

import com.rsi.idldt.core.IDLProjectNature;
import com.rsi.idldt.core.IDLProjectProperties;
import com.rsi.idldt.core.IIDLPathListener;
import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.core.dom.IIDLDOMManager;
import com.rsi.idldt.core.internal.dom.IDLDOMManager;
import com.rsi.idldt.core.internal.projects.IDLPathManager;
import com.rsi.idldt.core.internal.projects.PathDelta;
import com.rsi.idldt.core.internal.projects.WorkspaceResourceChangeListener;
import com.rsi.idldt.core.internal.projects.WorkspaceResourceStartupVisitor;
import com.rsi.idldt.core.projects.IIDLPathManager;
import com.rsi.idldt.core.projects.IIDLProjectManager;
import com.rsi.idldt.core.utils.Tracer;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDLProjectManager
implements IIDLProjectManager,
IIDLPathListener {
    private IIDLPathManager m_pathManager;
    IIDLDOMManager m_DOMManager;
    private WorkspaceResourceChangeListener m_resourceChangeListener;

    public IDLProjectManager(IIDLProcessProxy idl) {
        this.m_pathManager = new IDLPathManager(idl);
        this.m_DOMManager = new IDLDOMManager();
        idl.addIDLPathListener(this);
    }

    @Override
    public void initialize() {
        new Thread(null, new Runnable(){

            public void run() {
                IDLProjectManager.this.m_DOMManager.initialize();
                DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)IDLProjectManager.this.m_DOMManager);
                IDLProjectManager.this.walkWorkspace();
                IDLProjectManager.this.createResourceChangeListener();
            }
        }, "Project Manager Initializer").start();
    }

    void walkWorkspace() {
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            root.accept((IResourceVisitor)new WorkspaceResourceStartupVisitor(this));
            this.commit();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void reset() {
        this.m_pathManager.reset();
    }

    @Override
    public void terminate() {
        this.m_DOMManager.serialize();
    }

    @Override
    public void idlPathChanged(IIDLProcessProxy process, String path) {
        Vector<PathDelta> deltas = this.m_pathManager.handlePathChange(process, path);
        if (deltas != null) {
            this.updateDOMWithPathChanges(deltas);
        }
    }

    private void updateDOMWithPathChanges(Vector<PathDelta> deltas) {
        int n = deltas.size();
        int i = 0;
        while (i < n) {
            PathDelta d = deltas.get(i);
            String directory = d.getPath();
            switch (d.getKind()) {
                case 1: {
                    this.m_DOMManager.addDirectory(directory);
                    break;
                }
                case 2: {
                    this.m_DOMManager.removeDirectory(directory);
                    break;
                }
            }
            ++i;
        }
    }

    @Override
    public void setCurrentWorkingDir(String cwd) {
        Vector<PathDelta> deltas = this.m_pathManager.setCurrentWorkingDirectory(cwd);
        if (deltas != null) {
            this.updateDOMWithPathChanges(deltas);
        }
    }

    void createResourceChangeListener() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.m_resourceChangeListener = new WorkspaceResourceChangeListener(this);
        workspace.addResourceChangeListener((IResourceChangeListener)this.m_resourceChangeListener, 31);
    }

    @Override
    public void commit() {
        this.m_pathManager.commit();
    }

    @Override
    public void setProgressMonitor(IProgressMonitor pm) {
        if (this.m_resourceChangeListener != null) {
            this.m_resourceChangeListener.setProgressMonitor(pm);
        }
    }

    @Override
    public boolean addProject(IProject project) {
        this.printProjectMessage("+P: " + project.getName());
        if (project.isOpen()) {
            if (this.isManaged(project)) {
                this.m_pathManager.addResource((IResource)project);
            }
            this.m_DOMManager.addResource((IResource)project);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeProject(IProject project) {
        this.printProjectMessage("-P: " + project.getName());
        this.m_pathManager.removeResource((IResource)project);
        this.m_DOMManager.removeResource((IResource)project);
        return true;
    }

    @Override
    public boolean changeProject(IProject project, boolean openChanged, boolean propertyChanged) {
        this.printProjectMessage("*P: " + project.getName());
        boolean visitChildren = true;
        if (openChanged) {
            if (project.isOpen()) {
                this.verifyIDLNature(project);
                visitChildren = this.addProject(project);
            } else {
                visitChildren = this.removeProject(project);
            }
        } else if (propertyChanged) {
            if (this.isManaged(project)) {
                this.m_pathManager.addResource((IResource)project);
            } else {
                this.m_pathManager.removeResource((IResource)project);
            }
        } else {
            boolean isOnPath;
            this.verifyIDLNature(project);
            if (this.isManaged(project) && !(isOnPath = this.m_pathManager.isOnPath((IResource)project))) {
                this.m_pathManager.addResource((IResource)project);
            }
        }
        return visitChildren;
    }

    @Override
    public void preBuildProject(IProject project) {
    }

    @Override
    public void postBuildProject(IProject project) {
    }

    @Override
    public void addFolder(IFolder folder) {
        this.printProjectMessage("+F: " + folder.getName());
        IProject project = folder.getProject();
        if (project.isOpen() && this.isManaged(project)) {
            this.m_pathManager.addResource((IResource)folder);
        }
        this.m_DOMManager.addResource((IResource)folder);
    }

    @Override
    public void removeFolder(IFolder folder) {
        this.printProjectMessage("-F: " + folder.getName());
        this.m_pathManager.removeResource((IResource)folder);
        this.m_DOMManager.removeResource((IResource)folder);
    }

    @Override
    public void changeFolder(IFolder folder) {
        this.printProjectMessage("*F: " + folder.getName());
        if (this.isManaged(folder.getProject())) {
            this.m_pathManager.addResource((IResource)folder);
        } else {
            this.m_pathManager.removeResource((IResource)folder);
        }
    }

    @Override
    public void addCompilationUnit(IFile file) {
        this.printProjectMessage("+L: " + file.getName());
        if (this.isManaged(file.getProject()) && this.isProOrSaveFile((IResource)file)) {
            this.m_pathManager.clearPathCache();
        }
        this.m_DOMManager.addResource((IResource)file);
    }

    @Override
    public void removeCompilationUnit(IFile file) {
        this.printProjectMessage("-L: " + file.getName());
        this.m_DOMManager.removeResource((IResource)file);
    }

    @Override
    public void changeCompilationUnit(IFile file, boolean contentChanged) {
        this.printProjectMessage("*L: " + file.getName());
        if (contentChanged) {
            this.m_DOMManager.parseCompilationUnit(file);
        }
    }

    @Override
    public void touch(IProject p) {
        IResourceVisitor visitor = new IResourceVisitor(){

            public boolean visit(IResource r) {
                switch (r.getType()) {
                    case 4: {
                        IDLProjectManager.this.changeProject((IProject)r, false, true);
                        break;
                    }
                    case 2: {
                        IDLProjectManager.this.changeFolder((IFolder)r);
                        break;
                    }
                }
                return true;
            }
        };
        try {
            p.accept(visitor);
            this.commit();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isOnPath(IResource resource) {
        if (resource instanceof IProject || resource instanceof IFolder) {
            return this.m_pathManager.isOnPath(resource);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean containsProOrSave(IContainer c) {
        try {
            IResource[] children = c.members();
            int i = 0;
            while (true) {
                if (i >= children.length) {
                    return false;
                }
                if (children[i] instanceof IContainer ? this.containsProOrSave((IContainer)children[i]) : this.isProOrSaveFile(children[i])) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    private boolean isProOrSaveFile(IResource r) {
        String extension;
        return r.getType() == 1 && (extension = r.getFileExtension()) != null && ((extension = extension.toUpperCase()).compareTo("PRO") == 0 || extension.compareTo("SAV") == 0);
    }

    private void verifyIDLNature(final IProject project) {
        if (IDLProjectNature.getIDLNature(project) == null && this.containsProOrSave((IContainer)project)) {
            WorkspaceJob job = new WorkspaceJob("IDL Project Nature"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    IDLProjectNature.setIDLNature(project);
                    return Status.OK_STATUS;
                }
            };
            ISchedulingRule rule = ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule((IResource)project.getWorkspace().getRoot());
            job.setRule(rule);
            job.schedule();
        }
    }

    private boolean isManaged(IProject p) {
        IDLProjectNature nature = IDLProjectNature.getIDLNature(p);
        if (nature != null) {
            IDLProjectProperties props = nature.getIDLProjectProperties();
            return props.isProjectPathManaged();
        }
        return false;
    }

    @Override
    public IIDLDOMManager getDOMManager() {
        return this.m_DOMManager;
    }

    @Override
    public IIDLPathManager getPathManager() {
        return this.m_pathManager;
    }

    @Override
    public void clear() {
        this.m_DOMManager.clear();
        this.m_pathManager.clear();
    }

    private void printProjectMessage(String s) {
        if (Tracer.TRACE_RESOURCE_CHANGES) {
            System.out.println("Projects: " + s);
        }
    }
}

