/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core.internal.projects;

import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.core.internal.interp.commands.InducePathChangeCommand;
import com.rsi.idldt.core.internal.projects.PathDelta;
import com.rsi.idldt.core.projects.IIDLPathManager;
import com.rsi.jdml.DMLAccess;
import com.rsi.jdml.IDLVariable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDLPathManager
implements IIDLPathManager {
    private final String ID_ONPATH_DECORATOR = "com.rsi.idldt.core.ui.onPathDecorator";
    private IIDLProcessProxy m_processProxy;
    private TreeMap<String, String> m_pathMap;
    private Vector<String> m_pendingAdditions;
    private Vector<String> m_pendingDeletions;
    private boolean m_pendingPathCacheClear;
    private Vector<String> m_bangPath;
    private String m_currentWorkingDirectory = "";
    private final String m_separator = File.pathSeparator;
    private InducePathChangeCommand m_transaction;
    private static int MAX_BUFF_SIZE = 4000;

    public IDLPathManager(IIDLProcessProxy idl) {
        this.m_processProxy = idl;
        this.m_pathMap = new TreeMap();
        this.m_pendingAdditions = new Vector(100, 100);
        this.m_pendingDeletions = new Vector(100, 100);
        this.m_bangPath = new Vector(100, 100);
    }

    @Override
    public void addResource(IResource r) {
        String canonicalPath;
        if ((r instanceof IProject || r instanceof IFolder) && !this.isManaged(r) && (canonicalPath = this.addToMap(r)) != null) {
            this.m_pendingAdditions.add(canonicalPath);
            this.m_pendingDeletions.remove(canonicalPath);
        }
    }

    @Override
    public void removeResource(IResource r) {
        String canonicalPath;
        if ((r instanceof IProject || r instanceof IFolder) && this.isManaged(r) && (canonicalPath = this.removeFromMap(r)) != null && !this.m_pathMap.containsValue(canonicalPath)) {
            this.m_pendingDeletions.add(canonicalPath);
            this.m_pendingAdditions.remove(canonicalPath);
        }
    }

    @Override
    public void clear() {
        this.m_pendingAdditions.clear();
        this.m_pendingDeletions.clear();
        this.m_pendingPathCacheClear = false;
        this.m_bangPath.clear();
    }

    @Override
    public void clearPathCache() {
        this.m_pendingPathCacheClear = true;
    }

    @Override
    public synchronized void commit() {
        if (this.m_pendingAdditions.size() > 0 || this.m_pendingDeletions.size() > 0) {
            this.m_transaction = new InducePathChangeCommand();
            this.m_transaction.addCommand("DEFSYSV, '!IDLDT_TempFilepath', ''");
            this.m_transaction.addCommand("!IDLDT_TempFilepath=EXPAND_PATH(PREF_GET('IDL_PATH'))", (Object)this, "doPathAddRemove");
            this.m_pendingPathCacheClear = false;
            this.m_processProxy.queueCommand(this.m_transaction);
        }
        if (this.m_pendingPathCacheClear) {
            this.m_processProxy.queueSilentExecuteString("PATH_CACHE,/CLEAR");
            this.m_pendingPathCacheClear = false;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean doPathAddRemove() {
        var = new IDLVariable();
        DMLAccess.getIDLVariable(this.m_processProxy.getDebugID(), "!IDLDT_TempFilepath", var);
        pathPref = var.getString();
        pathPrefs = pathPref != null ? pathPref.split(this.m_separator) : new String[]{};
        bangPath = (Vector)this.m_bangPath.clone();
        i = 0;
        ** GOTO lbl14
        {
            this.m_pendingDeletions.remove(pathPrefs[i]);
            do {
                if (this.m_pendingDeletions.contains(pathPrefs[i])) continue block0;
                ++i;
lbl14:
                // 2 sources

            } while (i < pathPrefs.length);
        }
        i = 0;
        while (i < this.m_pendingDeletions.size()) {
            p = this.m_pendingDeletions.get(i);
            while (bangPath.contains(p)) {
                bangPath.remove(p);
            }
            ++i;
        }
        i = 0;
        while (i < this.m_pendingAdditions.size()) {
            p = this.m_pendingAdditions.get(i);
            if (!bangPath.contains(p)) {
                bangPath.add(p);
            }
            ++i;
        }
        this.m_pendingAdditions.clear();
        this.m_pendingDeletions.clear();
        sep = "";
        sb = new StringBuffer("!IDLDT_TempFilepath='");
        i = 0;
        while (i < bangPath.size()) {
            nextPath = (String)bangPath.get(i);
            nextPath = nextPath.replaceAll("'", "''");
            if (sb.length() + nextPath.length() > IDLPathManager.MAX_BUFF_SIZE) {
                this.m_transaction.addCommand(sb.toString());
                sb.delete(0, sb.length());
                sb.append("!IDLDT_TempFilepath+='");
            }
            sb.append(sep);
            sb.append(nextPath);
            sep = this.m_separator;
            ++i;
        }
        sb.append("' & !PATH=!IDLDT_TempFilepath");
        this.m_transaction.addCommand(sb.toString());
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean appendMissingWorkbenchPaths(String[] paths) {
        bResult = false;
        workbenchPaths = new ArrayList<String>(this.m_pathMap.values());
        i = 0;
        ** GOTO lbl10
        {
            workbenchPaths.remove(paths[i]);
            do {
                if (workbenchPaths.contains(paths[i])) continue block0;
                ++i;
lbl10:
                // 2 sources

            } while (i < paths.length);
        }
        this.m_transaction = new InducePathChangeCommand();
        if (workbenchPaths.size() > 0) {
            sep = "";
            this.m_transaction.addCommand("DEFSYSV, '!IDLDT_TempFilepath', ''");
            sb = new StringBuffer("!IDLDT_TempFilepath='");
            i = 0;
            while (i < paths.length) {
                nextPath = paths[i];
                if ((nextPath = nextPath.replaceAll("'", "''")).length() > 0) {
                    if (sb.length() + nextPath.length() > IDLPathManager.MAX_BUFF_SIZE) {
                        this.m_transaction.addCommand(sb.toString());
                        sb.delete(0, sb.length());
                        sb.append("!IDLDT_TempFilepath+='");
                    }
                    sb.append(sep);
                    sb.append(nextPath);
                    sep = this.m_separator;
                }
                ++i;
            }
            i = 0;
            while (i < workbenchPaths.size()) {
                nextPath = workbenchPaths.get(i);
                nextPath = nextPath.replaceAll("'", "''");
                if (sb.length() + nextPath.length() > IDLPathManager.MAX_BUFF_SIZE) {
                    this.m_transaction.addCommand(sb.toString());
                    sb.delete(0, sb.length());
                    sb.append("!IDLDT_TempFilepath+='");
                }
                sb.append(sep);
                sb.append(nextPath);
                sep = this.m_separator;
                ++i;
            }
            sb.append("' & !PATH=!IDLDT_TempFilepath");
            this.m_transaction.addCommand(sb.toString());
            bResult = true;
        }
        this.m_processProxy.queueCommand(this.m_transaction);
        return bResult;
    }

    @Override
    public Vector<PathDelta> handlePathChange(IIDLProcessProxy process, String path) {
        String[] p;
        if (this.m_processProxy.isExecutingReset()) {
            return null;
        }
        String[] stringArray = p = path == null ? new String[]{} : path.split(this.m_separator);
        if (this.appendMissingWorkbenchPaths(p)) {
            return null;
        }
        Vector<PathDelta> deltas = new Vector<PathDelta>(100, 100);
        Vector prevPath = (Vector)this.m_bangPath.clone();
        int i = 0;
        while (i < p.length) {
            if (!this.isOnPath(p[i])) {
                deltas.add(new PathDelta(p[i], 1));
            }
            ++i;
        }
        this.rebuildPathList(p);
        int n = prevPath.size();
        int i2 = 0;
        while (i2 < n) {
            String prevDir = (String)prevPath.get(i2);
            if (!this.isOnPath(prevDir)) {
                deltas.add(new PathDelta(prevDir, 2));
            }
            ++i2;
        }
        this.updateDecorators();
        if (deltas.size() == 0) {
            return null;
        }
        return deltas;
    }

    @Override
    public synchronized boolean isOnPath(String dir) {
        return this.m_bangPath.contains(dir) || dir.equalsIgnoreCase(this.m_currentWorkingDirectory);
    }

    @Override
    public synchronized boolean isOnPath(IResource r) {
        String canonicalPath = this.getCanonicalPath(r);
        if (canonicalPath != null) {
            return this.isOnPath(canonicalPath);
        }
        return false;
    }

    private synchronized void rebuildPathList(String[] p) {
        this.m_bangPath.clear();
        int i = 0;
        while (i < p.length) {
            if (p[i].length() > 0) {
                this.m_bangPath.add(p[i]);
            }
            ++i;
        }
    }

    @Override
    public void reset() {
        this.m_processProxy.queueSilentExecuteString("!PATH=!PATH", false);
    }

    private void updateDecorators() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        final IDecoratorManager decoratorManager = workbench.getDecoratorManager();
        workbench.getDisplay().asyncExec(new Runnable(){

            public void run() {
                decoratorManager.update("com.rsi.idldt.core.ui.onPathDecorator");
            }
        });
    }

    @Override
    public Vector<PathDelta> setCurrentWorkingDirectory(String cwd) {
        if (cwd.equalsIgnoreCase(this.m_currentWorkingDirectory)) {
            return null;
        }
        Vector<PathDelta> deltas = new Vector<PathDelta>(2);
        if (!this.m_bangPath.contains(cwd)) {
            deltas.add(new PathDelta(cwd, 1));
        }
        if (this.m_currentWorkingDirectory != null && !this.m_bangPath.contains(this.m_currentWorkingDirectory)) {
            deltas.add(new PathDelta(this.m_currentWorkingDirectory, 2));
        }
        this.m_currentWorkingDirectory = cwd;
        this.updateDecorators();
        if (deltas.size() == 0) {
            return null;
        }
        return deltas;
    }

    private String addToMap(IResource r) {
        String workspacePath = this.getWorkspacePath(r);
        String canonicalPath = this.getCanonicalPath(r);
        this.m_pathMap.put(workspacePath, canonicalPath);
        return canonicalPath;
    }

    private String removeFromMap(IResource r) {
        String workspacePath = this.getWorkspacePath(r);
        String canonicalPath = this.m_pathMap.get(workspacePath);
        this.m_pathMap.remove(workspacePath);
        return canonicalPath;
    }

    private boolean isManaged(IResource r) {
        String workspacePath = this.getWorkspacePath(r);
        return this.m_pathMap.containsKey(workspacePath);
    }

    private String getWorkspacePath(IResource r) {
        return r.getFullPath().toOSString();
    }

    private String getCanonicalPath(IResource r) {
        IPath p = r.getLocation();
        File f = p.toFile();
        String s = null;
        try {
            s = f.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return s;
    }
}

