/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core.internal.parser;

import antlr.ANTLRHashString;
import antlr.ByteBuffer;
import antlr.CharBuffer;
import antlr.CharScanner;
import antlr.CharStreamException;
import antlr.CharStreamIOException;
import antlr.InputBuffer;
import antlr.LexerSharedInputState;
import antlr.NoViableAltForCharException;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.TokenStreamRecognitionException;
import antlr.collections.impl.BitSet;
import com.rsi.idldt.core.internal.parser.IDLParserTokenTypes;
import java.io.InputStream;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Vector;

public class IDLLexer
extends CharScanner
implements IDLParserTokenTypes {
    private int currentLine = 0;
    private int currentColumn = 0;
    private Vector<Integer> lineLength = new Vector(1024, 1024);
    public static final BitSet _tokenSet_0 = new BitSet(IDLLexer.mk_tokenSet_0());
    public static final BitSet _tokenSet_1 = new BitSet(IDLLexer.mk_tokenSet_1());
    public static final BitSet _tokenSet_2 = new BitSet(IDLLexer.mk_tokenSet_2());
    public static final BitSet _tokenSet_3 = new BitSet(IDLLexer.mk_tokenSet_3());
    public static final BitSet _tokenSet_4 = new BitSet(IDLLexer.mk_tokenSet_4());

    public IDLLexer(InputStream in) {
        this((InputBuffer)new ByteBuffer(in));
        this.setTabSize(1);
    }

    public void consume() throws CharStreamException {
        char c = this.LA(1);
        super.consume();
        if (this.inputState.guessing == 0 && (c < '\u0080' || c > '\u00bf')) {
            ++this.currentColumn;
        }
    }

    public void newline() {
        super.newline();
        int i = this.currentColumn;
        if (this.currentLine > 0) {
            i += this.lineLength.elementAt(this.currentLine - 1).intValue();
        }
        this.lineLength.add(new Integer(i));
        ++this.currentLine;
        this.currentColumn = 0;
    }

    public int getOffset(Token t) {
        int i = t.getLine() - 1;
        int c = t.getColumn();
        if (i > 0) {
            c += this.lineLength.elementAt(i - 1).intValue();
        }
        return c - 1;
    }

    public IDLLexer(Reader in) {
        this((InputBuffer)new CharBuffer(in));
    }

    public IDLLexer(InputBuffer ib) {
        this(new LexerSharedInputState(ib));
    }

    public IDLLexer(LexerSharedInputState state) {
        super(state);
        this.caseSensitiveLiterals = false;
        this.setCaseSensitive(false);
        this.literals = new Hashtable();
        this.literals.put(new ANTLRHashString("switch", (CharScanner)this), new Integer(30));
        this.literals.put(new ANTLRHashString("case", (CharScanner)this), new Integer(27));
        this.literals.put(new ANTLRHashString("for", (CharScanner)this), new Integer(18));
        this.literals.put(new ANTLRHashString("endswitch", (CharScanner)this), new Integer(31));
        this.literals.put(new ANTLRHashString("end", (CharScanner)this), new Integer(5));
        this.literals.put(new ANTLRHashString("inherits", (CharScanner)this), new Integer(38));
        this.literals.put(new ANTLRHashString("until", (CharScanner)this), new Integer(25));
        this.literals.put(new ANTLRHashString("endwhile", (CharScanner)this), new Integer(22));
        this.literals.put(new ANTLRHashString("endif", (CharScanner)this), new Integer(15));
        this.literals.put(new ANTLRHashString("begin", (CharScanner)this), new Integer(14));
        this.literals.put(new ANTLRHashString("do", (CharScanner)this), new Integer(19));
        this.literals.put(new ANTLRHashString("function", (CharScanner)this), new Integer(7));
        this.literals.put(new ANTLRHashString("endelse", (CharScanner)this), new Integer(17));
        this.literals.put(new ANTLRHashString("forward_function", (CharScanner)this), new Integer(32));
        this.literals.put(new ANTLRHashString("endrep", (CharScanner)this), new Integer(24));
        this.literals.put(new ANTLRHashString("of", (CharScanner)this), new Integer(28));
        this.literals.put(new ANTLRHashString("endfor", (CharScanner)this), new Integer(20));
        this.literals.put(new ANTLRHashString("while", (CharScanner)this), new Integer(21));
        this.literals.put(new ANTLRHashString("endcase", (CharScanner)this), new Integer(29));
        this.literals.put(new ANTLRHashString("repeat", (CharScanner)this), new Integer(23));
        this.literals.put(new ANTLRHashString("pro", (CharScanner)this), new Integer(6));
        this.literals.put(new ANTLRHashString("if", (CharScanner)this), new Integer(12));
        this.literals.put(new ANTLRHashString("else", (CharScanner)this), new Integer(16));
        this.literals.put(new ANTLRHashString("then", (CharScanner)this), new Integer(13));
    }

    public Token nextToken() throws TokenStreamException {
        block21: while (true) {
            int _ttype = 0;
            this.setCommitToPath(false);
            this.resetText();
            try {
                try {
                    switch (this.LA(1)) {
                        case ':': {
                            this.mCOLON(true);
                            break;
                        }
                        case ',': {
                            this.mCOMMA(true);
                            break;
                        }
                        case '.': {
                            this.mPERIOD(true);
                            break;
                        }
                        case '=': {
                            this.mEQUAL(true);
                            break;
                        }
                        case '(': {
                            this.mLPAREN(true);
                            break;
                        }
                        case ')': {
                            this.mRPAREN(true);
                            break;
                        }
                        case '[': {
                            this.mLBRACKET(true);
                            break;
                        }
                        case ']': {
                            this.mRBRACKET(true);
                            break;
                        }
                        case '{': {
                            this.mLBRACE(true);
                            break;
                        }
                        case '}': {
                            this.mRBRACE(true);
                            break;
                        }
                        case '!': 
                        case '_': 
                        case 'a': 
                        case 'b': 
                        case 'c': 
                        case 'd': 
                        case 'e': 
                        case 'f': 
                        case 'g': 
                        case 'h': 
                        case 'i': 
                        case 'j': 
                        case 'k': 
                        case 'l': 
                        case 'm': 
                        case 'n': 
                        case 'o': 
                        case 'p': 
                        case 'q': 
                        case 'r': 
                        case 's': 
                        case 't': 
                        case 'u': 
                        case 'v': 
                        case 'w': 
                        case 'x': 
                        case 'y': 
                        case 'z': {
                            this.mIDENTIFIER(true);
                            break;
                        }
                        case '\"': 
                        case '\'': {
                            this.mCONSTANT(true);
                            break;
                        }
                        case '@': {
                            this.mBATCH(true);
                            break;
                        }
                        case ';': {
                            this.mCOMMENT(true);
                            break;
                        }
                        case '\t': 
                        case ' ': {
                            this.mWS(true);
                            break;
                        }
                        default: {
                            if (this.LA(1) == '$' && _tokenSet_0.member((int)this.LA(2))) {
                                this.mLINE_CONTINUATION(true);
                                break;
                            }
                            if (this.LA(1) == '&' && this.LA(2) == '&') {
                                this.mLOGICAL_AND(true);
                                break;
                            }
                            if (this.LA(1) == '$') {
                                this.mDOLLAR(true);
                                break;
                            }
                            if (this.LA(1) == '\n' || this.LA(1) == '\r' || this.LA(1) == '&') {
                                this.mNEWLINE(true);
                                break;
                            }
                            if (this.LA(1) == '\uffff') {
                                this.uponEOF();
                                this._returnToken = this.makeToken(1);
                                break;
                            }
                            this.consume();
                            continue block21;
                        }
                    }
                    if (this._returnToken == null) continue;
                    _ttype = this._returnToken.getType();
                    this._returnToken.setType(_ttype);
                    return this._returnToken;
                }
                catch (RecognitionException e) {
                    if (!this.getCommitToPath()) {
                        this.consume();
                        continue;
                    }
                    throw new TokenStreamRecognitionException(e);
                }
            }
            catch (CharStreamException cse) {
                if (cse instanceof CharStreamIOException) {
                    throw new TokenStreamIOException(((CharStreamIOException)cse).io);
                }
                throw new TokenStreamException(cse.getMessage());
            }
            break;
        }
    }

    public final void mCOLON(boolean _createToken) throws RecognitionException, CharStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 9;
        this.match(':');
        if (_createToken && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mCOMMA(boolean _createToken) throws RecognitionException, CharStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 10;
        this.match(',');
        if (_createToken && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mPERIOD(boolean _createToken) throws RecognitionException, CharStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 42;
        this.match('.');
        if (_createToken && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mEQUAL(boolean _createToken) throws RecognitionException, CharStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 11;
        this.match('=');
        if (_createToken && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mDOLLAR(boolean _createToken) throws RecognitionException, CharStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 43;
        this.match('$');
        if (_createToken && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mLPAREN(boolean _createToken) throws RecognitionException, CharStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 26;
        this.match('(');
        if (_createToken && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mRPAREN(boolean _createToken) throws RecognitionException, CharStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 39;
        this.match(')');
        if (_createToken && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mLBRACKET(boolean _createToken) throws RecognitionException, CharStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 40;
        this.match('[');
        if (_createToken && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mRBRACKET(boolean _createToken) throws RecognitionException, CharStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 41;
        this.match(']');
        if (_createToken && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mLBRACE(boolean _createToken) throws RecognitionException, CharStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 36;
        this.match('{');
        if (_createToken && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mRBRACE(boolean _createToken) throws RecognitionException, CharStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 37;
        this.match('}');
        if (_createToken && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mSQUOTE(boolean _createToken) throws RecognitionException, CharStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 45;
        this.match('\'');
        if (_createToken && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mDQUOTE(boolean _createToken) throws RecognitionException, CharStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 46;
        this.match('\"');
        if (_createToken && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mMINUS(boolean _createToken) throws RecognitionException, CharStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 34;
        this.match('-');
        if (_createToken && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mPLUS(boolean _createToken) throws RecognitionException, CharStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 33;
        this.match('+');
        if (_createToken && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mALPHA(boolean _createToken) throws RecognitionException, CharStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 47;
        this.matchRange('a', 'z');
        if (_createToken && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mUNDER(boolean _createToken) throws RecognitionException, CharStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 48;
        this.match('_');
        if (_createToken && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mBANG(boolean _createToken) throws RecognitionException, CharStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 49;
        this.match('!');
        if (_createToken && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mOCTAL_DIGIT(boolean _createToken) throws RecognitionException, CharStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 50;
        this.matchRange('0', '7');
        if (_createToken && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mDIGIT(boolean _createToken) throws RecognitionException, CharStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 51;
        this.matchRange('0', '9');
        if (_createToken && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mIDENTIFIER(boolean _createToken) throws RecognitionException, CharStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 8;
        switch (this.LA(1)) {
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': {
                this.mALPHA(false);
                break;
            }
            case '_': {
                this.mUNDER(false);
                break;
            }
            case '!': {
                this.mBANG(false);
                break;
            }
            default: {
                throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
        }
        block12: while (true) {
            switch (this.LA(1)) {
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    this.mALPHA(false);
                    continue block12;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.mDIGIT(false);
                    continue block12;
                }
                case '_': {
                    this.mUNDER(false);
                    continue block12;
                }
                case '!': {
                    this.mBANG(false);
                    continue block12;
                }
                case '$': {
                    this.mDOLLAR(false);
                    continue block12;
                }
            }
            break;
        }
        _ttype = this.testLiteralsTable(_ttype);
        if (_createToken && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mCONSTANT(boolean _createToken) throws RecognitionException, CharStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 35;
        boolean synPredMatched164 = false;
        if (this.LA(1) == '\"' && this.LA(2) >= '0' && this.LA(2) <= '7') {
            int _m164 = this.mark();
            synPredMatched164 = true;
            ++this.inputState.guessing;
            try {
                this.mDQUOTE(false);
                this.mOCTAL_DIGIT(false);
            }
            catch (RecognitionException recognitionException) {
                synPredMatched164 = false;
            }
            this.rewind(_m164);
            --this.inputState.guessing;
        }
        if (synPredMatched164) {
            this.mOCTAL_NUMBER(false);
        } else if (this.LA(1) == '\"' || this.LA(1) == '\'') {
            this.mSTRING(false);
        } else {
            throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
        }
        if (_createToken && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mOCTAL_NUMBER(boolean _createToken) throws RecognitionException, CharStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 53;
        this.mDQUOTE(false);
        int _cnt178 = 0;
        while (true) {
            if (this.LA(1) < '0' || this.LA(1) > '7') {
                if (_cnt178 >= 1) break;
                throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
            this.mOCTAL_DIGIT(false);
            ++_cnt178;
        }
        if (_createToken && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mSTRING(boolean _createToken) throws RecognitionException, CharStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 52;
        switch (this.LA(1)) {
            case '\'': {
                this.mSQUOTE(false);
                while (true) {
                    if (this.LA(1) == '\'' && this.LA(2) == '\'') {
                        this.mSQUOTE(false);
                        this.mSQUOTE(false);
                        continue;
                    }
                    if (!_tokenSet_1.member((int)this.LA(1))) break;
                    this.match(_tokenSet_1);
                }
                if (this.LA(1) != '\'') break;
                this.mSQUOTE(false);
                break;
            }
            case '\"': {
                this.mDQUOTE(false);
                while (true) {
                    if (this.LA(1) == '\"' && this.LA(2) == '\"') {
                        this.mDQUOTE(false);
                        this.mDQUOTE(false);
                        continue;
                    }
                    if (!_tokenSet_2.member((int)this.LA(1))) break;
                    this.match(_tokenSet_2);
                }
                if (this.LA(1) != '\"') break;
                this.mDQUOTE(false);
                break;
            }
            default: {
                throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
        }
        if (_createToken && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mSIGN(boolean _createToken) throws RecognitionException, CharStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 54;
        switch (this.LA(1)) {
            case '+': {
                this.mPLUS(false);
                break;
            }
            case '-': {
                this.mMINUS(false);
                break;
            }
            default: {
                throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
        }
        if (_createToken && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mBATCH(boolean _createToken) throws RecognitionException, CharStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 55;
        this.match('@');
        while (_tokenSet_3.member((int)this.LA(1))) {
            this.match(_tokenSet_3);
        }
        if (this.inputState.guessing == 0) {
            _ttype = -1;
        }
        if (_createToken && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mLINE_CONTINUATION(boolean _createToken) throws RecognitionException, CharStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 56;
        this.match('$');
        while (_tokenSet_4.member((int)this.LA(1))) {
            this.match(_tokenSet_4);
        }
        int _cnt193 = 0;
        while (true) {
            if (this.LA(1) == '\n' || this.LA(1) == '\r' || this.LA(1) == ';') {
                switch (this.LA(1)) {
                    case ';': {
                        this.mCOMMENT(false);
                        break;
                    }
                    case '\n': 
                    case '\r': {
                        break;
                    }
                    default: {
                        throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                    }
                }
                this.mNL(false);
                while (this.LA(1) == '\t' || this.LA(1) == ' ') {
                    this.mWS(false);
                }
            } else {
                if (_cnt193 >= 1) break;
                throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
            ++_cnt193;
        }
        if (this.inputState.guessing == 0) {
            _ttype = -1;
        }
        if (_createToken && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mCOMMENT(boolean _createToken) throws RecognitionException, CharStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 57;
        this.match(';');
        while (_tokenSet_3.member((int)this.LA(1))) {
            this.match(_tokenSet_3);
        }
        if (this.inputState.guessing == 0) {
            _ttype = -1;
        }
        if (_createToken && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mNL(boolean _createToken) throws RecognitionException, CharStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 59;
        boolean synPredMatched202 = false;
        if (this.LA(1) == '\r' && this.LA(2) == '\n') {
            int _m202 = this.mark();
            synPredMatched202 = true;
            ++this.inputState.guessing;
            try {
                this.match('\r');
                this.match('\n');
            }
            catch (RecognitionException recognitionException) {
                synPredMatched202 = false;
            }
            this.rewind(_m202);
            --this.inputState.guessing;
        }
        if (synPredMatched202) {
            this.match('\r');
            this.match('\n');
        } else if (this.LA(1) == '\r') {
            this.match('\r');
        } else if (this.LA(1) == '\n') {
            this.match('\n');
        } else {
            throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
        }
        if (this.inputState.guessing == 0) {
            this.newline();
        }
        if (_createToken && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mWS(boolean _createToken) throws RecognitionException, CharStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 60;
        switch (this.LA(1)) {
            case ' ': {
                this.match(' ');
                break;
            }
            case '\t': {
                this.match('\t');
                break;
            }
            default: {
                throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
        }
        if (this.inputState.guessing == 0) {
            _ttype = -1;
        }
        if (_createToken && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mLOGICAL_AND(boolean _createToken) throws RecognitionException, CharStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 58;
        this.match('&');
        this.match('&');
        if (this.inputState.guessing == 0) {
            _ttype = -1;
        }
        if (_createToken && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mNEWLINE(boolean _createToken) throws RecognitionException, CharStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 4;
        switch (this.LA(1)) {
            case '\n': 
            case '\r': {
                this.mNL(false);
                break;
            }
            case '&': {
                this.match('&');
                break;
            }
            default: {
                throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
        }
        if (_createToken && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    private static final long[] mk_tokenSet_0() {
        long[] data = new long[260];
        data[0] = -8L;
        int i = 1;
        while (i <= 3) {
            data[i] = -1L;
            ++i;
        }
        i = 64;
        while (i <= 127) {
            data[i] = -1L;
            ++i;
        }
        return data;
    }

    private static final long[] mk_tokenSet_1() {
        long[] data = new long[260];
        data[0] = -549755823112L;
        int i = 1;
        while (i <= 3) {
            data[i] = -1L;
            ++i;
        }
        i = 64;
        while (i <= 127) {
            data[i] = -1L;
            ++i;
        }
        return data;
    }

    private static final long[] mk_tokenSet_2() {
        long[] data = new long[260];
        data[0] = -17179878408L;
        int i = 1;
        while (i <= 3) {
            data[i] = -1L;
            ++i;
        }
        i = 64;
        while (i <= 127) {
            data[i] = -1L;
            ++i;
        }
        return data;
    }

    private static final long[] mk_tokenSet_3() {
        long[] data = new long[260];
        data[0] = -9224L;
        int i = 1;
        while (i <= 3) {
            data[i] = -1L;
            ++i;
        }
        i = 64;
        while (i <= 127) {
            data[i] = -1L;
            ++i;
        }
        return data;
    }

    private static final long[] mk_tokenSet_4() {
        long[] data = new long[260];
        data[0] = -576460752303432712L;
        int i = 1;
        while (i <= 3) {
            data[i] = -1L;
            ++i;
        }
        i = 64;
        while (i <= 127) {
            data[i] = -1L;
            ++i;
        }
        return data;
    }
}

