/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core.internal.model;

import com.rsi.idldt.core.ICommandHistory;
import com.rsi.idldt.core.ICommandHistoryListener;
import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.IHistoricalCommand;
import com.rsi.idldt.core.internal.model.HistoricalCommand;
import com.rsi.jdml.CommandFinishedDTO;
import com.rsi.jdml.DMLAccess;
import com.rsi.jdml.RecallHistoryList;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;

public class CommandHistory
implements ICommandHistory {
    private final AbstractList<IHistoricalCommand> m_commands = new ArrayList<IHistoricalCommand>(100);
    private int m_currentCommand;
    private final AbstractList<ICommandHistoryListener> m_listeners = new Vector<ICommandHistoryListener>(1);
    private boolean m_bUpdateIsCommandAdded = false;
    private int m_ndxLastCmdMatch = 0;
    private String pendingCommand = "";
    private static final SimpleDateFormat formatter = new SimpleDateFormat("<!-- dd-MMM-yyyy HH:mm:ss.SS -->", Locale.US);

    public void initializeHistory(RecallHistoryList rhistory) {
        this.m_commands.clear();
        for (String rbuf : rhistory) {
            String cmdText;
            if (rbuf.length() == 0) continue;
            String cmdTS = "";
            int pos = rbuf.lastIndexOf("<!-- ");
            if (pos <= 0) {
                cmdText = rbuf;
            } else {
                cmdText = rbuf.substring(0, pos - 1);
                cmdTS = rbuf.substring(pos);
            }
            if (cmdText.length() == 0) continue;
            if (cmdTS.length() == 0) {
                this.m_commands.add(new HistoricalCommand(cmdText, null));
                continue;
            }
            try {
                Date cmdDate = formatter.parse(cmdTS);
                this.m_commands.add(new HistoricalCommand(cmdText, cmdDate));
            }
            catch (ParseException parseException) {}
        }
        this.m_currentCommand = this.m_commands.size();
        this.m_bUpdateIsCommandAdded = false;
        this.dispatchChangeListeners();
    }

    public boolean IsDuplicateLastCommand(String newCmd) {
        IHistoricalCommand cmd = this.getLastCommand();
        if (cmd == null || cmd.getText().length() == 0) {
            return false;
        }
        return cmd.getText().equals(newCmd);
    }

    public final synchronized void addCommand(IHistoricalCommand cmd) {
        String cmdText = cmd.getText();
        if (!cmdText.equals("") && !this.IsDuplicateLastCommand(cmdText)) {
            this.m_commands.add(cmd);
        }
        this.m_currentCommand = this.m_commands.size();
        this.m_bUpdateIsCommandAdded = true;
        this.dispatchChangeListeners();
    }

    public void addCommand(String cmd) {
        if (cmd.length() > 0) {
            this.pendingCommand = cmd;
        }
    }

    public void commandFinished(CommandFinishedDTO dto) {
        String timestamp = dto.getTimestamp();
        this.m_currentCommand = this.m_commands.size();
        if (this.pendingCommand.length() == 0 || this.IsDuplicateLastCommand(this.pendingCommand)) {
            this.m_currentCommand = this.m_commands.size();
            return;
        }
        if (timestamp.length() == 0) {
            this.m_commands.add(new HistoricalCommand(this.pendingCommand, null));
        } else {
            try {
                Date cmdDate = formatter.parse(timestamp.trim());
                this.m_commands.add(new HistoricalCommand(this.pendingCommand, cmdDate));
            }
            catch (ParseException parseException) {
                this.m_commands.add(new HistoricalCommand(this.pendingCommand, null));
            }
        }
        this.pendingCommand = "";
        this.m_currentCommand = this.m_commands.size();
        this.m_bUpdateIsCommandAdded = true;
        if (!DMLAccess.exitDoneSeen(IDLProcessManager.getActiveProcess().getDebugID())) {
            this.dispatchChangeListeners();
        }
    }

    public void removeCommand(IHistoricalCommand cmd) {
        if (!cmd.getText().equals("")) {
            this.m_commands.remove(cmd);
        }
        this.m_currentCommand = this.m_commands.size();
        this.m_bUpdateIsCommandAdded = false;
        this.dispatchChangeListeners();
    }

    public String previous() {
        --this.m_currentCommand;
        this.boundCurrent();
        return this.getCurrentCommandText();
    }

    public String next() {
        ++this.m_currentCommand;
        this.boundCurrent();
        return this.getCurrentCommandText();
    }

    private void boundCurrent() {
        if (this.m_currentCommand >= this.m_commands.size()) {
            this.m_currentCommand = this.m_commands.size();
        } else if (this.m_currentCommand < 0) {
            this.m_currentCommand = -1;
        }
    }

    public String getCurrentCommandText() {
        IHistoricalCommand cmd = null;
        cmd = this.getCommandN(this.m_currentCommand);
        if (cmd == null) {
            return "";
        }
        return cmd.getText();
    }

    public String getCommandMatch(String Phrase, boolean bNewMatch) {
        int ndxStartSearch;
        if (Phrase.length() == 0) {
            return "";
        }
        if (bNewMatch) {
            if (this.m_commands.size() == 0) {
                this.m_ndxLastCmdMatch = 0;
                return "";
            }
            this.m_ndxLastCmdMatch = this.m_commands.size();
        }
        if ((ndxStartSearch = this.m_ndxLastCmdMatch - 1) < 0) {
            ndxStartSearch = this.m_commands.size() - 1;
        }
        int ndx = ndxStartSearch;
        String prevMatch = bNewMatch ? "" : this.m_commands.get(this.m_ndxLastCmdMatch).getText().toLowerCase();
        String phraseToMatch = Phrase.toLowerCase();
        do {
            String cmd;
            String lower;
            boolean bMatch;
            boolean bl = bMatch = (lower = (cmd = this.m_commands.get(ndx).getText()).toLowerCase()).startsWith(phraseToMatch) && !lower.equals(prevMatch);
            if (bMatch) {
                this.m_ndxLastCmdMatch = ndx;
                return cmd;
            }
            if (--ndx >= 0) continue;
            ndx = this.m_commands.size() - 1;
        } while (ndx != ndxStartSearch);
        return "";
    }

    public IHistoricalCommand getCommandN(int n) {
        IHistoricalCommand cmd;
        try {
            cmd = this.m_commands.get(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            cmd = null;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            cmd = null;
        }
        return cmd;
    }

    public IHistoricalCommand[] getCommands() {
        return this.m_commands.toArray(new IHistoricalCommand[0]);
    }

    public int getSize() {
        return this.m_commands.size();
    }

    public IHistoricalCommand getLastCommand() {
        if (this.m_commands.size() == 0) {
            return null;
        }
        return this.m_commands.get(this.m_commands.size() - 1);
    }

    public void addCommandHistoryListener(ICommandHistoryListener l) {
        if (l != null && !this.m_listeners.contains(l)) {
            this.m_listeners.add(l);
        }
    }

    public void removeCommandHistoryListener(ICommandHistoryListener l) {
        if (l != null) {
            this.m_listeners.remove(l);
        }
    }

    private void dispatchChangeListeners() {
        if (this.m_listeners != null && this.m_listeners.size() > 0) {
            ICommandHistoryListener listener = null;
            int i = 0;
            while (i < this.m_listeners.size()) {
                listener = this.m_listeners.get(i);
                listener.commandHistoryChanged();
                ++i;
            }
        }
    }

    public boolean IsUpdateCommandAdded() {
        return this.m_bUpdateIsCommandAdded;
    }

    public synchronized void reset() {
        this.m_commands.clear();
        this.m_currentCommand = 0;
        this.m_bUpdateIsCommandAdded = false;
        this.dispatchChangeListeners();
    }
}

